/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.filter;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FilterByMetadata
extends NamedWarpScriptFunction
implements WarpScriptFilterFunction {
    private final Set<Metadata> metadatas = new HashSet<Metadata>();

    public FilterByMetadata(String name, List<GeoTimeSerie> selector) {
        super(name);
        for (GeoTimeSerie gts : selector) {
            this.metadatas.add(gts.getMetadata());
        }
    }

    @Override
    public List<GeoTimeSerie> filter(Map<String, String> labels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        ArrayList<GeoTimeSerie> retained = new ArrayList<GeoTimeSerie>();
        for (List<GeoTimeSerie> serie : series) {
            for (GeoTimeSerie gts : serie) {
                Metadata meta = gts.getMetadata();
                if (!this.metadatas.contains(meta)) continue;
                retained.add(gts);
            }
        }
        return retained;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(" ");
        for (Metadata metadata : this.metadatas) {
            sb.append(StackUtils.toString(GTSHelper.buildSelector(metadata)));
            sb.append(" ");
            sb.append("PARSESELECTOR");
            sb.append(" ");
            sb.append("NEWGTS");
            sb.append(" ");
            sb.append("SWAP");
            sb.append(" ");
            sb.append("RELABEL");
            sb.append(" ");
            sb.append("SWAP");
            sb.append(" ");
            sb.append("RENAME");
            sb.append(" ");
        }
        sb.append("]");
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object arg = stack.pop();
            if (!(arg instanceof List)) {
                throw new WarpScriptException(this.getName() + " expects a list of GTS on top of the stack.");
            }
            for (Object o : (List)arg) {
                if (o instanceof GeoTimeSerie) continue;
                throw new WarpScriptException(this.getName() + " expects a list of GTS on top of the stack.");
            }
            stack.push(new FilterByMetadata(this.getName(), (List)arg));
            return stack;
        }
    }
}

