/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.filter;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFilterFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FilterLastGT
extends NamedWarpScriptFunction
implements WarpScriptFilterFunction {
    private final GeoTimeSerie.TYPE type;
    private final Object threshold;

    public FilterLastGT(String name, Object threshold) throws WarpScriptException {
        super(name);
        if (threshold instanceof Long) {
            this.type = GeoTimeSerie.TYPE.LONG;
            this.threshold = threshold;
        } else if (threshold instanceof Double) {
            this.type = GeoTimeSerie.TYPE.DOUBLE;
            this.threshold = threshold;
        } else if (threshold instanceof String) {
            this.type = GeoTimeSerie.TYPE.STRING;
            this.threshold = threshold;
        } else {
            throw new WarpScriptException("Invalid threshold type.");
        }
    }

    @Override
    public List<GeoTimeSerie> filter(Map<String, String> labels, List<GeoTimeSerie> ... series) throws WarpScriptException {
        ArrayList<GeoTimeSerie> retained = new ArrayList<GeoTimeSerie>();
        for (List<GeoTimeSerie> gtsinstances : series) {
            for (GeoTimeSerie serie : gtsinstances) {
                Object last = GTSHelper.getLastValue(serie);
                if (null == last) continue;
                switch (this.type) {
                    case LONG: {
                        if (((Long)this.threshold).compareTo(((Number)last).longValue()) >= 0) break;
                        retained.add(serie);
                        break;
                    }
                    case DOUBLE: {
                        if (((Double)this.threshold).compareTo(((Number)last).doubleValue()) >= 0) break;
                        retained.add(serie);
                        break;
                    }
                    case STRING: {
                        if (((String)this.threshold).compareTo(last.toString()) >= 0) break;
                        retained.add(serie);
                    }
                }
            }
        }
        return retained;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.threshold));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object threshold = stack.pop();
            stack.push(new FilterLastGT(this.getName(), threshold));
            return stack;
        }
    }
}

