/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.store.Constants;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ADDMONTHS
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public ADDMONTHS(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a number of months on top of the stack.");
        }
        int months = ((Number)top).intValue();
        top = stack.pop();
        String tz = null;
        if (top instanceof String) {
            tz = top.toString();
            top = stack.pop();
            if (!(top instanceof Long)) {
                throw new WarpScriptException(this.getName() + " operates on a tselements list, timestamp, or timestamp and timezone.");
            }
        } else if (!(top instanceof List) && !(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " operates on a tselements list, timestamp, or timestamp and timezone.");
        }
        if (top instanceof Long) {
            long instant = ((Number)top).longValue();
            if (null == tz) {
                tz = "UTC";
            }
            DateTimeZone dtz = DateTimeZone.forID((String)tz);
            DateTime dt = new DateTime(instant / Constants.TIME_UNITS_PER_MS, dtz);
            dt = dt.plusMonths(months);
            long ts = dt.getMillis() * Constants.TIME_UNITS_PER_MS + instant % Constants.TIME_UNITS_PER_MS;
            stack.push(ts);
        } else {
            ArrayList<Long> elts = new ArrayList<Long>((List)top);
            int year = ((Number)elts.get(0)).intValue();
            int month = ((Number)elts.get(1)).intValue();
            if (months < 0) {
                while (months < 0) {
                    ++months;
                    if (--month >= 1) continue;
                    month = 12;
                    --year;
                }
            } else {
                while (months > 0) {
                    --months;
                    if (++month <= 12) continue;
                    month = 1;
                    ++year;
                }
            }
            elts.set(0, Long.valueOf(year));
            elts.set(1, Long.valueOf(month));
            if (elts.size() > 2) {
                int day = ((Number)elts.get(2)).intValue();
                if (2 == month && day > 28) {
                    if (0 != year % 4 || 0 == year % 100) {
                        elts.set(2, 28L);
                    } else {
                        elts.set(2, 29L);
                    }
                } else if (day > 30 && (4 == month || 6 == month || 9 == month || 11 == month)) {
                    elts.set(2, 30L);
                }
            }
            stack.push(elts);
        }
        return stack;
    }
}

