/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.ATINDEX;
import java.util.List;

public class ATBUCKET
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public ATBUCKET(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects an index on top of the stack.");
        }
        int idx = ((Number)o).intValue();
        o = stack.pop();
        if (!(o instanceof GeoTimeSerie)) {
            throw new WarpScriptException(this.getName() + " expects a Geo Time Series instance on top of the stack.");
        }
        GeoTimeSerie gts = (GeoTimeSerie)o;
        if (!GTSHelper.isBucketized(gts)) {
            throw new WarpScriptException(this.getName() + " expects the Geo Time Series on top of the stack to be bucketized.");
        }
        int bucketcount = GTSHelper.getBucketCount(gts);
        if (idx >= bucketcount) {
            throw new WarpScriptException(this.getName() + " cannot retrieve bucket " + idx + " of a GTS with " + bucketcount + " buckets.");
        }
        long lastbucket = GTSHelper.getLastBucket(gts);
        long bucketspan = GTSHelper.getBucketSpan(gts);
        GTSHelper.sort(gts);
        long tick = lastbucket - (long)(bucketcount - 1 - idx) * bucketspan;
        idx = GTSHelper.indexAtTick(gts, tick);
        List<Object> result = ATINDEX.getTupleAtIndex(gts, idx);
        stack.push(result);
        return stack;
    }
}

