/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.oss.CryptoHelper;
import io.warp10.continuum.Tokens;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.quasar.token.thrift.data.ReadToken;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.nio.charset.StandardCharsets;
import java.util.Random;

public class AUTHENTICATE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final byte[] KEY = new byte[32];

    public AUTHENTICATE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        if (null != stack.getAttribute("stack.token")) {
            throw new WarpScriptException("Stack is already authenticated.");
        }
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a string on top of the stack.");
        }
        ReadToken rtoken = Tokens.extractReadToken(o.toString());
        stack.setAttribute("stack.token", AUTHENTICATE.hide(o.toString()));
        return stack;
    }

    public static String hide(String token) {
        byte[] bytes = token.getBytes(StandardCharsets.UTF_8);
        bytes = CryptoHelper.wrapBlob((byte[])KEY, (byte[])bytes);
        bytes = OrderPreservingBase64.encode(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    public static String unhide(String hidden) {
        byte[] bytes = hidden.getBytes(StandardCharsets.US_ASCII);
        bytes = OrderPreservingBase64.decode(bytes);
        bytes = CryptoHelper.unwrapBlob((byte[])KEY, (byte[])bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static {
        new Random().nextBytes(KEY);
    }
}

