/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpDist;
import io.warp10.continuum.Tokens;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.MetadataIterator;
import io.warp10.continuum.store.thrift.data.DirectoryRequest;
import io.warp10.continuum.store.thrift.data.MetaSet;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.crypto.CryptoUtils;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.LISTTO;
import io.warp10.script.functions.PARSESELECTOR;
import io.warp10.script.functions.TOLIST;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class FIND
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private WarpScriptStackFunction toList = new TOLIST("");
    private WarpScriptStackFunction listTo = new LISTTO("");
    private final boolean elements;
    private final boolean metaset;
    private byte[] METASETS_KEY;

    public FIND(String name, boolean elements) {
        super(name);
        this.elements = elements;
        this.metaset = false;
        this.METASETS_KEY = null;
    }

    public FIND(String name, boolean elements, boolean metaset) {
        super(name);
        if (elements && metaset) {
            throw new RuntimeException("Invalid parameter combination.");
        }
        this.elements = false;
        this.metaset = metaset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        if (this.metaset && null == this.METASETS_KEY) {
            var2_2 = FIND.class;
            // MONITORENTER : io.warp10.script.functions.FIND.class
            this.METASETS_KEY = WarpDist.getKeyStore().getKey("warp.aes.metasets");
            // MONITOREXIT : var2_2
        }
        if (this.metaset && null == this.METASETS_KEY) {
            throw new WarpScriptException(this.getName() + " is disabled, as no key is set in '" + "warp.aes.metasets" + "'.");
        }
        top = stack.peek();
        hasUUIDFlag = false;
        mapparams = false;
        if (top instanceof List) {
            if (!this.metaset) {
                if (3 != ((List)top).size() && 4 != ((List)top).size()) {
                    stack.drop();
                    throw new WarpScriptException(this.getName() + " expects 3 or 4 parameters.");
                }
                this.listTo.apply(stack);
                n = stack.pop();
                hasUUIDFlag = 4 == ((Number)n).intValue() ? Boolean.TRUE.equals(stack.pop()) : false;
            } else {
                if (7 != ((List)top).size()) {
                    throw new WarpScriptException(this.getName() + " expects 7 parameters.");
                }
                this.listTo.apply(stack);
                n = stack.pop();
            }
        } else {
            if (!(top instanceof Map)) {
                if (this.metaset == false) throw new WarpScriptException(this.getName() + " expects a list or map of parameters.");
                throw new WarpScriptException(this.getName() + " expects a list of parameters.");
            }
            if (this.metaset) {
                throw new WarpScriptException(this.getName() + " expects a list of parameters on top of the stack.");
            }
            mapparams = ((Map)top).containsKey("token") != false && (((Map)top).containsKey("selectors") != false || ((Map)top).containsKey("selector") != false || ((Map)top).containsKey("class") != false && ((Map)top).containsKey("labels") != false);
        }
        set = null;
        labelSelectors = null;
        classSelector = null;
        token = null;
        activeAfter = null;
        quietAfter = null;
        drequest = null;
        if (mapparams) {
            top = stack.pop();
            params = this.paramsFromMap((Map)top);
            if (params.containsKey("selpairs")) {
                selectors = (List)params.get("selpairs");
                for (i = 0; i < selectors.size(); ++i) {
                    csel = (String)((Pair)selectors.get(i)).getLeft();
                    lsel = (Map)((Pair)selectors.get(i)).getRight();
                    drequest = new DirectoryRequest();
                    drequest.addToClassSelectors(csel);
                    drequest.addToLabelsSelectors(lsel);
                }
            } else {
                if (params.containsKey("class") == false) throw new WarpScriptException(this.getName() + " missing parameters '" + "class" + "', '" + "labels" + "', '" + "selector" + "' or '" + "selectors" + "'.");
                if (params.containsKey("labels") == false) throw new WarpScriptException(this.getName() + " missing parameters '" + "class" + "', '" + "labels" + "', '" + "selector" + "' or '" + "selectors" + "'.");
                classSelector = (String)params.get("class");
                labelSelectors = new HashMap<K, V>((Map)params.get("labels"));
            }
            token = (String)params.get("token");
            activeAfter = (Long)params.get("active.after");
            quietAfter = (Long)params.get("quiet.after");
        } else {
            if (this.metaset) {
                set = new MetaSet();
                top = stack.pop();
                if (!(top instanceof Long)) {
                    throw new WarpScriptException(this.getName() + " expects a metaset TTL (in time units) on top of the stack.");
                }
                set.setExpiry(System.currentTimeMillis() + (Long)top / Constants.TIME_UNITS_PER_MS);
                top = stack.pop();
                if (!(top instanceof Long)) {
                    if (top instanceof Double == false) throw new WarpScriptException(this.getName() + " expects a maximum duration or NaN below the expiration.");
                    if (!Double.isNaN((Double)top)) {
                        throw new WarpScriptException(this.getName() + " expects a maximum duration or NaN below the expiration.");
                    }
                }
                if (top instanceof Long) {
                    set.setMaxduration((Long)top);
                }
                if (!((top = stack.pop()) instanceof Long)) {
                    if (top instanceof Double == false) throw new WarpScriptException(this.getName() + " expects a 'notafter' parameter below the maximum duration.");
                    if (!Double.isNaN((Double)top)) {
                        throw new WarpScriptException(this.getName() + " expects a 'notafter' parameter below the maximum duration.");
                    }
                }
                if (top instanceof Long) {
                    set.setNotafter((Long)top);
                }
                if (!((top = stack.pop()) instanceof Long)) {
                    if (top instanceof Double == false) throw new WarpScriptException(this.getName() + " expects a 'notbefore' parameter below 'notafter'.");
                    if (!Double.isNaN((Double)top)) {
                        throw new WarpScriptException(this.getName() + " expects a 'notbefore' parameter below 'notafter'.");
                    }
                }
                if (top instanceof Long) {
                    set.setNotafter((Long)top);
                }
            }
            if (!((oLabelsSelector = stack.pop()) instanceof Map)) {
                throw new WarpScriptException("Label selectors must be a map.");
            }
            labelSelectors = new HashMap<String, String>((Map)oLabelsSelector);
            oClassSelector = stack.pop();
            if (!(oClassSelector instanceof String)) {
                throw new WarpScriptException("Class selector must be a string.");
            }
            classSelector = (String)oClassSelector;
            oToken = stack.pop();
            if (!(oToken instanceof String)) {
                throw new WarpScriptException("Token must be a string.");
            }
            token = (String)oToken;
        }
        directoryClient = stack.getDirectoryClient();
        rtoken = Tokens.extractReadToken(token);
        labelSelectors.remove(".producer");
        labelSelectors.remove(".owner");
        labelSelectors.remove(".app");
        labelSelectors.putAll(Tokens.labelSelectorsFromReadToken(rtoken));
        clsSels = new ArrayList<String>();
        lblsSels = new ArrayList<Map<String, String>>();
        clsSels.add(classSelector);
        lblsSels.add(labelSelectors);
        metadatas = null;
        if (this.metaset) {
            set.setToken(token);
        }
        iter = null;
        try {
            if (null == drequest) {
                drequest = new DirectoryRequest();
                drequest.setClassSelectors(clsSels);
                drequest.setLabelsSelectors(lblsSels);
            } else if (drequest.isSetLabelsSelectors()) {
                for (Map<String, String> sel : drequest.getLabelsSelectors()) {
                    sel.remove(".producer");
                    sel.remove(".owner");
                    sel.remove(".app");
                    sel.putAll(Tokens.labelSelectorsFromReadToken(rtoken));
                }
            }
            if (null != activeAfter) {
                drequest.setActiveAfter(activeAfter);
            }
            if (null != quietAfter) {
                drequest.setQuietAfter(quietAfter);
            }
            iter = directoryClient.iterator(drequest);
        }
        catch (Exception e) {
            throw new WarpScriptException(e);
        }
        gtsLimit = (Long)stack.getAttribute("gts.limit");
        gtscount = (AtomicLong)stack.getAttribute("gts.count");
        series = null;
        classes = null;
        labels = null;
        attributes = null;
        if (!this.elements) {
            if (!this.metaset) {
                series = new ArrayList<GeoTimeSerie>();
            }
        } else {
            classes = new HashSet<String>();
            labels = new HashMap<String, HashSet<String>>();
            attributes = new HashMap<String, HashSet<String>>();
        }
lbl163:
        // 3 sources

        try {
            while (iter.hasNext()) {
                block71: {
                    metadata = (Metadata)iter.next();
                    if (!this.elements) break block71;
                    classes.add(metadata.getName());
                    if (metadata.getLabelsSize() > 0) {
                        for (Map.Entry<String, String> entry : metadata.getLabels().entrySet()) {
                            values /* !! */  = (HashSet<String>)labels.get(entry.getKey());
                            if (null == values /* !! */ ) {
                                values /* !! */  = new HashSet<String>();
                                labels.put(entry.getKey(), values /* !! */ );
                            }
                            values /* !! */ .add(entry.getValue());
                        }
                    }
                    if (metadata.getAttributesSize() <= 0) continue;
                    for (Map.Entry<String, String> entry : metadata.getAttributes().entrySet()) {
                        values /* !! */  = (Set)attributes.get(entry.getKey());
                        if (null == values /* !! */ ) {
                            values /* !! */  = new HashSet<E>();
                            attributes.put(entry.getKey(), values /* !! */ );
                        }
                        values /* !! */ .add(entry.getValue());
                    }
                    ** GOTO lbl163
                }
                if (gtscount.incrementAndGet() > gtsLimit) {
                    throw new WarpScriptException(this.getName() + " exceeded limit of " + gtsLimit + " Geo Time Series, current count is " + gtscount.get());
                }
                gts = new GeoTimeSerie();
                gts.safeSetMetadata(metadata);
                if (hasUUIDFlag) {
                    uuid = new UUID(gts.getClassId(), gts.getLabelsId());
                    gts.getMetadata().putToAttributes(".uuid", uuid.toString());
                }
                if (!this.metaset) {
                    gtslabels = new HashMap<String, String>();
                    gtslabels.putAll(gts.getLabels());
                    gtslabels.remove(".producer");
                    gtslabels.remove(".owner");
                    gts.setLabels(gtslabels);
                    series.add(gts);
                    continue;
                }
                set.addToMetadatas(gts.getMetadata());
            }
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            if (iter instanceof MetadataIterator) {
                try {
                    iter.close();
                }
                catch (Exception metadata) {}
            }
        }
        if (!this.elements) {
            if (!this.metaset) {
                stack.push(series);
                return stack;
            }
            serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
            try {
                serialized = serializer.serialize((TBase)set);
                baos = new ByteArrayOutputStream();
                out = new GZIPOutputStream(baos);
                out.write(serialized);
                out.close();
                compressed = baos.toByteArray();
                wrapped = CryptoUtils.wrap(this.METASETS_KEY, compressed);
                stack.push(new String(OrderPreservingBase64.encode(wrapped), StandardCharsets.UTF_8));
                return stack;
            }
            catch (IOException | TException e) {
                throw new WarpScriptException(this.getName() + " unable to build MetaSet.", e);
            }
        }
        list = new ArrayList<String>();
        list.addAll(classes);
        stack.push(list);
        map = new HashMap<K, ArrayList<String>>();
        for (Map.Entry<K, V> entry : labels.entrySet()) {
            list = new ArrayList<E>();
            list.addAll((Collection)entry.getValue());
            map.put(entry.getKey(), list);
        }
        stack.push(map);
        map = new HashMap<K, V>();
        var27_34 = attributes.entrySet().iterator();
        while (true) {
            if (!var27_34.hasNext()) {
                stack.push(map);
                return stack;
            }
            entry = var27_34.next();
            list = new ArrayList<E>();
            list.addAll((Collection)entry.getValue());
            map.put(entry.getKey(), list);
        }
    }

    private Map<String, Object> paramsFromMap(Map<String, Object> map) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!map.containsKey("token")) {
            throw new WarpScriptException(this.getName() + " Missing '" + "token" + "' parameter");
        }
        params.put("token", map.get("token"));
        if (map.containsKey("selectors")) {
            Object sels = map.get("selectors");
            if (!(sels instanceof List)) {
                throw new WarpScriptException(this.getName() + " Invalid parameter '" + "selectors" + "'");
            }
            ArrayList<Pair> selectors = new ArrayList<Pair>();
            for (Object sel : (List)sels) {
                Object[] clslbls = PARSESELECTOR.parse(sel.toString());
                selectors.add(Pair.of((Object)clslbls[0], (Object)clslbls[1]));
            }
            params.put("selpairs", selectors);
        } else if (map.containsKey("selector")) {
            Object[] clslbls = PARSESELECTOR.parse(map.get("selector").toString());
            params.put("class", clslbls[0]);
            params.put("labels", clslbls[1]);
        } else if (map.containsKey("class") && map.containsKey("labels")) {
            params.put("class", map.get("class"));
            params.put("labels", map.get("labels"));
        }
        if (map.containsKey("active.after")) {
            if (!(map.get("active.after") instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + "active.after" + "'.");
            }
            params.put("active.after", (Long)map.get("active.after") / Constants.TIME_UNITS_PER_MS);
        }
        if (map.containsKey("quiet.after")) {
            if (!(map.get("quiet.after") instanceof Long)) {
                throw new WarpScriptException(this.getName() + " Invalid type for parameter '" + "quiet.after" + "'.");
            }
            params.put("quiet.after", (Long)map.get("quiet.after") / Constants.TIME_UNITS_PER_MS);
        }
        return params;
    }
}

