/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class GEOPACK
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public GEOPACK(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof GeoXPLib.GeoXPShape)) {
            throw new WarpScriptException(this.getName() + " expects a shape on top of the stack.");
        }
        GeoXPLib.GeoXPShape shape = (GeoXPLib.GeoXPShape)o;
        stack.push(GEOPACK.pack(shape));
        return stack;
    }

    public static String pack(GeoXPLib.GeoXPShape shape) throws WarpScriptException {
        long[] cells = GeoXPLib.getCells((GeoXPLib.GeoXPShape)shape);
        GTSEncoder encoder = new GTSEncoder();
        try {
            for (long cell : cells) {
                encoder.addValue(cell, 91480763316633925L, Long.MIN_VALUE, true);
            }
        }
        catch (IOException ioe) {
            throw new WarpScriptException(ioe);
        }
        GTSWrapper wrapper = GTSWrapperHelper.fromGTSEncoderToGTSWrapper(encoder, true);
        TSerializer serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
        try {
            byte[] serialized = serializer.serialize((TBase)wrapper);
            return new String(OrderPreservingBase64.encode(serialized, 0, serialized.length), StandardCharsets.US_ASCII);
        }
        catch (TException te) {
            throw new WarpScriptException(te);
        }
    }
}

