/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSDecoder;
import io.warp10.continuum.gts.GTSEncoder;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GTSWrapperHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.GTSWrapper;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.ElementOrListStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class GOLDWRAP
extends ElementOrListStackFunction {
    private final ElementOrListStackFunction.ElementStackFunction function = this.generateFunctionOnce();

    public GOLDWRAP(String name) {
        super(name);
    }

    private ElementOrListStackFunction.ElementStackFunction generateFunctionOnce() {
        return new ElementOrListStackFunction.ElementStackFunction(){

            @Override
            public Object applyOnElement(Object element) throws WarpScriptException {
                GTSEncoder encoder = null;
                boolean sortedEncoder = false;
                try {
                    if (element instanceof GeoTimeSerie) {
                        encoder = new GTSEncoder(0L);
                        GTSHelper.fullsort((GeoTimeSerie)element, false);
                        sortedEncoder = true;
                        encoder.encodeOptimized((GeoTimeSerie)element);
                    } else if (element instanceof GTSEncoder) {
                        encoder = (GTSEncoder)element;
                    } else if (element instanceof String || element instanceof byte[]) {
                        TDeserializer deser = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
                        byte[] bytes = element instanceof String ? OrderPreservingBase64.decode(element.toString().getBytes(StandardCharsets.US_ASCII)) : (byte[])element;
                        GTSWrapper wrapper = new GTSWrapper();
                        deser.deserialize((TBase)wrapper, bytes);
                        encoder = GTSWrapperHelper.fromGTSWrapperToGTSEncoder(wrapper);
                    } else {
                        throw new WarpScriptException(GOLDWRAP.this.getName() + " can only be applied to Geo Time Series\u2122, GTS Encoders or wrapped instances of those types.");
                    }
                    GTSEncoder enc = null;
                    if (sortedEncoder) {
                        enc = encoder;
                    } else {
                        GeoTimeSerie[] gts = new GeoTimeSerie[5];
                        for (int i = 0; i < gts.length; ++i) {
                            gts[i] = new GeoTimeSerie();
                        }
                        GTSDecoder decoder = encoder.getDecoder();
                        while (decoder.next()) {
                            long ts = decoder.getTimestamp();
                            long location = decoder.getLocation();
                            long elevation = decoder.getElevation();
                            Object value = decoder.getBinaryValue();
                            if (value instanceof Long) {
                                GTSHelper.setValue(gts[0], ts, location, elevation, value, false);
                                continue;
                            }
                            if (value instanceof Double || value instanceof BigDecimal) {
                                GTSHelper.setValue(gts[1], ts, location, elevation, value, false);
                                continue;
                            }
                            if (value instanceof Boolean) {
                                GTSHelper.setValue(gts[2], ts, location, elevation, value, false);
                                continue;
                            }
                            if (value instanceof String) {
                                GTSHelper.setValue(gts[3], ts, location, elevation, value, false);
                                continue;
                            }
                            if (!(value instanceof byte[])) continue;
                            GTSHelper.setValue(gts[4], ts, location, elevation, value, false);
                        }
                        for (int i = 0; i < gts.length; ++i) {
                            GTSHelper.fullsort(gts[i], false);
                        }
                        enc = new GTSEncoder(0L);
                        enc.setMetadata(encoder.getMetadata());
                        int[] idx = new int[gts.length];
                        while (true) {
                            int gtsidx = -1;
                            long ts = Long.MAX_VALUE;
                            for (int i = 0; i < gts.length; ++i) {
                                if (idx[i] >= GTSHelper.nvalues(gts[i])) continue;
                                long tick = GTSHelper.tickAtIndex(gts[i], idx[i]);
                                if (-1 != gtsidx && tick >= ts) continue;
                                gtsidx = i;
                                ts = tick;
                            }
                            if (-1 == gtsidx) break;
                            do {
                                long location = GTSHelper.locationAtIndex(gts[gtsidx], idx[gtsidx]);
                                long elevation = GTSHelper.elevationAtIndex(gts[gtsidx], idx[gtsidx]);
                                Object value = GTSHelper.valueAtIndex(gts[gtsidx], idx[gtsidx]);
                                if (4 == gtsidx) {
                                    value = value.toString().getBytes(StandardCharsets.ISO_8859_1);
                                } else if (2 == gtsidx) {
                                    value = GTSEncoder.optimizeValue(value);
                                }
                                enc.addValue(ts, location, elevation, value);
                                int n = gtsidx;
                                idx[n] = idx[n] + 1;
                            } while (idx[gtsidx] < GTSHelper.nvalues(gts[gtsidx]) && GTSHelper.tickAtIndex(gts[gtsidx], idx[gtsidx]) == ts);
                        }
                    }
                    GTSWrapper wrapper = GTSWrapperHelper.fromGTSEncoderToGTSWrapper(enc, true, 1.0, Integer.MAX_VALUE);
                    TSerializer ser = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
                    byte[] bytes = ser.serialize((TBase)wrapper);
                    return bytes;
                }
                catch (TException te) {
                    throw new WarpScriptException(GOLDWRAP.this.getName() + " encountered an error while deserializing GTS Wrapper.", te);
                }
                catch (IOException ioe) {
                    throw new WarpScriptException(GOLDWRAP.this.getName() + " encountered an error while deserializing GTS Wrapper.", ioe);
                }
            }
        };
    }

    @Override
    public ElementOrListStackFunction.ElementStackFunction generateFunction(WarpScriptStack stack) throws WarpScriptException {
        return this.function;
    }
}

