/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import com.google.common.primitives.Longs;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class HHCODETO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean useGtsConvention;

    public HHCODETO(String name) {
        this(name, false);
    }

    public HHCODETO(String name, boolean useGtsConvention) {
        super(name);
        this.useGtsConvention = useGtsConvention;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        long hh;
        Object hhcode = stack.pop();
        if (hhcode instanceof Long) {
            hh = (Long)hhcode;
        } else if (hhcode instanceof String) {
            String hhstr = hhcode.toString();
            if (hhstr.length() > 16) {
                throw new WarpScriptException(this.getName() + " expects an hexadecimal HHCode string of length <= 16");
            }
            if (hhstr.length() < 16) {
                hhcode = new StringBuilder(hhstr).append("0000000000000000");
                ((StringBuilder)hhcode).setLength(16);
            }
            hh = Long.parseUnsignedLong(hhcode.toString(), 16);
        } else if (hhcode instanceof byte[]) {
            hh = Longs.fromByteArray((byte[])((byte[])hhcode));
        } else {
            throw new WarpScriptException(this.getName() + " expects a long, a string or a byte array.");
        }
        if (this.useGtsConvention && 91480763316633925L == hh) {
            stack.push(Double.NaN);
            stack.push(Double.NaN);
        } else {
            double[] latlon = GeoXPLib.fromGeoXPPoint((long)hh);
            stack.push(latlon[0]);
            stack.push(latlon[1]);
        }
        return stack;
    }
}

