/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.HashMap;
import java.util.Map;

public class INTEGRATE
extends GTSStackFunction {
    private static final String INITIAL_VALUE = "initial.value";

    public INTEGRATE(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof Number)) {
            throw new WarpScriptException(this.getName() + " expects a numeric initial value on top of the stack.");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(INITIAL_VALUE, ((Number)o).doubleValue());
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        double initialValue = (Double)params.get(INITIAL_VALUE);
        GeoTimeSerie integrated = GTSHelper.integrate(gts, initialValue);
        return integrated;
    }
}

