/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.boon.core.value.CharSequenceValue;
import org.boon.json.JsonException;
import org.boon.json.JsonParserAndMapper;
import org.boon.json.JsonParserFactory;

public class JSONTO
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final JsonParserFactory BOON_PARSER_FACTORY = new JsonParserFactory();

    public JSONTO(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " expects a string on top of the stack.");
        }
        JsonParserAndMapper parser = BOON_PARSER_FACTORY.create();
        Object json = null;
        try {
            json = parser.parse(o.toString());
        }
        catch (JsonException je) {
            throw new WarpScriptException("Error parsing JSON", je);
        }
        stack.push(JSONTO.transform(json));
        return stack;
    }

    private static final Object transform(Object json) {
        if (json instanceof List) {
            List l = (List)json;
            ArrayList<Object> target = new ArrayList<Object>();
            for (int i = 0; i < l.size(); ++i) {
                target.add(JSONTO.transform(l.get(i)));
            }
            return target;
        }
        if (json instanceof Map) {
            Map map = (Map)json;
            HashMap<Object, Object> target = new HashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                target.put(JSONTO.transform(entry.getKey()), JSONTO.transform(entry.getValue()));
            }
            return target;
        }
        if (json instanceof Integer) {
            return ((Integer)json).longValue();
        }
        if (json instanceof CharSequenceValue) {
            return ((CharSequenceValue)json).stringValue();
        }
        return json;
    }
}

