/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptFillerFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.MACROMAPPER;
import java.util.ArrayList;
import java.util.List;

public class MACROFILLER
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public MACROFILLER(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a 'post' window length on top of the stack.");
        }
        int postWindow = ((Number)top).intValue();
        top = stack.pop();
        if (!(top instanceof Long)) {
            throw new WarpScriptException(this.getName() + " expects a 'pre' window length below the 'post' window length.");
        }
        int preWindow = ((Number)top).intValue();
        top = stack.pop();
        if (!(top instanceof WarpScriptStack.Macro)) {
            throw new WarpScriptException(this.getName() + " operates on a MACRO.");
        }
        stack.push(new MacroFillerWrapper(this.getName(), stack, (WarpScriptStack.Macro)top, preWindow, postWindow));
        return stack;
    }

    public static class MacroFillerWrapper
    extends NamedWarpScriptFunction
    implements WarpScriptFillerFunction {
        private final WarpScriptStack stack;
        private final WarpScriptStack.Macro macro;
        private final int preWindow;
        private final int postWindow;

        public MacroFillerWrapper(String name, WarpScriptStack stack, WarpScriptStack.Macro macro, int preWindow, int postWindow) {
            super(name);
            this.stack = stack;
            this.macro = macro;
            this.preWindow = preWindow;
            this.postWindow = postWindow;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("<%");
            sb.append(" ");
            sb.append(this.macro.toString());
            sb.append(" ");
            sb.append(this.preWindow);
            sb.append(" ");
            sb.append(this.postWindow);
            sb.append(" ");
            sb.append(this.getName());
            sb.append(" ");
            sb.append("%>");
            sb.append(" ");
            sb.append("EVAL");
            return sb.toString();
        }

        @Override
        public int getPreWindow() {
            return this.preWindow;
        }

        @Override
        public int getPostWindow() {
            return this.postWindow;
        }

        @Override
        public Object[] apply(Object[] args) throws WarpScriptException {
            GeoTimeSerie gts = new GeoTimeSerie(0);
            gts.safeSetMetadata((Metadata)((Object[])args[0])[0]);
            this.stack.push(gts);
            gts = new GeoTimeSerie(0);
            gts.safeSetMetadata((Metadata)((Object[])args[0])[1]);
            this.stack.push(gts);
            long ts = 0L;
            ArrayList ticks = new ArrayList(this.preWindow);
            for (int i = 1; i < args.length; ++i) {
                ArrayList<Object> tick = new ArrayList<Object>(5);
                Object[] atick = (Object[])args[i];
                if (null == atick[0] || null == atick[3]) {
                    tick.add(null);
                    tick.add(Double.NaN);
                    tick.add(Double.NaN);
                    tick.add(Double.NaN);
                    tick.add(null);
                } else {
                    tick.add(atick[0]);
                    if (91480763316633925L != ((Number)atick[1]).longValue()) {
                        double[] latlon = GeoXPLib.fromGeoXPPoint((long)((Number)atick[1]).longValue());
                        tick.add(latlon[0]);
                        tick.add(latlon[1]);
                    } else {
                        tick.add(Double.NaN);
                        tick.add(Double.NaN);
                    }
                    if (Long.MIN_VALUE != ((Number)atick[2]).longValue()) {
                        tick.add(((Number)atick[2]).longValue());
                    } else {
                        tick.add(Double.NaN);
                    }
                    tick.add(atick[3]);
                }
                ticks.add(tick);
                if (this.preWindow == i) {
                    this.stack.push(ticks);
                    ticks = new ArrayList();
                    continue;
                }
                if (this.preWindow + 1 != i) continue;
                ts = ((Number)tick.get(0)).longValue();
                this.stack.push(tick);
                ticks = new ArrayList(this.postWindow);
            }
            this.stack.push(ticks);
            this.stack.push(ts);
            this.stack.exec(this.macro);
            Object res = this.stack.peek();
            if (res instanceof List) {
                this.stack.drop();
                return MACROMAPPER.listToObjects((List)res);
            }
            throw new WarpScriptException("Expected a [ ts lat lon elev value ] list as result of filler.");
        }

        public WarpScriptStack.Macro getMacro() {
            return this.macro;
        }
    }
}

