/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.Revision;
import io.warp10.WarpConfig;
import io.warp10.crypto.SipHashInline;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLib;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.sensision.Sensision;
import io.warp10.warp.sdk.AbstractWarp10Plugin;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class REPORT
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final Logger LOG = LoggerFactory.getLogger(REPORT.class);
    private static final String SECRET;

    public REPORT(String name) {
        super(name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top = stack.pop();
        if (!SECRET.equals(top.toString())) {
            throw new WarpScriptException(this.getName() + " invalid secret.");
        }
        try {
            void var8_15;
            StringBuilder sb = new StringBuilder();
            sb.append("\n[revision]\n");
            sb.append(Revision.REVISION);
            sb.append("\n");
            sb.append("\n[jvm]\n");
            sb.append("free=");
            sb.append(Runtime.getRuntime().freeMemory());
            sb.append("\n");
            sb.append("total=");
            sb.append(Runtime.getRuntime().totalMemory());
            sb.append("\n");
            sb.append("max=");
            sb.append(Runtime.getRuntime().maxMemory());
            sb.append("\n");
            sb.append("cpus=");
            sb.append(Runtime.getRuntime().availableProcessors());
            sb.append("\n");
            sb.append("\n[sensision]\n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Sensision.dump((PrintWriter)pw);
            pw.close();
            sb.append(sw.toString());
            sb.append("\n[extensions]\n");
            for (String string : WarpScriptLib.extensions()) {
                sb.append(string);
                sb.append("\n");
            }
            sb.append("\n[plugins]\n");
            for (String string : AbstractWarp10Plugin.plugins()) {
                sb.append(string);
                sb.append("\n");
            }
            sb.append("\n[config]\n");
            Properties properties = WarpConfig.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                if (key.contains(".key") || key.contains(".aes") || key.contains(".hash") || key.contains(".mac") || key.contains(".psk") || key.contains(".secret")) continue;
                sb.append(key);
                sb.append("=");
                String value = entry.getValue().toString();
                sb.append(value);
                sb.append("\n");
            }
            byte[] byArray = sb.toString().getBytes(StandardCharsets.UTF_8);
            boolean bl = false;
            for (Object b : (String)byArray) {
                if (10 != b) continue;
                ++var8_15;
            }
            long sip = SipHashInline.hash24(byArray.length, byArray.length, byArray, 0, byArray.length);
            sb.insert(0, "\n");
            sb.insert(0, Long.toHexString(sip));
            sb.insert(0, ".");
            sb.insert(0, (int)var8_15);
            sb.insert(0, ".");
            sb.insert(0, System.currentTimeMillis());
            sb.insert(0, "[report]\n");
            stack.push(sb.toString());
        }
        catch (Exception e) {
            throw new WarpScriptException("Error while generating report.");
        }
        return stack;
    }

    static {
        String defaultSecret = UUID.randomUUID().toString();
        if (defaultSecret.equals(SECRET = WarpConfig.getProperty("warp10.report.secret", defaultSecret))) {
            LOG.info("REPORT secret not set, using '" + defaultSecret + "'.");
            System.out.println("REPORT secret not set, using '" + defaultSecret + "'.");
        }
    }
}

