/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import com.geoxp.GeoXPLib;
import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.continuum.store.Constants;
import io.warp10.continuum.store.thrift.data.Metadata;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SMARTPARSE
extends GTSStackFunction {
    private static final String VGROUPS = "vgroups";
    private static final String LGROUPS = "lgroups";
    private static final String TGROUPS = "tgroups";
    private static final String MATCHER = "matcher";
    private static final String LAT = "lat";
    private static final String LON = "lon";
    private static final String ELEV = "elev";

    public SMARTPARSE(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        if (stack.get(0) instanceof String && stack.get(1) instanceof String) {
            Map<String, Object> params = this.retrieveParameters(stack);
            List vgroups = (List)params.get(VGROUPS);
            List lgroups = (List)params.get(LGROUPS);
            List tgroups = (List)params.get(TGROUPS);
            Matcher matcher = (Matcher)params.get(MATCHER);
            String lat = (String)params.get(LAT);
            String lon = (String)params.get(LON);
            String elev = (String)params.get(ELEV);
            HashMap<Metadata, GeoTimeSerie> results = new HashMap<Metadata, GeoTimeSerie>();
            HashMap<String, String> labels = new HashMap<String, String>();
            String val = stack.pop().toString();
            long timestamp = 0L;
            SMARTPARSE.doParse(val, timestamp, vgroups, lgroups, tgroups, matcher, lat, lon, elev, labels, results);
            stack.push(new ArrayList(results.values()));
            return stack;
        }
        return super.apply(stack);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String regexp = stack.pop().toString();
        Pattern pattern = Pattern.compile(regexp);
        Pattern namedgrouppattern = Pattern.compile("\\(\\?<([a-zA-Z][a-zA-Z0-9]*)>");
        Matcher namedgroup = namedgrouppattern.matcher(regexp);
        ArrayList<String> vgroups = new ArrayList<String>();
        ArrayList<String> lgroups = new ArrayList<String>();
        ArrayList<String> tgroups = new ArrayList<String>();
        while (namedgroup.find()) {
            String group = namedgroup.group(1);
            if (group.startsWith("V")) {
                vgroups.add(group);
                continue;
            }
            if (group.startsWith("L")) {
                lgroups.add(group);
                continue;
            }
            if (group.startsWith("T")) {
                tgroups.add(group);
                continue;
            }
            if (group.equals(LAT)) {
                params.put(LAT, group);
                continue;
            }
            if (group.equals(LON)) {
                params.put(LON, group);
                continue;
            }
            if (!group.equals(ELEV)) continue;
            params.put(ELEV, group);
        }
        Matcher matcher = pattern.matcher("");
        params.put(MATCHER, matcher);
        params.put(VGROUPS, vgroups);
        params.put(LGROUPS, lgroups);
        params.put(TGROUPS, tgroups);
        return params;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        List vgroups = (List)params.get(VGROUPS);
        List lgroups = (List)params.get(LGROUPS);
        List tgroups = (List)params.get(TGROUPS);
        Matcher matcher = (Matcher)params.get(MATCHER);
        String lat = (String)params.get(LAT);
        String lon = (String)params.get(LON);
        String elev = (String)params.get(ELEV);
        HashMap<Metadata, GeoTimeSerie> results = new HashMap<Metadata, GeoTimeSerie>();
        int n = GTSHelper.nvalues(gts);
        HashMap<String, String> labels = new HashMap<String, String>();
        for (int idx = 0; idx < n; ++idx) {
            String val = GTSHelper.valueAtIndex(gts, idx).toString();
            long timestamp = GTSHelper.tickAtIndex(gts, idx);
            SMARTPARSE.doParse(val, timestamp, vgroups, lgroups, tgroups, matcher, lat, lon, elev, labels, results);
        }
        return new ArrayList(results.values());
    }

    private static void doParse(String val, long timestamp, List<String> vgroups, List<String> lgroups, List<String> tgroups, Matcher matcher, String lat, String lon, String elev, Map<String, String> labels, Map<Metadata, GeoTimeSerie> results) {
        matcher.reset(val);
        while (matcher.find()) {
            String groupval;
            labels.clear();
            for (String group : lgroups) {
                String groupval2 = matcher.group(group);
                if (null == groupval2) continue;
                labels.put(group.substring(1), groupval2);
            }
            long location = 91480763316633925L;
            long elevation = Long.MIN_VALUE;
            if (null != lat && null != lon) {
                String latval = matcher.group(lat);
                String lonval = matcher.group(lon);
                if (null != latval && null != lonval) {
                    location = GeoXPLib.toGeoXPPoint((double)Double.parseDouble(latval), (double)Double.parseDouble(lonval));
                }
            }
            if (null != elev) {
                String elevval = matcher.group(elev);
                if (null != elevval) {
                    elevation = Math.round(Double.parseDouble(elevval));
                }
                if (elev.equals("elevm")) {
                    elevation *= 1000L;
                } else if (elev.equals("elevft")) {
                    elevation *= 3048L;
                } else if (elev.equals("elevkm")) {
                    elevation *= 1000000L;
                } else if (elev.equals("elevmi")) {
                    elevation *= 1609340L;
                } else if (elev.equals("elevnm")) {
                    elevation *= 1852000L;
                } else if (elev.equals("elevcm")) {
                    elevation *= 10L;
                }
            }
            for (String group : tgroups) {
                groupval = matcher.group(group);
                if (null == groupval) continue;
                Double ts = null;
                if (group.startsWith("Ts")) {
                    ts = Double.parseDouble(groupval) * (double)Constants.TIME_UNITS_PER_S;
                } else if (group.startsWith("Tms")) {
                    ts = Double.parseDouble(groupval) * (double)Constants.TIME_UNITS_PER_MS;
                } else if (group.startsWith("Tus")) {
                    ts = Double.parseDouble(groupval);
                    ts = ts / (1000000.0 / (double)Constants.TIME_UNITS_PER_S);
                } else if (group.startsWith("Tns")) {
                    ts = Double.parseDouble(groupval);
                    ts = ts / (1.0E9 / (double)Constants.TIME_UNITS_PER_S);
                }
                if (null == ts) continue;
                timestamp = ts.longValue();
                break;
            }
            for (String group : vgroups) {
                groupval = matcher.group(group);
                if (null == groupval) continue;
                Object value = null;
                if ('L' == group.charAt(1)) {
                    value = Long.parseLong(groupval);
                } else if ('D' == group.charAt(1)) {
                    value = Double.parseDouble(groupval);
                } else if ('B' == group.charAt(1)) {
                    value = Boolean.parseBoolean(groupval);
                } else if ('S' == group.charAt(1)) {
                    value = groupval;
                }
                if (null == value) continue;
                Metadata meta = new Metadata();
                meta.setLabels(new HashMap<String, String>(labels));
                meta.setName(group.substring(2));
                GeoTimeSerie g = results.get(meta);
                if (null == g) {
                    g = new GeoTimeSerie();
                    g.setMetadata(meta);
                    results.put(meta, g);
                }
                GTSHelper.setValue(g, timestamp, location, elevation, value, false);
            }
        }
    }
}

