/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.continuum.gts.GTSHelper;
import io.warp10.continuum.gts.GeoTimeSerie;
import io.warp10.script.GTSStackFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class STL
extends GTSStackFunction {
    public static final String PERIOD_PARAM = "PERIOD";
    public static final String PRECISION_PARAM = "PRECISION";
    public static final String ROBUSTNESS_PARAM = "ROBUSTNESS";
    public static final String ROBUST_PARAM = "ROBUST";
    public static final String BANDWIDTH_S_PARAM = "BANDWIDTH_S";
    public static final String DEGREE_S_PARAM = "DEGREE_S";
    public static final String SPEED_S_PARAM = "SPEED_S";
    public static final String BANDWIDTH_L_PARAM = "BANDWIDTH_L";
    public static final String DEGREE_L_PARAM = "DEGREE_L";
    public static final String SPEED_L_PARAM = "SPEED_L";
    public static final String BANDWIDTH_T_PARAM = "BANDWIDTH_T";
    public static final String DEGREE_T_PARAM = "DEGREE_T";
    public static final String SPEED_T_PARAM = "SPEED_T";
    public static final String BANDWIDTH_P_PARAM = "BANDWIDTH_P";
    public static final String DEGREE_P_PARAM = "DEGREE_P";
    public static final String SPEED_P_PARAM = "SPEED_P";

    public STL(String name) {
        super(name);
    }

    @Override
    protected Map<String, Object> retrieveParameters(WarpScriptStack stack) throws WarpScriptException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object top = stack.pop();
        if (!(top instanceof Map)) {
            throw new WarpScriptException(this.getName() + " expects a map of parameters below input GTS");
        }
        String[] field_names_1 = new String[]{PERIOD_PARAM, PRECISION_PARAM, ROBUSTNESS_PARAM};
        String[] field_names_2 = new String[]{"BANDWIDTH", "DEGREE", "SPEED"};
        String[] suffixes = new String[]{"_S", "_L", "_T", "_P"};
        Map last_params = (Map)top;
        for (Map.Entry entry : last_params.entrySet()) {
            String key = (String)entry.getKey();
            String body = key.substring(0, key.length() - 2);
            String suffix = key.substring(key.length() - 2, key.length());
            Object value = entry.getValue();
            if (key.equals(ROBUST_PARAM)) {
                if (!(value instanceof Boolean)) {
                    throw new WarpScriptException(this.getName() + " expects argument " + key + " to be of type BOOLEAN.");
                }
                params.put(key, (boolean)((Boolean)value));
                continue;
            }
            if (!(Arrays.asList(field_names_1).contains(key) || Arrays.asList(field_names_2).contains(body) && Arrays.asList(suffixes).contains(suffix) || Arrays.asList(field_names_2).contains(key))) {
                throw new WarpScriptException(this.getName() + " does not expect argument " + key);
            }
            if (!(value instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects argument " + key + " to be of type LONG.");
            }
            if (null != params.get(key)) continue;
            params.put(key, ((Number)value).intValue());
        }
        for (int u = 0; u < 3; ++u) {
            Object o = params.get(field_names_2[u]);
            if (null == o) continue;
            for (int v = 0; v < 4; ++v) {
                String to_put = field_names_2[u] + suffixes[v];
                if (null != params.get(to_put)) continue;
                params.put(to_put, ((Number)o).intValue());
            }
        }
        return params;
    }

    private int nextOdd(int a) {
        if (a > 0) {
            return 1 == a / 2 ? a : a + 1;
        }
        return 1;
    }

    @Override
    protected Object gtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        int jp;
        int outer;
        if (null == params.get(PERIOD_PARAM)) {
            throw new WarpScriptException(this.getName() + " expects map of parameters to at least contains field PERIOD");
        }
        int buckets_per_period = ((Number)params.get(PERIOD_PARAM)).intValue();
        if (null == params.get(ROBUST_PARAM)) {
            params.put(ROBUST_PARAM, false);
        }
        int inner = (Boolean)params.get(ROBUST_PARAM) != false ? 1 : 2;
        int n = outer = (Boolean)params.get(ROBUST_PARAM) != false ? 15 : 0;
        if (null != params.get(PRECISION_PARAM)) {
            inner = ((Number)params.get(PRECISION_PARAM)).intValue();
        }
        if (null != params.get(ROBUSTNESS_PARAM)) {
            outer = ((Number)params.get(ROBUSTNESS_PARAM)).intValue();
        }
        int ns = null == params.get(BANDWIDTH_S_PARAM) ? 7 : ((Number)params.get(BANDWIDTH_S_PARAM)).intValue();
        int ds = null == params.get(DEGREE_S_PARAM) ? 1 : ((Number)params.get(DEGREE_S_PARAM)).intValue();
        int js = null == params.get(SPEED_S_PARAM) ? ns / 10 : ((Number)params.get(SPEED_S_PARAM)).intValue();
        int nl = null == params.get(BANDWIDTH_L_PARAM) ? this.nextOdd(buckets_per_period) : ((Number)params.get(BANDWIDTH_L_PARAM)).intValue();
        int dl = null == params.get(DEGREE_L_PARAM) ? 1 : ((Number)params.get(DEGREE_L_PARAM)).intValue();
        int jl = null == params.get(SPEED_L_PARAM) ? nl / 10 : ((Number)params.get(SPEED_L_PARAM)).intValue();
        int value = (int)Math.ceil(1.5 * (double)buckets_per_period / (1.0 - 1.5 / (double)ns));
        int nt = null == params.get(BANDWIDTH_T_PARAM) ? this.nextOdd(value) : ((Number)params.get(BANDWIDTH_T_PARAM)).intValue();
        int dt = null == params.get(DEGREE_T_PARAM) ? 1 : ((Number)params.get(DEGREE_T_PARAM)).intValue();
        int jt = null == params.get(SPEED_T_PARAM) ? nt / 10 : ((Number)params.get(SPEED_T_PARAM)).intValue();
        int np = null == params.get(BANDWIDTH_P_PARAM) ? 0 : ((Number)params.get(BANDWIDTH_P_PARAM)).intValue();
        int dp = null == params.get(DEGREE_P_PARAM) ? 2 : ((Number)params.get(DEGREE_P_PARAM)).intValue();
        int n2 = jp = null == params.get(SPEED_P_PARAM) ? np / 10 : ((Number)params.get(SPEED_P_PARAM)).intValue();
        if (buckets_per_period < 2) {
            throw new WarpScriptException("Seasonal periods must be composed by at least 2 buckets.");
        }
        if (inner < 1) {
            throw new WarpScriptException("PRECISION must be positive.");
        }
        if (outer < 0) {
            throw new WarpScriptException("ROBUSTNESS can not be negative.");
        }
        if (0 == ns) {
            throw new WarpScriptException("BANDWIDTH_S can not be equal to zero.");
        }
        if (ds < 0) {
            throw new WarpScriptException("DEGREE_S can not be negative.");
        }
        if (js < 0) {
            throw new WarpScriptException("SPEED_S can not be negative.");
        }
        if (nl < 0) {
            throw new WarpScriptException("BANDWIDTH_L can not be negative..");
        }
        if (dl < 0) {
            throw new WarpScriptException("DEGREE_L can not be negative.");
        }
        if (jl < 0) {
            throw new WarpScriptException("SPEED_L can not be negative.");
        }
        if (nt < 0) {
            throw new WarpScriptException("BANDWIDTH_T can not be negative..");
        }
        if (dt < 0) {
            throw new WarpScriptException("DEGREE_T can not be negative.");
        }
        if (jt < 0) {
            throw new WarpScriptException("SPEED_T can not be negative.");
        }
        if (np < 0) {
            throw new WarpScriptException("BANDWIDTH_P can not be negative.");
        }
        if (dp < 0) {
            throw new WarpScriptException("DEGREE_P can not be negative.");
        }
        if (jp < 0) {
            throw new WarpScriptException("SPEED_P can not be negative.");
        }
        List<Object> results = new ArrayList();
        results = GTSHelper.stl(gts, buckets_per_period, inner, outer, ns, ds, js, nl, dl, jl, nt, dt, jt, np, dp, jp);
        return results;
    }

    public Object doGtsOp(Map<String, Object> params, GeoTimeSerie gts) throws WarpScriptException {
        return this.gtsOp(params, gts);
    }
}

