/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;

public class SUBLIST
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    public SUBLIST(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        List indices = null;
        List elements = null;
        ArrayList<Long> longParams = new ArrayList<Long>();
        for (int i = 0; i < 4; ++i) {
            Object o = stack.pop();
            if (o instanceof List) {
                if (0 == i) {
                    indices = (List)o;
                    o = stack.pop();
                    if (o instanceof List) {
                        elements = (List)o;
                        break;
                    }
                    throw new WarpScriptException(this.getName() + " expects a list of indices on top of the stack and will operate on the list below it.");
                }
                elements = (List)o;
                break;
            }
            if (!(o instanceof Number)) {
                throw new WarpScriptException(this.getName() + " expects a list of indices on top of the stack or a start end step and will operate on the list below it.");
            }
            longParams.add(0, ((Number)o).longValue());
        }
        if (null == elements) {
            throw new WarpScriptException(this.getName() + " expects a list of indices on top of the stack or a start end step and will operate on the list below it.");
        }
        int size = elements.size();
        ArrayList sublist = new ArrayList();
        if (null == indices) {
            long start = (Long)longParams.get(0);
            long end = longParams.size() > 1 ? (Long)longParams.get(1) : Math.max((long)(size - 1), start);
            if (start < 0L) {
                start += (long)size;
            }
            if (end < 0L) {
                end += (long)size;
            }
            if (!(start < 0L && end < 0L || start >= (long)size && end >= (long)size)) {
                long step = 1L;
                if (longParams.size() > 2) {
                    step = (Long)longParams.get(2);
                } else if (start > end) {
                    step = -1L;
                }
                if (0L == step) {
                    throw new WarpScriptException(this.getName() + " expects the step parameter to be a strictly positive or negative number.");
                }
                if (step > 0L) {
                    if (start > end) {
                        throw new WarpScriptException(this.getName() + " expects start to be before end when step is positive.");
                    }
                } else if (end > start) {
                    throw new WarpScriptException(this.getName() + " expects start to be after end when step is negative.");
                }
                start = SUBLIST.nearestValidBound(start, step, size);
                try {
                    if (step > 0L) {
                        end = Math.min(end, (long)(size - 1));
                        long i = start;
                        while (i <= end) {
                            sublist.add(elements.get(Math.toIntExact(i)));
                            i = Math.addExact(i, step);
                        }
                    }
                    end = Math.max(end, 0L);
                    long i = start;
                    while (i >= end) {
                        sublist.add(elements.get(Math.toIntExact(i)));
                        i = Math.addExact(i, step);
                    }
                }
                catch (ArithmeticException arithmeticException) {}
            }
        } else if (2 == indices.size()) {
            Object a = indices.get(0);
            Object b = indices.get(1);
            if (!(a instanceof Long) || !(b instanceof Long)) {
                throw new WarpScriptException(this.getName() + " expects a list of indices which are numeric integers.");
            }
            int la = ((Long)a).intValue();
            int lb = ((Long)b).intValue();
            if (la < 0) {
                la = size + la;
            }
            if (lb < 0) {
                lb = size + lb;
            }
            if (la < 0 && lb < 0) {
                la = size;
                lb = size;
            } else {
                la = Math.max(0, la);
                lb = Math.max(0, lb);
            }
            if (la < size || lb < size) {
                if (la >= size) {
                    la = size - 1;
                } else if (la < -1 * size) {
                    la = -1 * size;
                }
                if (lb >= size) {
                    lb = size - 1;
                } else if (lb < -1 * size) {
                    lb = -1 * size;
                }
            }
            if (la < lb) {
                if (la < size) {
                    lb = Math.min(size - 1, lb);
                    for (int i = la; i <= lb; ++i) {
                        sublist.add(elements.get(i));
                    }
                }
            } else if (lb < size) {
                la = Math.min(size - 1, la);
                for (int i = lb; i <= la; ++i) {
                    sublist.add(elements.get(i));
                }
            }
        } else {
            for (Object index : indices) {
                if (!(index instanceof Long)) {
                    throw new WarpScriptException(this.getName() + " expects a list of indices which are numeric integers.");
                }
                int idx = ((Long)index).intValue();
                if (idx >= size || idx < -1 * size) {
                    throw new WarpScriptException(this.getName() + " reported an out of bound index.");
                }
                if (idx >= 0) {
                    sublist.add(elements.get(idx));
                    continue;
                }
                sublist.add(elements.get(size + idx));
            }
        }
        stack.push(sublist);
        return stack;
    }

    private static long nearestValidBound(long bound, long step, int size) {
        if (bound >= (long)size) {
            return (bound - (long)size) % step - Math.abs(step) + (long)size;
        }
        if (bound < 0L) {
            return (bound + 1L) % step + Math.abs(step) - 1L;
        }
        return bound;
    }
}

