/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.boon.json.JsonSerializer;
import org.boon.json.JsonSerializerFactory;

public class TOJSON
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private static final JsonSerializerFactory BOON_SERIALIZER_FACTORY = new JsonSerializerFactory();

    public TOJSON(String name) {
        super(name);
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        JsonSerializer parser = BOON_SERIALIZER_FACTORY.create();
        if (!TOJSON.validate(o)) {
            throw new WarpScriptException(this.getName() + " can only serialize structures containing numbers, strings, booleans, lists and maps which do not reference the same list/map multiple times.");
        }
        String json = parser.serialize(o).toString();
        stack.push(json);
        return stack;
    }

    private static boolean validate(Object o) {
        ArrayList<Object> elements = new ArrayList<Object>();
        int idx = 0;
        if (null == o || o instanceof Number || o instanceof String || o instanceof Boolean) {
            return true;
        }
        elements.add(o);
        while (idx < elements.size()) {
            Object obj;
            if ((obj = elements.get(idx++)) instanceof Number || obj instanceof String || obj instanceof Boolean) continue;
            if (obj instanceof List) {
                for (Object e : (List)obj) {
                    if (null == e || e instanceof Number || e instanceof String || e instanceof Boolean) continue;
                    if (e instanceof List || e instanceof Map) {
                        if (TOJSON.containsElement(elements, e)) {
                            return false;
                        }
                        elements.add(e);
                        continue;
                    }
                    return false;
                }
                continue;
            }
            if (obj instanceof Map) {
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    Object elt = entry.getKey();
                    if (!(null == elt || elt instanceof Number || elt instanceof String || elt instanceof Boolean)) {
                        if (elt instanceof List || elt instanceof Map) {
                            if (TOJSON.containsElement(elements, elt)) {
                                return false;
                            }
                            elements.add(elt);
                        } else {
                            return false;
                        }
                    }
                    if (null == (elt = entry.getValue()) || elt instanceof Number || elt instanceof String || elt instanceof Boolean) continue;
                    if (elt instanceof List || elt instanceof Map) {
                        if (TOJSON.containsElement(elements, elt)) {
                            return false;
                        }
                        elements.add(elt);
                        continue;
                    }
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean containsElement(List<Object> list, Object element) {
        for (Object o : list) {
            if (o != element) continue;
            return true;
        }
        return false;
    }
}

