/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.WarpDist;
import io.warp10.crypto.CryptoUtils;
import io.warp10.crypto.OrderPreservingBase64;
import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import io.warp10.script.functions.SECURE;
import io.warp10.script.thrift.data.SecureScript;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class UNSECURE
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final boolean checkkey;
    private static byte[] aesKey = null;

    public UNSECURE(String name, boolean checkkey) {
        super(name);
        this.checkkey = checkkey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object o = stack.pop();
        if (this.checkkey && null == stack.getAttribute("secure.key")) {
            throw new WarpScriptException("You need to set the secure key first.");
        }
        if (!(o instanceof String)) {
            throw new WarpScriptException(this.getName() + " operates on a string.");
        }
        byte[] raw = OrderPreservingBase64.decode(o.toString().getBytes(StandardCharsets.US_ASCII));
        Class<SECURE> clazz = SECURE.class;
        synchronized (SECURE.class) {
            if (null == aesKey) {
                try {
                    aesKey = WarpDist.getKeyStore().getKey("warp.aes.securescripts");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (null == aesKey) {
                throw new WarpScriptException("Missing secure script encryption key.");
            }
            byte[] unwrapped = CryptoUtils.unwrap(aesKey, raw);
            TDeserializer deserializer = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
            SecureScript sscript = new SecureScript();
            try {
                deserializer.deserialize((TBase)sscript, unwrapped);
            }
            catch (TException te) {
                throw new WarpScriptException("Unable to unsecure script.", te);
            }
            if (this.checkkey && !stack.getAttribute("secure.key").toString().equals(sscript.getKey())) {
                throw new WarpScriptException("Invalid secure key.");
            }
            if (sscript.isCompressed()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ByteArrayInputStream bais = new ByteArrayInputStream(sscript.getScript());
                try {
                    int len;
                    GZIPInputStream gzipin = new GZIPInputStream(bais);
                    byte[] buf = new byte[128];
                    while ((len = gzipin.read(buf)) >= 0) {
                        baos.write(buf, 0, len);
                    }
                    sscript.setCompressed(false);
                    sscript.setScript(baos.toByteArray());
                }
                catch (IOException ioe) {
                    throw new WarpScriptException("Unable to unsecure script.", ioe);
                }
            }
            String script = new String(sscript.getScript(), StandardCharsets.UTF_8);
            stack.push(script);
            return stack;
        }
    }
}

