/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptLoopBreakException;
import io.warp10.script.WarpScriptLoopContinueException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;

public class UNTIL
extends NamedWarpScriptFunction
implements WarpScriptStackFunction {
    private final long maxtime;

    public UNTIL(String name) {
        super(name);
        this.maxtime = -1L;
    }

    public UNTIL(String name, long maxtime) {
        super(name);
        this.maxtime = maxtime;
    }

    @Override
    public Object apply(WarpScriptStack stack) throws WarpScriptException {
        Object top;
        long maxtime;
        Object[] macros = new Object[]{stack.pop(), stack.pop()};
        for (Object macro : macros) {
            if (macro instanceof WarpScriptStack.Macro) continue;
            throw new WarpScriptException(this.getName() + " expects two macros on top of the stack.");
        }
        long now = System.currentTimeMillis();
        long l = maxtime = this.maxtime > 0L ? this.maxtime : (Long)stack.getAttribute("loop.maxduration");
        do {
            if (System.currentTimeMillis() - now > maxtime) {
                throw new WarpScriptException(this.getName() + " executed for too long (> " + maxtime + " ms).");
            }
            try {
                stack.exec((WarpScriptStack.Macro)macros[1]);
            }
            catch (WarpScriptLoopBreakException elbe) {
                break;
            }
            catch (WarpScriptLoopContinueException elbe) {
                // empty catch block
            }
            stack.exec((WarpScriptStack.Macro)macros[0]);
            top = stack.pop();
            if (top instanceof Boolean) continue;
            throw new WarpScriptException(this.getName() + " expects its 'UNTIL' macro to leave a boolean on top of the stack.");
        } while (!Boolean.TRUE.equals(top));
        return stack;
    }
}

