/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions.shape;

import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.formatted.FormattedWarpScriptFunction;
import io.warp10.script.functions.shape.SHAPE;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CHECKSHAPE
extends FormattedWarpScriptFunction {
    public static final String LIST = "list";
    public static final String RES = "result";
    private final FormattedWarpScriptFunction.Arguments args;
    private final FormattedWarpScriptFunction.Arguments output;

    @Override
    protected FormattedWarpScriptFunction.Arguments getArguments() {
        return this.args;
    }

    protected FormattedWarpScriptFunction.Arguments getOutput() {
        return this.output;
    }

    public CHECKSHAPE(String name) {
        super(name);
        this.getDocstring().append("Return a BOOLEAN indicating whether an input list and its nested lists sizes are coherent together to form a tensor (or multidimensional array).");
        this.args = new FormattedWarpScriptFunction.ArgumentsBuilder().addArgument(List.class, LIST, "The input list.").build();
        this.output = new FormattedWarpScriptFunction.ArgumentsBuilder().addListArgument(Long.class, RES, "true or false.").build();
    }

    @Override
    protected WarpScriptStack apply(Map<String, Object> formattedArgs, WarpScriptStack stack) throws WarpScriptException {
        List list = (List)formattedArgs.get(LIST);
        List<Long> candidateShape = SHAPE.candidate_shape(list);
        stack.push(CHECKSHAPE.recValidateShape(list, candidateShape));
        return stack;
    }

    private static Boolean hasNestedList(List list) {
        for (Object el : list) {
            if (!(el instanceof List)) continue;
            return true;
        }
        return false;
    }

    static Boolean recValidateShape(List list, List<Long> candidateShape) {
        ArrayList<Long> copyShape = new ArrayList<Long>(candidateShape);
        if ((long)list.size() != (Long)copyShape.remove(0)) {
            return false;
        }
        if (!CHECKSHAPE.hasNestedList(list).booleanValue()) {
            return 0 == copyShape.size();
        }
        if (0 == copyShape.size()) {
            return false;
        }
        for (Object el : list) {
            if (!(el instanceof List)) {
                return false;
            }
            if (CHECKSHAPE.recValidateShape((List)el, copyShape).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

