/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.functions.shape;

import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.formatted.FormattedWarpScriptFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HULLSHAPE
extends FormattedWarpScriptFunction {
    public static final String LIST = "list";
    public static final String SHAPE = "shape";
    private final FormattedWarpScriptFunction.Arguments args;
    private final FormattedWarpScriptFunction.Arguments output;

    @Override
    protected FormattedWarpScriptFunction.Arguments getArguments() {
        return this.args;
    }

    protected FormattedWarpScriptFunction.Arguments getOutput() {
        return this.output;
    }

    public HULLSHAPE(String name) {
        super(name);
        this.getDocstring().append("Return the shape of a tensor (or multidimensional array) that would be able to contain all the values of an input nested list. The size of the returned shape is equal to the deepest level of nesting plus one. Its i-th value is equal to the size of the largest list that is nested i levels deep.");
        this.args = new FormattedWarpScriptFunction.ArgumentsBuilder().addArgument(List.class, LIST, "The input list.").build();
        this.output = new FormattedWarpScriptFunction.ArgumentsBuilder().addListArgument(Long.class, SHAPE, "The hull shape of the input list.").build();
    }

    @Override
    protected WarpScriptStack apply(Map<String, Object> formattedArgs, WarpScriptStack stack) throws WarpScriptException {
        List list = (List)formattedArgs.get(LIST);
        stack.push(this.recHullShape(list));
        return stack;
    }

    private List<Long> maximizeHull(List<Long> a, List<Long> b) {
        List<Long> taller;
        List<Long> smaller = a.size() < b.size() ? a : b;
        List<Long> list = taller = a.size() < b.size() ? b : a;
        if (0 == smaller.size()) {
            return taller;
        }
        ArrayList<Long> res = new ArrayList<Long>(taller.size());
        while (smaller.size() > 0) {
            Long x = smaller.remove(0);
            Long y = taller.remove(0);
            res.add(x > y ? x : y);
        }
        res.addAll(taller);
        return res;
    }

    private List<Long> recHullShape(List list) {
        ArrayList<Long> res = new ArrayList<Long>();
        res.add(Long.valueOf(list.size()));
        List<Long> hull = new ArrayList<Long>();
        for (Object el : list) {
            if (!(el instanceof List)) continue;
            hull = this.maximizeHull(hull, this.recHullShape((List)el));
        }
        res.addAll(hull);
        return res;
    }
}

