/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.fwt;

public abstract class Wavelet {
    public double[] forward(double[] input, int len) {
        double[] scalingDeComposition = this.getScalingDeComposition();
        double[] waveletDeComposition = this.getWaveletDeComposition();
        int motherWavelength = this.getMotherWavelength();
        double[] output = new double[len];
        int h = output.length >> 1;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < motherWavelength; ++j) {
                int k;
                for (k = i * 2 + j; k >= output.length; k -= output.length) {
                }
                int n = i;
                output[n] = output[n] + input[k] * scalingDeComposition[j];
                int n2 = i + h;
                output[n2] = output[n2] + input[k] * waveletDeComposition[j];
            }
        }
        return output;
    }

    public double[] reverse(double[] input, int len) {
        double[] scalingReConstruction = this.getScalingReConstruction();
        double[] waveletReConstruction = this.getWaveletReConstruction();
        int motherWavelength = this.getMotherWavelength();
        double[] output = new double[len];
        int h = output.length >> 1;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < motherWavelength; ++j) {
                int k;
                for (k = i * 2 + j; k >= output.length; k -= output.length) {
                }
                int n = k;
                output[n] = output[n] + (input[i] * scalingReConstruction[j] + input[i + h] * waveletReConstruction[j]);
            }
        }
        return output;
    }

    public abstract int getMotherWavelength();

    public abstract int getTransformWavelength();

    public abstract double[] getScalingDeComposition();

    public abstract double[] getWaveletDeComposition();

    public abstract double[] getScalingReConstruction();

    public abstract double[] getWaveletReConstruction();
}

