/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.script.mapper;

import io.warp10.script.NamedWarpScriptFunction;
import io.warp10.script.StackUtils;
import io.warp10.script.WarpScriptException;
import io.warp10.script.WarpScriptMapperFunction;
import io.warp10.script.WarpScriptStack;
import io.warp10.script.WarpScriptStackFunction;
import java.util.Map;

public class MapperNPDF
extends NamedWarpScriptFunction
implements WarpScriptMapperFunction {
    private final double mu;
    private final double sigma;

    public MapperNPDF(String name, double mu, double sigma) {
        super(name);
        this.mu = mu;
        this.sigma = sigma;
    }

    @Override
    public Object apply(Object[] args) throws WarpScriptException {
        double value;
        long tick = (Long)args[0];
        String[] names = (String[])args[1];
        Map[] labels = (Map[])args[2];
        long[] ticks = (long[])args[3];
        long[] locations = (long[])args[4];
        long[] elevations = (long[])args[5];
        Object[] values = (Object[])args[6];
        if (1 != values.length) {
            throw new WarpScriptException(this.getName() + " can only be applied to a single value.");
        }
        long location = locations[0];
        long elevation = elevations[0];
        if (values[0] instanceof Long) {
            value = ((Long)values[0]).longValue();
        } else if (values[0] instanceof Double) {
            value = (Double)values[0];
        } else {
            throw new WarpScriptException(this.getName() + " can only be applied to LONG or DOUBLE values.");
        }
        double p = 1.0 / (this.sigma * Math.sqrt(Math.PI * 2)) * Math.exp(-1.0 * (value - this.mu) * (value - this.mu) / (2.0 * this.sigma * this.sigma));
        return new Object[]{tick, location, elevation, p};
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(StackUtils.toString(this.mu));
        sb.append(" ");
        sb.append(StackUtils.toString(this.sigma));
        sb.append(" ");
        sb.append(this.getName());
        return sb.toString();
    }

    public static class Builder
    extends NamedWarpScriptFunction
    implements WarpScriptStackFunction {
        public Builder(String name) {
            super(name);
        }

        @Override
        public Object apply(WarpScriptStack stack) throws WarpScriptException {
            Object value = stack.pop();
            if (!(value instanceof Double)) {
                throw new WarpScriptException(this.getName() + " expects a standard deviation (sigma) on top of the stack.");
            }
            double sigma = (Double)value;
            value = stack.pop();
            if (!(value instanceof Double)) {
                throw new WarpScriptException(this.getName() + " expects a mean (mu) below the standard deviation.");
            }
            double mu = (Double)value;
            stack.push(new MapperNPDF(this.getName(), mu, sigma));
            return stack;
        }
    }
}

