/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision;

import io.warp10.sensision.Sensision;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensisionJMXPoller {
    private static final String SENSISION_JMX_METRICS_PREFIX = "jmx.";
    private Pattern[] includedMBeans;
    private Pattern[] excludedMBeans;
    private Pattern[] includedMetrics;
    private Pattern[] excludedMetrics;
    private static final String HEXDIGITS = "0123456789abcdef";

    public SensisionJMXPoller(String agentArgs, Instrumentation instrumentation) {
        String[] tokens = null;
        tokens = null != agentArgs ? agentArgs.split(":") : new String[]{};
        for (String token : tokens) {
            int i;
            String[] subtokens;
            if (token.startsWith("metrics=")) {
                subtokens = token.substring(8).split(",");
                this.includedMetrics = new Pattern[subtokens.length];
                this.excludedMetrics = new Pattern[subtokens.length];
                i = 0;
                for (String subtoken : subtokens) {
                    try {
                        subtoken = URLDecoder.decode(subtoken, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (subtoken.startsWith("!")) {
                        this.includedMetrics[i] = null;
                        this.excludedMetrics[i] = subtoken.startsWith("~") ? Pattern.compile(subtoken.substring(1)) : (subtoken.startsWith("=") ? Pattern.compile(Pattern.quote(subtoken.substring(1))) : Pattern.compile(Pattern.quote(subtoken)));
                    } else {
                        this.excludedMetrics[i] = null;
                        this.includedMetrics[i] = subtoken.startsWith("~") ? Pattern.compile(subtoken.substring(1)) : (subtoken.startsWith("=") ? Pattern.compile(Pattern.quote(subtoken.substring(1))) : Pattern.compile(Pattern.quote(subtoken)));
                    }
                    ++i;
                }
                continue;
            }
            if (!token.startsWith("mbeans=")) continue;
            subtokens = token.substring(7).split(",");
            this.includedMBeans = new Pattern[subtokens.length];
            this.excludedMBeans = new Pattern[subtokens.length];
            i = 0;
            for (String subtoken : subtokens) {
                try {
                    subtoken = URLDecoder.decode(subtoken, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (subtoken.startsWith("!")) {
                    this.includedMBeans[i] = null;
                    this.excludedMBeans[i] = subtoken.startsWith("~") ? Pattern.compile(subtoken.substring(1)) : (subtoken.startsWith("=") ? Pattern.compile(Pattern.quote(subtoken.substring(1))) : Pattern.compile(Pattern.quote(subtoken)));
                } else {
                    this.excludedMBeans[i] = null;
                    this.includedMBeans[i] = subtoken.startsWith("~") ? Pattern.compile(subtoken.substring(1)) : (subtoken.startsWith("=") ? Pattern.compile(Pattern.quote(subtoken.substring(1))) : Pattern.compile(Pattern.quote(subtoken)));
                }
                ++i;
            }
        }
    }

    private boolean checkPatterns(String value, Pattern[] included, Pattern[] excluded) {
        if (null == included || null == excluded) {
            return true;
        }
        boolean hasIncludes = false;
        for (int i = 0; i < included.length; ++i) {
            if (null != included[i]) {
                hasIncludes = true;
                if (!included[i].matcher(value).matches()) continue;
                return true;
            }
            if (null == excluded[i] || !excluded[i].matcher(value).matches()) continue;
            return false;
        }
        return !hasIncludes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(PrintWriter pw) {
        HashSet<MBeanServer> servers = new HashSet<MBeanServer>();
        servers.add(ManagementFactory.getPlatformMBeanServer());
        servers.addAll(MBeanServerFactory.findMBeanServer(null));
        for (MBeanServer server : servers) {
            Set<ObjectName> names;
            try {
                names = server.queryNames(new ObjectName("*:*"), null);
            }
            catch (MalformedObjectNameException mone) {
                return;
            }
            for (ObjectName name : names) {
                Object v0;
                MBeanInfo info = null;
                ObjectInstance instance = null;
                try {
                    try {
                        info = server.getMBeanInfo(name);
                        instance = server.getObjectInstance(name);
                        v0 = null;
                    }
                    catch (IntrospectionException introspectionException) {
                        v0 = null;
                    }
                    catch (ReflectionException reflectionException) {
                        v0 = null;
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        v0 = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_16;
                    v0 = var12_16 = null;
                }
                if (null == info || null == instance) continue;
                // JSR Ret
            }
        }
    }

    private final void dumpMetric(PrintWriter pw, String name, Map<String, String> labels, Object value) {
        if (!this.checkPatterns(name, this.includedMetrics, this.excludedMetrics)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(System.currentTimeMillis() * Sensision.TIME_UNITS_PER_MS);
            sb.append("/");
            Sensision.addDefaultLocation(sb);
            sb.append("/");
            Sensision.addDefaultLocation(sb);
            sb.append(" ");
            sb.append(URLEncoder.encode(name, "UTF-8").replaceAll("\\{", "%7B").replaceAll("\\}", "%7D"));
            sb.append("{");
            boolean first = true;
            for (Map.Entry<String, String> entry : labels.entrySet()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(URLEncoder.encode(entry.getKey(), "UTF-8").replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll(",", "%2C"));
                sb.append("=");
                sb.append(URLEncoder.encode(entry.getValue(), "UTF-8").replaceAll("\\{", "%7B").replaceAll("\\}", "%7D").replaceAll(",", "%2C"));
                first = false;
            }
            sb.append("} ");
            if (value instanceof Long) {
                sb.append(Long.toString((Long)value));
            } else if (value instanceof Double) {
                sb.append(Double.toString((Double)value));
            } else if (value instanceof Boolean) {
                sb.append((Boolean)value != false ? "T" : "F");
            } else {
                sb.append("'");
                sb.append(URLEncoder.encode(value.toString(), "UTF-8").replaceAll("'", "%27"));
                sb.append("'");
            }
            sb.append("\r\n");
            pw.print(sb.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private final void dumpTabularData(PrintWriter pw, String name, Map<String, String> labels, TabularData td) {
        for (Object rowkey : td.keySet()) {
            if (!(rowkey instanceof List)) continue;
            HashMap<String, String> rowlabels = new HashMap<String, String>();
            rowlabels.putAll(labels);
            CompositeData cd = td.get(((List)rowkey).toArray());
            rowlabels.put("row", rowkey.toString());
            if (cd.containsKey("key") && cd.containsKey("value") && cd.values().size() == 2) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                Object k = cd.get("key");
                values.put(k.toString(), cd.get("value"));
                try {
                    CompositeType ct = new CompositeType(cd.getCompositeType().getTypeName(), cd.getCompositeType().getDescription(), new String[]{k.toString()}, new String[]{cd.getCompositeType().getDescription("value")}, new OpenType[]{cd.getCompositeType().getType("value")});
                    CompositeDataSupport cds = new CompositeDataSupport(ct, values);
                    this.dumpCompositeData(pw, name, rowlabels, cds);
                }
                catch (OpenDataException openDataException) {}
                continue;
            }
            this.dumpCompositeData(pw, name, rowlabels, cd);
        }
    }

    private final void dumpCompositeData(PrintWriter pw, String name, Map<String, String> labels, CompositeData cd) {
        StringBuilder sb = new StringBuilder(name);
        int len = sb.length();
        for (String key : cd.getCompositeType().keySet()) {
            sb.setLength(len);
            sb.append(":");
            sb.append(key);
            Object val = cd.get(key);
            if (val instanceof Long || val instanceof Integer || val instanceof Short || val instanceof Byte) {
                this.dumpMetric(pw, sb.toString(), labels, ((Number)val).longValue());
                continue;
            }
            if (val instanceof Double || val instanceof Float) {
                this.dumpMetric(pw, sb.toString(), labels, ((Number)val).doubleValue());
                continue;
            }
            if (val instanceof Boolean) {
                this.dumpMetric(pw, sb.toString(), labels, (boolean)((Boolean)val));
                continue;
            }
            if (val instanceof String) {
                this.dumpMetric(pw, sb.toString(), labels, val.toString());
                continue;
            }
            if (val instanceof TabularData) {
                this.dumpTabularData(pw, sb.toString(), labels, (TabularData)val);
                continue;
            }
            if (val instanceof CompositeData) {
                this.dumpCompositeData(pw, sb.toString(), labels, (CompositeData)val);
                continue;
            }
            this.dumpMetric(pw, sb.toString(), labels, val.toString());
        }
    }

    private final String hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(HEXDIGITS.charAt(b >>> 4));
            sb.append(HEXDIGITS.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        SensisionJMXPoller agent = new SensisionJMXPoller(agentArgs, instrumentation);
    }
}

