/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.jarjar.org.mortbay.thread;

import io.warp10.sensision.jarjar.org.mortbay.component.AbstractLifeCycle;
import io.warp10.sensision.jarjar.org.mortbay.log.Log;
import io.warp10.sensision.jarjar.org.mortbay.thread.ThreadPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class QueuedThreadPool
extends AbstractLifeCycle
implements Serializable,
ThreadPool {
    private String _name;
    private Set _threads;
    private List _idle;
    private Runnable[] _jobs;
    private int _nextJob;
    private int _nextJobSlot;
    private int _queued;
    private int _maxQueued;
    private boolean _daemon;
    private int _id;
    private final Object _lock = new Lock();
    private final Object _threadsLock = new Lock();
    private final Object _joinLock = new Lock();
    private long _lastShrink;
    private int _maxIdleTimeMs = 60000;
    private int _maxThreads = 250;
    private int _minThreads = 2;
    private boolean _warned = false;
    private int _lowThreads = 0;
    private int _priority = 5;
    private int _spawnOrShrinkAt = 0;
    private int _maxStopTimeMs;

    public QueuedThreadPool() {
        this._name = "qtp-" + this.hashCode();
    }

    public QueuedThreadPool(int maxThreads) {
        this();
        this.setMaxThreads(maxThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(Runnable job) {
        if (!this.isRunning() || job == null) {
            return false;
        }
        PoolThread thread = null;
        boolean spawn = false;
        Object object = this._lock;
        synchronized (object) {
            int idle = this._idle.size();
            if (idle > 0) {
                thread = (PoolThread)this._idle.remove(idle - 1);
            } else {
                ++this._queued;
                if (this._queued > this._maxQueued) {
                    this._maxQueued = this._queued;
                }
                this._jobs[this._nextJobSlot++] = job;
                if (this._nextJobSlot == this._jobs.length) {
                    this._nextJobSlot = 0;
                }
                if (this._nextJobSlot == this._nextJob) {
                    Runnable[] jobs = new Runnable[this._jobs.length + this._maxThreads];
                    int split = this._jobs.length - this._nextJob;
                    if (split > 0) {
                        System.arraycopy(this._jobs, this._nextJob, jobs, 0, split);
                    }
                    if (this._nextJob != 0) {
                        System.arraycopy(this._jobs, 0, jobs, split, this._nextJobSlot);
                    }
                    this._jobs = jobs;
                    this._nextJob = 0;
                    this._nextJobSlot = this._queued;
                }
                spawn = this._queued > this._spawnOrShrinkAt;
            }
        }
        if (thread != null) {
            thread.dispatch(job);
        } else if (spawn) {
            this.newThread();
        }
        return true;
    }

    public int getIdleThreads() {
        return this._idle == null ? 0 : this._idle.size();
    }

    public int getLowThreads() {
        return this._lowThreads;
    }

    public int getMaxQueued() {
        return this._maxQueued;
    }

    public int getMaxIdleTimeMs() {
        return this._maxIdleTimeMs;
    }

    public int getMaxThreads() {
        return this._maxThreads;
    }

    public int getMinThreads() {
        return this._minThreads;
    }

    public String getName() {
        return this._name;
    }

    public int getThreads() {
        return this._threads.size();
    }

    public int getThreadsPriority() {
        return this._priority;
    }

    public int getQueueSize() {
        return this._queued;
    }

    public int getSpawnOrShrinkAt() {
        return this._spawnOrShrinkAt;
    }

    public void setSpawnOrShrinkAt(int spawnOrShrinkAt) {
        this._spawnOrShrinkAt = spawnOrShrinkAt;
    }

    public int getMaxStopTimeMs() {
        return this._maxStopTimeMs;
    }

    public void setMaxStopTimeMs(int stopTimeMs) {
        this._maxStopTimeMs = stopTimeMs;
    }

    public boolean isDaemon() {
        return this._daemon;
    }

    public boolean isLowOnThreads() {
        return this._queued > this._lowThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        Object object = this._joinLock;
        synchronized (object) {
            while (this.isRunning()) {
                this._joinLock.wait();
            }
        }
        while (this.isStopping()) {
            Thread.sleep(100L);
        }
    }

    public void setDaemon(boolean daemon) {
        this._daemon = daemon;
    }

    public void setLowThreads(int lowThreads) {
        this._lowThreads = lowThreads;
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._maxIdleTimeMs = maxIdleTimeMs;
    }

    public void setMaxThreads(int maxThreads) {
        if (this.isStarted() && maxThreads < this._minThreads) {
            throw new IllegalArgumentException("!minThreads<maxThreads");
        }
        this._maxThreads = maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinThreads(int minThreads) {
        if (this.isStarted() && (minThreads <= 0 || minThreads > this._maxThreads)) {
            throw new IllegalArgumentException("!0<=minThreads<maxThreads");
        }
        this._minThreads = minThreads;
        Object object = this._threadsLock;
        synchronized (object) {
            while (this.isStarted() && this._threads.size() < this._minThreads) {
                this.newThread();
            }
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setThreadsPriority(int priority) {
        this._priority = priority;
    }

    protected void doStart() throws Exception {
        if (this._maxThreads < this._minThreads || this._minThreads <= 0) {
            throw new IllegalArgumentException("!0<minThreads<maxThreads");
        }
        this._threads = new HashSet();
        this._idle = new ArrayList();
        this._jobs = new Runnable[this._maxThreads];
        for (int i = 0; i < this._minThreads; ++i) {
            this.newThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            Object object = this._threadsLock;
            synchronized (object) {
                Iterator iter = this._threads.iterator();
                while (iter.hasNext()) {
                    ((Thread)iter.next()).interrupt();
                }
            }
            Thread.yield();
            if (this._threads.size() == 0 || this._maxStopTimeMs > 0 && (long)this._maxStopTimeMs < System.currentTimeMillis() - start) break;
            try {
                Thread.sleep(i * 100);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this._threads.size() > 0) {
            Log.warn(this._threads.size() + " threads could not be stopped");
        }
        Object object = this._joinLock;
        synchronized (object) {
            this._joinLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newThread() {
        Object object = this._threadsLock;
        synchronized (object) {
            if (this._threads.size() < this._maxThreads) {
                PoolThread thread = new PoolThread();
                this._threads.add(thread);
                thread.setName(thread.hashCode() + "@" + this._name + "-" + this._id++);
                thread.start();
            } else if (!this._warned) {
                this._warned = true;
                Log.debug("Max threads for {}", this);
            }
        }
    }

    protected void stopJob(Thread thread, Object job) {
        thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        StringBuffer buf = new StringBuffer();
        Object object = this._threadsLock;
        synchronized (object) {
            Iterator i = this._threads.iterator();
            while (i.hasNext()) {
                Thread thread = (Thread)i.next();
                buf.append(thread.getName()).append(" ").append(thread.toString()).append('\n');
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopThread(String name) {
        Object object = this._threadsLock;
        synchronized (object) {
            Iterator i = this._threads.iterator();
            while (i.hasNext()) {
                Thread thread = (Thread)i.next();
                if (!name.equals(thread.getName())) continue;
                thread.stop();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean interruptThread(String name) {
        Object object = this._threadsLock;
        synchronized (object) {
            Iterator i = this._threads.iterator();
            while (i.hasNext()) {
                Thread thread = (Thread)i.next();
                if (!name.equals(thread.getName())) continue;
                thread.interrupt();
                return true;
            }
        }
        return false;
    }

    private class Lock {
        private Lock() {
        }
    }

    public class PoolThread
    extends Thread {
        Runnable _job = null;

        PoolThread() {
            this.setDaemon(QueuedThreadPool.this._daemon);
            this.setPriority(QueuedThreadPool.this._priority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean idle = false;
            Object job = null;
            try {
                try {}
                catch (InterruptedException e) {
                    Log.ignore(e);
                    Object var10_9 = null;
                    Object object = QueuedThreadPool.this._lock;
                    synchronized (object) {
                        QueuedThreadPool.this._idle.remove(this);
                    }
                    object = QueuedThreadPool.this._threadsLock;
                    synchronized (object) {
                        QueuedThreadPool.this._threads.remove(this);
                    }
                    object = this;
                    synchronized (object) {
                        job = this._job;
                    }
                    if (job == null) return;
                    QueuedThreadPool.this.dispatch((Runnable)job);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                Object object = QueuedThreadPool.this._lock;
                synchronized (object) {
                    QueuedThreadPool.this._idle.remove(this);
                }
                object = QueuedThreadPool.this._threadsLock;
                synchronized (object) {
                    QueuedThreadPool.this._threads.remove(this);
                }
                object = this;
                synchronized (object) {
                    job = this._job;
                }
                if (job == null) throw throwable;
                QueuedThreadPool.this.dispatch((Runnable)job);
                throw throwable;
            }
            while (QueuedThreadPool.this.isRunning()) {
                Object todo;
                if (job != null) {
                    todo = job;
                    job = null;
                    idle = false;
                    todo.run();
                }
                todo = QueuedThreadPool.this._lock;
                synchronized (todo) {
                    long now;
                    if (QueuedThreadPool.this._queued > 0) {
                        QueuedThreadPool.this._queued--;
                        job = QueuedThreadPool.this._jobs[QueuedThreadPool.this._nextJob];
                        ((QueuedThreadPool)QueuedThreadPool.this)._jobs[((QueuedThreadPool)QueuedThreadPool.this)._nextJob++] = null;
                        if (QueuedThreadPool.this._nextJob == QueuedThreadPool.this._jobs.length) {
                            QueuedThreadPool.this._nextJob = 0;
                        }
                        continue;
                    }
                    int threads = QueuedThreadPool.this._threads.size();
                    if (threads > QueuedThreadPool.this._minThreads && (threads > QueuedThreadPool.this._maxThreads || QueuedThreadPool.this._idle.size() > QueuedThreadPool.this._spawnOrShrinkAt) && (now = System.currentTimeMillis()) - QueuedThreadPool.this._lastShrink > (long)QueuedThreadPool.this.getMaxIdleTimeMs()) {
                        QueuedThreadPool.this._lastShrink = now;
                        QueuedThreadPool.this._idle.remove(this);
                        // MONITOREXIT @DISABLED, blocks:[24, 9, 27] lbl73 : MonitorExitStatement: MONITOREXIT : todo
                        Object var10_7 = null;
                        Object object = QueuedThreadPool.this._lock;
                        synchronized (object) {
                            QueuedThreadPool.this._idle.remove(this);
                        }
                        object = QueuedThreadPool.this._threadsLock;
                        synchronized (object) {
                            QueuedThreadPool.this._threads.remove(this);
                        }
                        object = this;
                        synchronized (object) {
                            job = this._job;
                        }
                        if (job == null) return;
                        QueuedThreadPool.this.dispatch((Runnable)job);
                        return;
                    }
                    if (!idle) {
                        QueuedThreadPool.this._idle.add(this);
                        idle = true;
                    }
                }
                todo = this;
                synchronized (todo) {
                    if (this._job == null) {
                        this.wait(QueuedThreadPool.this.getMaxIdleTimeMs());
                    }
                    job = this._job;
                    this._job = null;
                }
            }
            Object var10_8 = null;
            Object object = QueuedThreadPool.this._lock;
            synchronized (object) {
                QueuedThreadPool.this._idle.remove(this);
            }
            object = QueuedThreadPool.this._threadsLock;
            synchronized (object) {
                QueuedThreadPool.this._threads.remove(this);
            }
            object = this;
            synchronized (object) {
                job = this._job;
            }
            if (job == null) return;
            QueuedThreadPool.this.dispatch((Runnable)job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(Runnable job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._job = job;
                this.notify();
            }
        }
    }
}

