/*
 * Decompiled with CFR 0.152.
 */
package io.warp10.sensision.yammermetrics;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.reporting.AbstractPollingReporter;
import com.yammer.metrics.stats.Snapshot;
import io.warp10.sensision.Sensision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensisionReporter
extends AbstractPollingReporter
implements Iterable<Sensision.Value> {
    private final MetricPredicate predicate;
    private final String prefix;

    public SensisionReporter(MetricsRegistry registry, MetricPredicate predicate) {
        this("", registry, predicate);
    }

    public SensisionReporter(String prefix, MetricsRegistry registry, MetricPredicate predicate) {
        super(registry, "sensision-reporter");
        this.predicate = predicate;
        this.prefix = prefix;
        Sensision.addValueProvider(this);
    }

    public void run() {
    }

    @Override
    public Iterator<Sensision.Value> iterator() {
        final ArrayList<Sensision.Value> values = new ArrayList<Sensision.Value>();
        for (Map.Entry entry : this.getMetricsRegistry().groupedMetrics(this.predicate).entrySet()) {
            for (Map.Entry subEntry : ((SortedMap)entry.getValue()).entrySet()) {
                Metric metric = (Metric)subEntry.getValue();
                if (metric == null) continue;
                try {
                    if (metric instanceof Counter) {
                        values.addAll(this.counterValues((MetricName)subEntry.getKey(), (Counter)subEntry.getValue()));
                        continue;
                    }
                    if (metric instanceof Gauge) {
                        values.addAll(this.gaugeValues((MetricName)subEntry.getKey(), (Gauge)subEntry.getValue()));
                        continue;
                    }
                    if (metric instanceof Histogram) {
                        values.addAll(this.histogramValues((MetricName)subEntry.getKey(), (Histogram)subEntry.getValue()));
                        continue;
                    }
                    if (metric instanceof Metered) {
                        values.addAll(this.meterValues((MetricName)subEntry.getKey(), (Metered)subEntry.getValue()));
                        continue;
                    }
                    if (!(metric instanceof Timer)) continue;
                    values.addAll(this.timerValues((MetricName)subEntry.getKey(), (Timer)subEntry.getValue()));
                }
                catch (Exception exception) {}
            }
        }
        final int size = values.size();
        return new Iterator<Sensision.Value>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < size;
            }

            @Override
            public Sensision.Value next() {
                return (Sensision.Value)values.get(this.idx++);
            }

            @Override
            public void remove() {
            }
        };
    }

    public Collection<Sensision.Value> counterValues(MetricName name, Counter counter) throws Exception {
        ArrayList<Sensision.Value> values = new ArrayList<Sensision.Value>();
        long now = System.currentTimeMillis() * Sensision.TIME_UNITS_PER_MS;
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("group", name.getGroup());
        if (name.hasScope()) {
            labels.put("scope", name.getScope());
        }
        labels.put("type", name.getType());
        values.add(new Sensision.Value(this.prefix + name.getName() + ":count", labels, now, null, null, null, counter.count()));
        return values;
    }

    public Collection<Sensision.Value> gaugeValues(MetricName name, Gauge<?> gauge) throws Exception {
        ArrayList<Sensision.Value> values = new ArrayList<Sensision.Value>();
        long now = System.currentTimeMillis() * Sensision.TIME_UNITS_PER_MS;
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("group", name.getGroup());
        if (name.hasScope()) {
            labels.put("scope", name.getScope());
        }
        labels.put("type", name.getType());
        Object value = gauge.value();
        if (value instanceof Number || value instanceof Boolean) {
            values.add(new Sensision.Value(this.prefix + name.getName(), labels, now, null, null, null, value));
        } else {
            values.add(new Sensision.Value(this.prefix + name.getName(), labels, now, null, null, null, value.toString()));
        }
        return values;
    }

    public Collection<Sensision.Value> histogramValues(MetricName name, Histogram histogram) throws Exception {
        ArrayList<Sensision.Value> values = new ArrayList<Sensision.Value>();
        long now = System.currentTimeMillis() * Sensision.TIME_UNITS_PER_MS;
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("group", name.getGroup());
        if (name.hasScope()) {
            labels.put("scope", name.getScope());
        }
        labels.put("type", name.getType());
        String vname = this.prefix + name.getName();
        values.add(new Sensision.Value(vname + ":count", labels, now, null, null, null, histogram.count()));
        values.add(new Sensision.Value(vname + ":max", labels, now, null, null, null, histogram.max()));
        values.add(new Sensision.Value(vname + ":min", labels, now, null, null, null, histogram.min()));
        values.add(new Sensision.Value(vname + ":mean", labels, now, null, null, null, histogram.mean()));
        values.add(new Sensision.Value(vname + ":sd", labels, now, null, null, null, histogram.stdDev()));
        values.add(new Sensision.Value(vname + ":sum", labels, now, null, null, null, histogram.sum()));
        Snapshot snapshot = histogram.getSnapshot();
        values.add(new Sensision.Value(vname + ":median", labels, now, null, null, null, snapshot.getMedian()));
        values.add(new Sensision.Value(vname + ":75percentile", labels, now, null, null, null, snapshot.get75thPercentile()));
        values.add(new Sensision.Value(vname + ":95percentile", labels, now, null, null, null, snapshot.get95thPercentile()));
        values.add(new Sensision.Value(vname + ":98percentile", labels, now, null, null, null, snapshot.get98thPercentile()));
        values.add(new Sensision.Value(vname + ":99percentile", labels, now, null, null, null, snapshot.get99thPercentile()));
        values.add(new Sensision.Value(vname + ":999percentile", labels, now, null, null, null, snapshot.get999thPercentile()));
        return values;
    }

    public Collection<Sensision.Value> meterValues(MetricName name, Metered meter) throws Exception {
        ArrayList<Sensision.Value> values = new ArrayList<Sensision.Value>();
        long now = System.currentTimeMillis() * Sensision.TIME_UNITS_PER_MS;
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("group", name.getGroup());
        if (name.hasScope()) {
            labels.put("scope", name.getScope());
        }
        labels.put("type", name.getType());
        labels.put("event", meter.eventType());
        String vname = this.prefix + name.getName();
        values.add(new Sensision.Value(vname + ":count", labels, now, null, null, null, meter.count()));
        values.add(new Sensision.Value(vname + ":rate:15m", labels, now, null, null, null, meter.fifteenMinuteRate()));
        values.add(new Sensision.Value(vname + ":rate:5m", labels, now, null, null, null, meter.fiveMinuteRate()));
        values.add(new Sensision.Value(vname + ":rate:1m", labels, now, null, null, null, meter.oneMinuteRate()));
        values.add(new Sensision.Value(vname + ":rate:mean", labels, now, null, null, null, meter.meanRate()));
        return values;
    }

    public Collection<Sensision.Value> timerValues(MetricName name, Timer timer) throws Exception {
        ArrayList<Sensision.Value> values = new ArrayList<Sensision.Value>();
        long now = System.currentTimeMillis() * Sensision.TIME_UNITS_PER_MS;
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("group", name.getGroup());
        if (name.hasScope()) {
            labels.put("scope", name.getScope());
        }
        labels.put("type", name.getType());
        String vname = this.prefix + name.getName();
        values.add(new Sensision.Value(vname + ":count", labels, now, null, null, null, timer.count()));
        values.add(new Sensision.Value(vname + ":rate:15m", labels, now, null, null, null, timer.fifteenMinuteRate()));
        values.add(new Sensision.Value(vname + ":rate:5m", labels, now, null, null, null, timer.fiveMinuteRate()));
        values.add(new Sensision.Value(vname + ":rate:1m", labels, now, null, null, null, timer.oneMinuteRate()));
        values.add(new Sensision.Value(vname + ":rate:mean", labels, now, null, null, null, timer.meanRate()));
        values.add(new Sensision.Value(vname + ":max", labels, now, null, null, null, timer.max()));
        values.add(new Sensision.Value(vname + ":min", labels, now, null, null, null, timer.min()));
        values.add(new Sensision.Value(vname + ":mean", labels, now, null, null, null, timer.mean()));
        values.add(new Sensision.Value(vname + ":sd", labels, now, null, null, null, timer.stdDev()));
        values.add(new Sensision.Value(vname + ":sum", labels, now, null, null, null, timer.sum()));
        Snapshot snapshot = timer.getSnapshot();
        values.add(new Sensision.Value(vname + ":median", labels, now, null, null, null, snapshot.getMedian()));
        values.add(new Sensision.Value(vname + ":75percentile", labels, now, null, null, null, snapshot.get75thPercentile()));
        values.add(new Sensision.Value(vname + ":95percentile", labels, now, null, null, null, snapshot.get95thPercentile()));
        values.add(new Sensision.Value(vname + ":98percentile", labels, now, null, null, null, snapshot.get98thPercentile()));
        values.add(new Sensision.Value(vname + ":99percentile", labels, now, null, null, null, snapshot.get99thPercentile()));
        values.add(new Sensision.Value(vname + ":999percentile", labels, now, null, null, null, snapshot.get999thPercentile()));
        return values;
    }
}

