/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.geo;

import com.geoxp.geo.Coverage;
import com.geoxp.geo.HHCodeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoHashHelper {
    private static final String GEOHASH_CHAR_MAP = "0123456789bcdefghjkmnpqrstuvwxyz";

    public static final String fromHHCode(long l, int n) {
        long l2 = 0L;
        for (int i = 64; i > 0; i -= 2) {
            l2 >>>= 2;
            if (0L != (l & 1L)) {
                l2 |= Long.MIN_VALUE;
            }
            if (0L != ((l >>>= 1) & 1L)) {
                l2 |= 0x4000000000000000L;
            }
            l >>>= 1;
        }
        n = 2 * n;
        n -= n % 5;
        l2 >>>= 64 - n;
        StringBuilder stringBuilder = new StringBuilder();
        while (n > 0) {
            stringBuilder.insert(0, GEOHASH_CHAR_MAP.charAt((int)(l2 & 0x1FL)));
            l2 >>= 5;
            n -= 5;
        }
        return stringBuilder.toString();
    }

    public static long toHHCode(String string) {
        int n;
        long l = 0L;
        for (n = 0; n < 12 && n < string.length(); ++n) {
            long l2;
            if (n > 0) {
                l <<= 5;
            }
            if ((l2 = (long)GEOHASH_CHAR_MAP.indexOf(string.charAt(n))) < 0L) {
                throw new RuntimeException("Invalid GeoHash '" + string + "' at index " + n);
            }
            l |= l2;
        }
        long[] lArray = HHCodeHelper.splitHHCode(l <<= 64 - 5 * n, 32);
        return HHCodeHelper.buildHHCode(lArray[1], lArray[0], 32);
    }

    public static Coverage toCoverage(Collection<String> collection) {
        Coverage coverage = new Coverage();
        coverage.setAutoOptimize(true);
        coverage.setAutoThresholds(0L);
        coverage.setAutoDedup(true);
        for (String string : collection) {
            long l = GeoHashHelper.toHHCode(string);
            int n = 5 * Math.min(12, string.length());
            long l2 = -1L >>> 64 - n << 64 - n;
            int n2 = n >>> 1;
            int n3 = n;
            switch (n) {
                case 5: {
                    n = 4;
                    l2 = -864691128455135232L;
                    n3 = 8;
                    break;
                }
                case 10: {
                    n3 = 12;
                    break;
                }
                case 15: {
                    n = 14;
                    l2 = -844424930131968L;
                    n3 = 16;
                    break;
                }
                case 25: {
                    n = 24;
                    l2 = -824633720832L;
                    n3 = 28;
                    break;
                }
                case 30: {
                    n3 = 32;
                    break;
                }
                case 35: {
                    n = 34;
                    l2 = -805306368L;
                    n3 = 36;
                    break;
                }
                case 45: {
                    n = 44;
                    l2 = -786432L;
                    n3 = 48;
                    break;
                }
                case 50: {
                    n3 = 52;
                    break;
                }
                case 55: {
                    n = 54;
                    l2 = -768L;
                    n3 = 56;
                }
            }
            int n4 = n3 - n;
            n2 = n3 >>> 1;
            if (n4 > 0) {
                long l3 = l;
                l = l >>> 64 - n << n4;
                for (long i = 0L; i < 1L << n4; ++i) {
                    long l4 = (l | i) << 64 - n3;
                    if ((l4 & l2) != l3) continue;
                    coverage.addCell(n2, l4);
                }
                continue;
            }
            coverage.addCell(n2, l);
        }
        return coverage;
    }

    public static long[] toGeoCells(List<String> list) {
        Coverage coverage = GeoHashHelper.toCoverage(list);
        long[] lArray = coverage.toGeoCells(32);
        return lArray;
    }

    public static Collection<String> fromGeoCells(long[] lArray, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>(lArray.length);
        long[] lArray2 = new long[2];
        for (long l : lArray) {
            int n = (int)(l >>> 60 << 1);
            long l2 = l << 4;
            int n2 = n * 2;
            l2 >>>= 64 - n2;
            l2 <<= 64 - n2;
            if (0 == n2 % 5) {
                hashSet.add(GeoHashHelper.fromHHCode(l2, n));
                continue;
            }
            int n3 = 5 - n2 % 5;
            if ((n2 + n3) % 2 == 1) {
                ++n3;
            }
            int n4 = 64 - (n2 + n3);
            n = (int)Math.round(Math.ceil((double)(n2 + n3) / 2.0));
            long l3 = l2 >>> n4;
            for (long i = 0L; i < 1L << n3; ++i) {
                hashSet.add(GeoHashHelper.fromHHCode((l3 | i) << n4, n));
            }
        }
        if (bl) {
            return GeoHashHelper.optimize(hashSet);
        }
        return hashSet;
    }

    public static Collection<String> optimize(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        Collections.sort(arrayList);
        String string = "-";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : arrayList) {
            if (string2.length() != n || !string2.startsWith(string)) {
                if (32 == n2) {
                    hashSet.add(string);
                } else if (n2 > 0) {
                    for (int i = 0; i < 32; ++i) {
                        if (0 == (n3 & 1 << i)) continue;
                        hashSet.add(string + GEOHASH_CHAR_MAP.charAt(i));
                    }
                }
                n2 = 0;
                n3 = 0;
                n = string2.length();
                string = string2.substring(0, n - 1);
            }
            n3 |= 1 << GEOHASH_CHAR_MAP.indexOf(string2.substring(n - 1));
            ++n2;
        }
        if (32 == n2) {
            hashSet.add(string);
        } else if (n2 > 0) {
            for (int i = 0; i < 32; ++i) {
                if (0 == (n3 & 1 << i)) continue;
                hashSet.add(string + GEOHASH_CHAR_MAP.charAt(i));
            }
        }
        return hashSet;
    }
}

