/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.geo;

import com.geoxp.geo.Coverage;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HHCodeHelper {
    private static final double TOLSQRT = Math.sqrt(1.0E-15);
    public static final int MIN_RESOLUTION = 2;
    public static final int MAX_RESOLUTION = 32;
    public static final double DEGREES_PER_LAT_UNIT = 4.190951585769653E-8;
    private static final double RADIANS_PER_LAT_UNIT = 7.314590396335798E-10;
    public static final double DEGREES_PER_LON_UNIT = 8.381903171539307E-8;
    private static final double RADIANS_PER_LON_UNIT = 1.4629180792671596E-9;
    public static final double latUnitsPerMeter = 214.7311863050956;
    public static final double metersPerLatUnit = 0.004656985402107239;
    public static final double lonUnitsPerMeter = 107.36559315254779;
    public static final double metersPerLonUnit = 0.009313970804214478;

    public static final long getHHCodeValue(double d, double d2) {
        long[] lArray = new long[]{(long)Math.floor((d += 90.0) / 4.190951585769653E-8), (long)Math.floor((d2 += 180.0) / 8.381903171539307E-8)};
        return HHCodeHelper.buildHHCode(lArray[0], lArray[1]);
    }

    public static final long northHHCode(long l, int n) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        lArray[0] = lArray[0] + (long)(1 << 32 - n);
        return HHCodeHelper.buildHHCode(lArray[0], lArray[1]);
    }

    public static final long southHHCode(long l, int n) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        lArray[0] = lArray[0] - (long)(1 << 32 - n);
        return HHCodeHelper.buildHHCode(lArray[0], lArray[1]);
    }

    public static final long eastHHCode(long l, int n) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        lArray[1] = lArray[1] + (long)(1 << 32 - n);
        return HHCodeHelper.buildHHCode(lArray[0], lArray[1]);
    }

    public static final long westHHCode(long l, int n) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        lArray[1] = lArray[1] - (long)(1 << 32 - n);
        return HHCodeHelper.buildHHCode(lArray[0], lArray[1]);
    }

    public static final long northEastHHCode(long l, int n) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        lArray[0] = lArray[0] + (long)(1 << 32 - n);
        lArray[1] = lArray[1] + (long)(1 << 32 - n);
        return HHCodeHelper.buildHHCode(lArray[0], lArray[1]);
    }

    public static final long southEastHHCode(long l, int n) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        lArray[0] = lArray[0] - (long)(1 << 32 - n);
        lArray[1] = lArray[1] + (long)(1 << 32 - n);
        return HHCodeHelper.buildHHCode(lArray[0], lArray[1]);
    }

    public static final long southWestHHCode(long l, int n) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        lArray[0] = lArray[0] - (long)(1 << 32 - n);
        lArray[1] = lArray[1] - (long)(1 << 32 - n);
        return HHCodeHelper.buildHHCode(lArray[0], lArray[1]);
    }

    public static final long northWestHHCode(long l, int n) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        lArray[0] = lArray[0] + (long)(1 << 32 - n);
        lArray[1] = lArray[1] - (long)(1 << 32 - n);
        return HHCodeHelper.buildHHCode(lArray[0], lArray[1]);
    }

    public static final long deltaHHCode(long l, int n, int n2, int n3) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        lArray[0] = lArray[0] + (long)(n2 * (1 << 32 - n));
        lArray[1] = lArray[1] + (long)(n3 * (1 << 32 - n));
        return HHCodeHelper.buildHHCode(lArray[0], lArray[1]);
    }

    public static final void stableSplitHHCode(long l, int n, long[] lArray) {
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 31; i >= 32 - n; --i) {
            l2 <<= 1;
            l2 |= 1L & l >> 1 + (i << 1);
            l3 <<= 1;
            l3 |= 1L & l >> (i << 1);
        }
        if (32 != n) {
            l2 <<= 32 - n;
            l3 <<= 32 - n;
        }
        lArray[0] = l2;
        lArray[1] = l3;
    }

    public static final long[] splitHHCode(long l, int n) {
        long[] lArray = new long[2];
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 31; i >= 32 - n; --i) {
            l2 <<= 1;
            l2 |= 1L & l >> 1 + (i << 1);
            l3 <<= 1;
            l3 |= 1L & l >> (i << 1);
        }
        if (32 != n) {
            l2 <<= 32 - n;
            l3 <<= 32 - n;
        }
        lArray[0] = l2;
        lArray[1] = l3;
        return lArray;
    }

    private static final long[] splitHHCode(long l) {
        return HHCodeHelper.splitHHCode(l, 32);
    }

    public static final double[] getLatLon(long l, int n) {
        double[] dArray = new double[2];
        HHCodeHelper.stableGetLatLon(l, n, dArray, 0);
        return dArray;
    }

    public static final long getCenter(long l, int n) {
        if (n >= 2 && n <= 32) {
            l &= Coverage.PREFIX_MASK[(n >>> 1) - 1];
        }
        if (n >= 2 && n < 32) {
            l |= Coverage.CENTER_BITS[(n >>> 1) - 1 + 1];
        }
        return l;
    }

    public static final double[] getCenterLatLon(long l, int n) {
        double[] dArray = new double[2];
        HHCodeHelper.stableGetLatLon(HHCodeHelper.getCenter(l, n), 32, dArray, 0);
        return dArray;
    }

    public static final void stableGetLatLon(long l, int n, double[] dArray, int n2) {
        long[] lArray = HHCodeHelper.splitHHCode(l, n);
        dArray[n2] = (double)lArray[0] * 4.190951585769653E-8 - 90.0;
        dArray[n2 + 1] = (double)lArray[1] * 8.381903171539307E-8 - 180.0;
    }

    public static final long buildHHCode(long l, long l2, int n) {
        long l3 = 0L;
        if (0L != (l & 0x100000000L)) {
            l ^= 0xFFFFFFFFL;
            l2 ^= 0x80000000L;
        }
        l &= 0xFFFFFFFFL;
        l2 &= 0xFFFFFFFFL;
        for (int i = 31; i >= 32 - n; --i) {
            l3 <<= 1;
            l3 |= (l & 1L << i) >> i;
            l3 <<= 1;
            l3 |= (l2 & 1L << i) >> i;
        }
        if (32 != n) {
            l3 <<= 32 - n;
        }
        return l3;
    }

    private static final long buildHHCode(long l, long l2) {
        return HHCodeHelper.buildHHCode(l, l2, 32);
    }

    public static final String toString(long l) {
        return HHCodeHelper.toString(l, 32);
    }

    public static final long[] toGeoCells(long l) {
        return HHCodeHelper.toGeoCells(l, 32);
    }

    public static final long[] toGeoCells(long l, int n) {
        if (n >= 32) {
            n = 30;
        }
        if (n < 2) {
            n = 2;
        }
        long[] lArray = new long[n >> 1];
        for (int i = 0; i < n >> 1; ++i) {
            lArray[i] = (long)(i + 1) << 60;
            int n2 = i;
            lArray[n2] = lArray[n2] | l >> 4 & 0xFFFFFFFFFFFFFFFL;
            int n3 = i;
            lArray[n3] = lArray[n3] & (0xFFFFFFFFFFFFFFFFL ^ (1L << 4 * (15 - (i + 1))) - 1L);
        }
        return lArray;
    }

    public static final long[] getSubGeoCells(long l) {
        long[] lArray = new long[16];
        if ((l & 0xF000000000000000L) == -1152921504606846976L) {
            long l2 = l << 4 & 0xFFFFFFFFFFFFFFF0L;
            for (int i = 0; i < 16; ++i) {
                lArray[i] = l2 | (long)i & 0xFL;
            }
        } else {
            int n = (int)((l & 0xF000000000000000L) >> 60);
            long l3 = l & (0xFFFFFFFFFFFFFFFFL ^ (1L << 60 - 4 * (++n - 1)) - 1L);
            l3 &= 0xFFFFFFFFFFFFFFFL;
            l3 |= (long)n << 60;
            for (int i = 0; i < 16; ++i) {
                lArray[i] = l3 | (long)i << 60 - 4 * n;
            }
        }
        return lArray;
    }

    public static final long toGeoCell(long l, int n) {
        if (n > 31 || n < 2 || n % 2 == 1) {
            return 0L;
        }
        long l2 = (long)n << 59;
        l2 |= l >> 4 & 0xFFFFFFFFFFFFFFFL;
        return l2 &= 0xFFFFFFFFFFFFFFFFL ^ (1L << 4 * (15 - (n >> 1))) - 1L;
    }

    public static final long parentGeoCell(long l) {
        int n = (int)(l >>> 60 & 0xFL);
        if (1 == n || 0 == n) {
            return 0L;
        }
        l &= 0xFFFFFFFFFFFFFFFL;
        l |= ((long)(n - 1) & 0xFL) << 60 & 0xF000000000000000L;
        return l &= -1L << 64 - n * 4;
    }

    public static final String toString(long l, int n) {
        n &= 0xFE;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Long.toHexString(l));
        while (stringBuilder.length() < 16) {
            stringBuilder.insert(0, "0");
        }
        stringBuilder.setLength(n >> 1);
        return stringBuilder.toString();
    }

    public static final void canonicalizeCoverage(Map<Integer, List<Long>> map) {
        HashSet<Long> hashSet = new HashSet<Long>();
        for (int n : map.keySet()) {
            hashSet.clear();
            for (long l : map.get(n)) {
                hashSet.add(l & (0xFFFFFFFFFFFFFFFFL ^ (1L << 64 - 2 * n) - 1L));
            }
            map.get(n).clear();
            map.get(n).addAll(hashSet);
            Collections.sort(map.get(n));
        }
    }

    public static final Map<Integer, List<Long>> optimize(Map<Integer, List<Long>> map, long l) {
        long l2;
        int n = 32;
        while (n > 0) {
            long l32;
            if (!map.containsKey(n)) {
                n -= 2;
                continue;
            }
            if (2 == n) {
                HashSet<Long> hashSet = new HashSet<Long>();
                for (long l32 : map.get(n)) {
                    hashSet.add(l32 & 0xF000000000000000L);
                }
                map.get(n).clear();
                map.get(n).addAll(hashSet);
                Collections.sort(map.get(n));
                break;
            }
            Collections.sort(map.get(n));
            long l4 = 0xFFFFFFFFFFFFFFFFL ^ (1L << 2 * (32 - n + 2)) - 1L;
            l32 = (1L << 2 * (32 - n + 2)) - 1L;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            l2 = 0L;
            int n2 = 0;
            int n3 = 0;
            boolean bl = true;
            for (int i = 0; i <= map.get(n).size(); ++i) {
                long l5 = 0L;
                if (i < map.get(n).size()) {
                    l5 = map.get(n).get(i) & l4;
                }
                if (!(bl || i != map.get(n).size() && l2 == l5)) {
                    long l6 = l >> 2 * (32 - n) & 0xFL;
                    if (65535 == n2 || l6 > 0L && (long)n3 >= l6) {
                        if (!map.containsKey(n - 2)) {
                            map.put(n - 2, new ArrayList());
                        }
                        map.get(n - 2).add(l2);
                    } else {
                        for (int j = 0; j < 16; ++j) {
                            if (0 == (n2 & 1 << j)) continue;
                            arrayList.add(l2 | (long)j << 2 * (32 - n));
                        }
                    }
                    n2 = 0;
                    n3 = 0;
                    l2 = l5;
                }
                if (i == map.get(n).size()) break;
                if (bl) {
                    bl = false;
                    l2 = l5;
                    n2 = 0;
                    n3 = 0;
                }
                int n4 = n2;
                if ((n2 |= 1 << (int)((map.get(n).get(i) & l32) >> 2 * (32 - n))) == n4) continue;
                ++n3;
            }
            if (arrayList.isEmpty()) {
                map.remove(n);
            } else {
                map.put(n, arrayList);
            }
            n -= 2;
        }
        for (n = 2; n < 28; n += 2) {
            if (!map.containsKey(n) || !map.containsKey(n + 4)) continue;
            long l7 = 0xFFFFFFFFFFFFFFFFL ^ (1L << 2 * (32 - n)) - 1L;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (long l8 : map.get(n)) {
                l2 = l8 & l7;
                for (long l9 : map.get(n + 4)) {
                    if ((l9 & l7) == l2 || arrayList.contains(l9)) continue;
                    arrayList.add(l9);
                }
            }
            if (!arrayList.isEmpty()) {
                map.put(n + 4, arrayList);
                continue;
            }
            map.remove(n + 4);
        }
        return map;
    }

    public static final long[] getBoundingBox(Geometry geometry) {
        long[] lArray = new long[4];
        Envelope envelope = geometry.getEnvelopeInternal();
        lArray[0] = HHCodeHelper.toLongLat(envelope.getMinY());
        lArray[1] = HHCodeHelper.toLongLon(envelope.getMinX());
        lArray[2] = HHCodeHelper.toLongLat(envelope.getMaxY());
        lArray[3] = HHCodeHelper.toLongLon(envelope.getMaxX());
        return lArray;
    }

    public static final long[] getBoundingBox(List<Long> list, List<Long> list2) {
        long[] lArray = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE};
        for (int i = 0; i < Math.min(list.size(), list2.size()); ++i) {
            if (list.get(i) < lArray[0]) {
                lArray[0] = list.get(i);
            }
            if (list.get(i) > lArray[2]) {
                lArray[2] = list.get(i);
            }
            if (list2.get(i) > lArray[3]) {
                lArray[3] = list2.get(i);
            }
            if (list2.get(i) >= lArray[1]) continue;
            lArray[1] = list2.get(i);
        }
        return lArray;
    }

    public static final long[] getBoundingBox(List<Long> list) {
        long[] lArray = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE};
        long[] lArray2 = new long[2];
        for (long l : list) {
            HHCodeHelper.stableSplitHHCode(l, 32, lArray2);
            if (lArray2[0] < lArray[0]) {
                lArray[0] = lArray2[0];
            }
            if (lArray2[0] > lArray[2]) {
                lArray[2] = lArray2[0];
            }
            if (lArray2[1] > lArray[3]) {
                lArray[3] = lArray2[1];
            }
            if (lArray2[1] >= lArray[1]) continue;
            lArray[1] = lArray2[1];
        }
        return lArray;
    }

    public static final int getOptimalResolution(long[] lArray, double d) {
        int n;
        double d2 = HHCodeHelper.orthodromicDistance(lArray[0], lArray[1], lArray[2], lArray[3]);
        double d3 = d2 * d;
        for (n = 32; n > 2; n -= 2) {
            double d4 = Math.PI * 2 / (double)(1L << n);
            double d5 = Math.PI / (double)(1L << n);
            double d6 = -d5 / 2.0;
            double d7 = 0.0;
            double d8 = d5 / 2.0;
            double d9 = d4;
            double d10 = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((d6 - d8) / 2.0), 2.0) + Math.cos(d6) * Math.cos(d8) * Math.pow(Math.sin((d7 - d9) / 2.0), 2.0)));
            if ((d10 = d10 * 57.29577951308232 * 111120.0) > d3) break;
        }
        return n;
    }

    public static final int getOptimalPolygonResolution(long[] lArray, int n) {
        int n2;
        int n3 = -n;
        long l = Math.min(Math.abs(lArray[2] - lArray[0]), 0xFFFFFFFFL);
        long l2 = Math.min(Math.abs(lArray[3] - lArray[1]), 0xFFFFFFFFL);
        int n4 = (int)Math.floor(Math.log(l) / Math.log(2.0));
        int n5 = Math.abs(n4 - (n2 = (int)Math.floor(Math.log(l2) / Math.log(2.0)))) > 4 ? Math.max(n4, n2) - 4 : Math.min(n4, n2);
        n5 &= 0xFE;
        if ((n5 = 32 - n5) + n3 <= 32) {
            n5 += n3;
            n5 &= 0x3E;
        }
        return n5;
    }

    public static final int getOptimalPolylineResolution(long[] lArray, int n) {
        int n2 = HHCodeHelper.getOptimalPolygonResolution(lArray, 0);
        n2 += 4;
        long l = 64L;
        while (Math.abs(lArray[2] - lArray[0]) >> 32 - n2 > l || Math.abs(lArray[3] - lArray[1]) >> 32 - n2 > l) {
            n2 -= 2;
        }
        if (n2 > 26) {
            n2 = 26;
        }
        if (n2 - n <= 32 && n2 - n >= 2) {
            n2 -= n;
            n2 &= 0x3E;
        }
        return n2;
    }

    public static final Coverage coverPolygon(List<Long> list, int n, long[] lArray, boolean bl) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        long[] lArray2 = new long[2];
        for (long l : list) {
            HHCodeHelper.stableSplitHHCode(l, 32, lArray2);
            arrayList.add(lArray2[0]);
            arrayList2.add(lArray2[1]);
        }
        return HHCodeHelper.coverPolygon(arrayList, arrayList2, n, lArray, bl);
    }

    public static final Coverage coverPolygon(List<Long> list, int n) {
        return HHCodeHelper.coverPolygon(list, n, null, false);
    }

    public static final Coverage coverPolygon(List<Long> list, List<Long> list2, int n, long[] lArray, boolean bl) {
        Coverage coverage = new Coverage();
        return HHCodeHelper.coverPolygon(list, list2, n, coverage, lArray, bl);
    }

    public static final Coverage coverPolygon(List<Long> list, List<Long> list2, int n) {
        return HHCodeHelper.coverPolygon(list, list2, n, null, false);
    }

    public static final Coverage coverPolygon(List<Long> list, List<Long> list2, int n, Coverage coverage, long[] lArray, boolean bl) {
        int n2 = Math.min(list.size(), list2.size());
        list = list.subList(0, n2);
        list2 = list2.subList(0, n2);
        int n3 = list.size();
        long[] lArray2 = new long[n2];
        long[] lArray3 = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray2[i] = list.get(i);
            lArray3[i] = list2.get(i);
        }
        long[] lArray4 = HHCodeHelper.getBoundingBox(list, list2);
        long l = lArray4[2];
        long l2 = lArray4[1];
        long l3 = lArray4[3];
        long l4 = lArray4[0];
        if (0 >= n) {
            n = HHCodeHelper.getOptimalPolygonResolution(lArray4, n);
        }
        long l5 = 0xFFFFFFFFFFFFFFFFL ^ (1L << 32 - n) - 1L;
        long l6 = (1L << 32 - n) - 1L;
        l |= l6;
        l4 &= l5;
        l2 &= l5;
        l3 |= l6;
        long[] lArray5 = new long[2];
        long[] lArray6 = new long[2];
        HashSet hashSet = new HashSet();
        HashSet<Long> hashSet2 = new HashSet<Long>();
        hashSet2.addAll(list);
        for (long i = l4; i <= l; i += 1L << 32 - n) {
            hashSet2.add(i & l5);
        }
        long[] lArray7 = new long[hashSet2.size()];
        int n4 = 0;
        Object object = hashSet2.iterator();
        while (object.hasNext()) {
            long l7 = (Long)object.next();
            lArray7[n4++] = l7;
        }
        hashSet2.clear();
        object = new long[n3];
        Arrays.sort(lArray7);
        for (int i = 0; i < lArray7.length; ++i) {
            long l8 = lArray7[i];
            int n5 = n3 - 1;
            int n6 = 0;
            hashSet.clear();
            int n7 = 0;
            while (n7 < n3) {
                block15: {
                    block13: {
                        long l9;
                        block14: {
                            lArray5[0] = lArray2[n7];
                            lArray5[1] = lArray3[n7];
                            lArray6[0] = lArray2[n5];
                            lArray6[1] = lArray3[n5];
                            if (lArray5[0] == lArray6[0] || (lArray5[0] < l8 || lArray6[0] > l8) && (lArray6[0] < l8 || lArray5[0] > l8)) break block13;
                            double d = (double)(lArray6[1] - lArray5[1]) / (double)(lArray6[0] - lArray5[0]);
                            long l10 = lArray5[1] + (long)((double)((l8 | l6) - lArray5[0]) * d);
                            long l11 = l10 & l5;
                            long l12 = lArray5[1] + (long)((double)(l8 - lArray5[0]) * d);
                            long l13 = l12 & l5;
                            if (l11 > l13) {
                                l11 = l12 & l5;
                                l13 = l10 & l5;
                            }
                            l9 = 0L;
                            long l14 = Long.MAX_VALUE;
                            long l15 = Long.MIN_VALUE;
                            for (long j = l11; j <= l13; j += 1L << 32 - n) {
                                if ((j < (lArray5[1] & l5) || j > (lArray6[1] | l6)) && (j < (lArray6[1] & l5) || j > (lArray5[1] | l6))) continue;
                                coverage.addCell(n, l8, j, lArray, bl);
                                if ((j & l5) < l14) {
                                    l14 = j & l5;
                                    l9 = j;
                                }
                                if ((j & l5) <= l15) continue;
                                l15 = j & l5;
                            }
                            if (l8 != lArray5[0]) break block14;
                            if (l8 != lArray5[0]) break block15;
                            int n8 = n7 + 1 < list.size() ? n7 + 1 : 0;
                            if (!((double)((lArray2[n8] - lArray5[0]) * (lArray6[0] - lArray5[0])) > 0.0)) break block15;
                        }
                        object[n6++] = l9;
                        break block15;
                    }
                    if (lArray5[0] == lArray6[0] && (l8 & l5) == (lArray5[0] & l5)) {
                        for (long j = Math.min(lArray5[1], lArray6[1]); j <= Math.max(lArray5[1], lArray6[1]); j += 1L << 32 - n) {
                            coverage.addCell(n, l8, j, lArray, bl);
                        }
                    }
                }
                n5 = n7++;
            }
            Arrays.sort((long[])object, 0, n6);
            n7 = n6;
            if (n7 <= 1) continue;
            for (int j = 0; j < n7; j += 2) {
                if (j >= n7 - 1) continue;
                for (reference var37_35 = object[j] & l5; var37_35 <= (object[j + 1] | l6); var37_35 += 1L << 32 - n) {
                    coverage.addCell(n, l8, (long)var37_35, lArray, bl);
                }
            }
        }
        return coverage;
    }

    public static final Coverage coverPolygon(List<Long> list, List<Long> list2, int n, Coverage coverage) {
        return HHCodeHelper.coverPolygon(list, list2, n, coverage, null, false);
    }

    public static final void coverLine(long l, long l2, Coverage coverage, int n, long[] lArray, boolean bl) {
        long[] lArray2 = HHCodeHelper.splitHHCode(l);
        long[] lArray3 = HHCodeHelper.splitHHCode(l2);
        HHCodeHelper.coverLine(lArray2[0], lArray2[1], lArray3[0], lArray3[1], coverage, n, lArray, bl);
    }

    public static final void coverLine(long l, long l2, Coverage coverage, int n) {
        HHCodeHelper.coverLine(l, l2, coverage, n, null, false);
    }

    public static final void coverLine(long l, long l2, long l3, long l4, Coverage coverage, int n, long[] lArray, boolean bl) {
        if (n <= 0) {
            long[] lArray2 = new long[]{l, l2, l3, l4};
            n = HHCodeHelper.getOptimalPolylineResolution(lArray2, n);
        }
        if (l2 > l4) {
            long l5 = l;
            l = l3;
            l3 = l5;
            l5 = l2;
            l2 = l4;
            l4 = l5;
        }
        long l6 = Math.abs(l3 - l);
        long l7 = Math.abs(l4 - l2);
        long l8 = l3 - l;
        long l9 = 1L << 32 - n;
        long l10 = l9 - 1L;
        long l11 = 0xFFFFFFFFFFFFFFFFL ^ l10;
        if (0L == l8) {
            long l12 = l;
            long l13 = l2;
            while ((l13 & l11) < l4) {
                coverage.addCell(n, l12, l13, lArray, bl);
                l13 += l9;
            }
        } else if (0L == l4 - l2) {
            long l14 = l;
            long l15 = l2;
            if (l8 > 0L) {
                while ((l14 & l11) < l3) {
                    coverage.addCell(n, HHCodeHelper.buildHHCode(l14, l15), lArray, bl);
                    l14 += l9;
                }
            } else {
                while ((l14 | l10) > l3) {
                    coverage.addCell(n, HHCodeHelper.buildHHCode(l14, l15), lArray, bl);
                    l14 -= l9;
                }
            }
        } else {
            long l16 = l;
            long l17 = l2;
            boolean bl2 = true;
            while (bl2) {
                coverage.addCell(n, l16, l17, lArray, bl);
                long l18 = l8 > 0L ? (l16 | l10) + 1L - l16 : l16 - (l16 & l11) + 1L;
                long l19 = (l17 | l10) + 1L - l17;
                long l20 = l18 * l7;
                long l21 = l19 * l6;
                long l22 = l20 - l21;
                if (l22 > 0L) {
                    l16 += (long)Long.signum(l8) * (l21 / l7);
                    l17 = (l17 | l10) + 1L;
                } else if (l22 < 0L) {
                    l16 = l8 > 0L ? (l16 | l10) + 1L : (l16 & l11) - 1L;
                    l17 += l20 / l6;
                } else {
                    l16 = l8 > 0L ? (l16 | l10) + 1L : (l16 & l11) - 1L;
                    l17 = (l17 | l10) + 1L;
                }
                if (l8 > 0L) {
                    bl2 = (l16 & l11) < l3 && (l17 & l11) < l4;
                    continue;
                }
                bl2 = (l16 | l10) > l3 && (l17 & l11) < l4;
            }
        }
    }

    public static final void coverLine(long l, long l2, long l3, long l4, Coverage coverage, int n) {
        HHCodeHelper.coverLine(l, l2, l3, l4, coverage, n, null, false);
    }

    public static final Coverage coverPolyline(List<Long> list, int n, boolean bl, long[] lArray, boolean bl2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        long[] lArray2 = new long[2];
        for (long l : list) {
            HHCodeHelper.stableSplitHHCode(l, 32, lArray2);
            arrayList.add(lArray2[0]);
            arrayList2.add(lArray2[1]);
        }
        return HHCodeHelper.coverPolyline(arrayList, arrayList2, n, false, bl, lArray, bl2);
    }

    public static final Coverage coverPolyline(List<Long> list, int n, boolean bl) {
        return HHCodeHelper.coverPolyline(list, n, bl, null, false);
    }

    public static final Coverage coverPolyline(List<Long> list, List<Long> list2, int n, boolean bl, boolean bl2, long[] lArray, boolean bl3) {
        Coverage coverage = new Coverage();
        return HHCodeHelper.coverPolyline(list, list2, n, bl, bl2, coverage, lArray, bl3);
    }

    public static final Coverage coverPolyline(List<Long> list, List<Long> list2, int n, boolean bl, boolean bl2) {
        return HHCodeHelper.coverPolyline(list, list2, n, bl, bl2, null, false);
    }

    public static final Coverage coverPolyline(List<Long> list, List<Long> list2, int n, boolean bl, boolean bl2, Coverage coverage, long[] lArray, boolean bl3) {
        int n2 = n;
        if (bl2) {
            HHCodeHelper.coverPolylineBresenham(list, list2, n, bl, coverage, lArray, bl3);
        } else {
            Object object;
            if (n2 <= 0 && !bl) {
                object = HHCodeHelper.getBoundingBox(list, list2);
                n = HHCodeHelper.getOptimalPolylineResolution((long[])object, n2);
            }
            object = new ArrayList();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            object.add(list.get(0));
            object.add(list.get(0));
            arrayList.add(list2.get(0));
            arrayList.add(list2.get(0));
            for (int i = 0; i <= Math.min(list.size(), list2.size()) - 2; ++i) {
                object.remove(0);
                arrayList.remove(0);
                object.add(list.get(i + 1));
                arrayList.add(list2.get(i + 1));
                if (bl) {
                    long[] lArray2 = HHCodeHelper.getBoundingBox((List<Long>)object, arrayList);
                    n = HHCodeHelper.getOptimalPolylineResolution(lArray2, n2);
                }
                HHCodeHelper.coverLine((Long)object.get(0), (Long)arrayList.get(0), (Long)object.get(1), (Long)arrayList.get(1), coverage, n, lArray, bl3);
            }
        }
        return coverage;
    }

    public static final Coverage coverPolyline(List<Long> list, List<Long> list2, int n, boolean bl, boolean bl2, Coverage coverage) {
        return HHCodeHelper.coverPolyline(list, list2, n, bl, bl2, coverage, null, false);
    }

    private static void coverPolylineBresenham(List<Long> list, List<Long> list2, int n, boolean bl, Coverage coverage, long[] lArray, boolean bl2) {
        Object object;
        long l = 1L << 32 - n;
        long[] lArray2 = new long[2];
        long[] lArray3 = new long[2];
        int n2 = n;
        if (n2 <= 0 && !bl) {
            object = HHCodeHelper.getBoundingBox(list, list2);
            n = HHCodeHelper.getOptimalPolylineResolution((long[])object, n2);
        }
        object = null;
        ArrayList<Long> arrayList = null;
        if (bl) {
            object = new ArrayList();
            arrayList = new ArrayList<Long>();
            object.add(list.get(0));
            object.add(list.get(0));
            arrayList.add(list2.get(0));
            arrayList.add(list2.get(0));
        }
        for (int i = 0; i <= Math.min(list.size(), list2.size()) - 2; ++i) {
            long l2;
            boolean bl3;
            if (bl) {
                object.remove(0);
                arrayList.remove(0);
                object.add(list.get(i + 1));
                arrayList.add(list2.get(i + 1));
                long[] lArray4 = HHCodeHelper.getBoundingBox((List<Long>)object, arrayList);
                n = HHCodeHelper.getOptimalPolylineResolution(lArray4, n2);
            }
            lArray2[0] = list.get(i);
            lArray2[1] = list2.get(i);
            lArray3[0] = list.get(i + 1);
            lArray3[1] = list2.get(i + 1);
            boolean bl4 = bl3 = Math.abs(lArray3[0] - lArray2[0]) > Math.abs(lArray3[1] - lArray2[1]);
            if (bl3) {
                l2 = lArray2[1];
                lArray2[1] = lArray2[0];
                lArray2[0] = l2;
                l2 = lArray3[1];
                lArray3[1] = lArray3[0];
                lArray3[0] = l2;
            }
            if (lArray2[1] > lArray3[1]) {
                l2 = lArray2[1];
                lArray2[1] = lArray3[1];
                lArray3[1] = l2;
                l2 = lArray2[0];
                lArray2[0] = lArray3[0];
                lArray3[0] = l2;
            }
            l2 = Math.abs(lArray3[0] - lArray2[0]);
            long l3 = lArray3[1] - lArray2[1];
            long l4 = l3 >> 2;
            long l5 = lArray2[0];
            long l6 = lArray2[0] < lArray3[0] ? l : -l;
            long l7 = lArray2[1];
            long l8 = 0xFFFFFFFFFFFFFFFFL ^ l - 1L;
            while ((l7 & l8) <= lArray3[1]) {
                if (bl3) {
                    coverage.addCell(n, l7, l5, lArray, bl2);
                } else {
                    coverage.addCell(n, l5, l7, lArray, bl2);
                }
                if ((l4 -= l2) < 0L) {
                    l5 += l6;
                    l4 += l3;
                }
                l7 += l;
            }
        }
    }

    private static void coverPolylineBresenham(List<Long> list, List<Long> list2, int n, boolean bl, Coverage coverage) {
        HHCodeHelper.coverPolylineBresenham(list, list2, n, bl, coverage, null, false);
    }

    private static final void mergeCoverages(Map<Integer, List<Long>> map, Map<Integer, List<Long>> map2) {
        for (int n : map2.keySet()) {
            if (!map.containsKey(n)) {
                map.put(n, new ArrayList());
            }
            map.get(n).addAll((Collection<Long>)map2.get(n));
        }
    }

    public static final void dumpCoverage(Map<Integer, List<Long>> map) {
        boolean bl = true;
        long l = 0L;
        for (int n : map.keySet()) {
            System.out.print(n + ": ");
            for (long l2 : map.get(n)) {
                if (!bl) {
                    if (l == (l2 & (0xFFFFFFFFFFFFFFFFL ^ 1L << 2 * (32 - n) - 1))) continue;
                    System.out.print(" ");
                }
                System.out.print(HHCodeHelper.toString(l2, n));
                l = l2 & (0xFFFFFFFFFFFFFFFFL ^ 1L << 2 * (32 - n) - 1);
                bl = false;
            }
            System.out.println();
        }
    }

    public static final Coverage coverRectangle(double d, double d2, double d3, double d4, long[] lArray, boolean bl) {
        return HHCodeHelper.coverRectangle(d, d2, d3, d4, 0, lArray, bl);
    }

    public static final Coverage coverRectangle(double d, double d2, double d3, double d4) {
        return HHCodeHelper.coverRectangle(d, d2, d3, d4, null, false);
    }

    public static final Coverage coverRectangle(double d, double d2, double d3, double d4, int n) {
        return HHCodeHelper.coverRectangle(d, d2, d3, d4, n, null, false);
    }

    public static final Coverage coverRectangle(double d, double d2, double d3, double d4, int n, long[] lArray, boolean bl) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        arrayList.add(HHCodeHelper.toLongLat(d));
        arrayList.add(HHCodeHelper.toLongLat(d));
        arrayList.add(HHCodeHelper.toLongLat(d3));
        arrayList.add(HHCodeHelper.toLongLat(d3));
        arrayList2.add(HHCodeHelper.toLongLon(d2));
        arrayList2.add(HHCodeHelper.toLongLon(d4));
        arrayList2.add(HHCodeHelper.toLongLon(d4));
        arrayList2.add(HHCodeHelper.toLongLon(d2));
        return HHCodeHelper.coverPolygon(arrayList, arrayList2, n, lArray, bl);
    }

    public static final List<Long> resamplePolyline(List<Long> list, int n) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l = 0xFFFFFFFFFFFFFFFFL ^ 1L << 2 * (32 - n) - 1;
        long l2 = 32 == n ? 0L : 12L << 2 * (30 - n);
        long l3 = 0L;
        boolean bl = true;
        for (long l4 : list) {
            if (!bl && (l4 & l) == l3) continue;
            bl = false;
            arrayList.add(l4 & l | l2);
            l3 = l4 & l;
        }
        return arrayList;
    }

    public static final String toIndexableString(long l) {
        return HHCodeHelper.toIndexableString(l, 2, 30);
    }

    public static final String toIndexableString(long l, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Long.toHexString(l));
        while (stringBuilder.length() < 16) {
            stringBuilder.insert(0, "0");
        }
        if (n < 2) {
            n = 2;
        }
        if (n2 > 30) {
            n2 = 30;
        }
        if (n > n2) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        for (n3 = n; n3 <= n2; n3 += 2) {
            stringBuilder.append(" ");
            stringBuilder.append(stringBuilder.subSequence(0, n3 >> 1));
        }
        return stringBuilder.toString();
    }

    public static final String[] toIndexableStrings(long l) {
        String[] stringArray = new String[16];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("000000000000000");
        stringBuilder.append(Long.toHexString(l));
        int n = stringBuilder.length() - 16;
        for (int i = 0; i < 16; ++i) {
            stringArray[i] = stringBuilder.substring(n, n + i + 1);
        }
        return stringArray;
    }

    public static long[] center(long l, int n) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        long l2 = (1L << 32 - n) - 1L >> 1;
        lArray[0] = lArray[0] | l2;
        lArray[1] = lArray[1] | l2;
        return lArray;
    }

    public static double toLat(long l) {
        return 4.190951585769653E-8 * (double)l - 90.0;
    }

    public static double toLon(long l) {
        return 8.381903171539307E-8 * (double)l - 180.0;
    }

    public static long toLongLat(double d) {
        long l = 0L;
        l = d == 90.0 ? 0xFFFFFFFFL : (long)((d + 90.0) / 4.190951585769653E-8);
        if (d + 90.0 < 0.0 && l == 0L) {
            --l;
        }
        return l;
    }

    public static long toLongLon(double d) {
        long l = 0L;
        l = d == 180.0 ? 0xFFFFFFFFL : (long)((d + 180.0) / 8.381903171539307E-8);
        if (d + 180.0 < 0.0 && l == 0L) {
            --l;
        }
        return l;
    }

    public static long[] getScale(long l) {
        double[] dArray = HHCodeHelper.getLatLon(l, 32);
        long[] lArray = new long[2];
        double d = Math.cos(Math.toRadians(dArray[0]));
        lArray[0] = Math.round(214.7311863050956);
        lArray[1] = Math.round(107.36559315254779 / d);
        return lArray;
    }

    public static long[] getScale(long l, long l2) {
        return HHCodeHelper.getScale(HHCodeHelper.buildHHCode(l, l2, 32));
    }

    public static double getLatScale(long l) {
        return Math.cos((double)l * 7.314590396335798E-10 + 1.5707963267948966);
    }

    public static double getSquaredDistance(long l, long l2, long[] lArray) {
        long[] lArray2 = HHCodeHelper.splitHHCode(l);
        long[] lArray3 = HHCodeHelper.splitHHCode(l2);
        double d = Math.abs((double)(lArray2[0] - lArray3[0]) / (double)lArray[0]);
        double d2 = Math.abs((double)(lArray2[1] - lArray3[1]) / (double)lArray[1]);
        return d * d + d2 * d2;
    }

    public static double getSquaredDistance(long[] lArray, long[] lArray2, long[] lArray3) {
        double d = Math.abs((double)(lArray[0] - lArray2[0]) / (double)lArray3[0]);
        double d2 = Math.abs((double)(lArray[1] - lArray2[1]) / (double)lArray3[1]);
        return d * d + d2 * d2;
    }

    public static double[] getHHCodeBBox(long l, int n) {
        long[] lArray = HHCodeHelper.splitHHCode(l);
        long l2 = (1L << 32 - n) - 1L;
        double[] dArray = new double[4];
        lArray[0] = lArray[0] | l2;
        lArray[1] = lArray[1] | l2;
        dArray[2] = (double)lArray[0] * 4.190951585769653E-8 - 90.0;
        dArray[3] = (double)lArray[1] * 8.381903171539307E-8 - 180.0;
        lArray[0] = lArray[0] ^ l2;
        lArray[1] = lArray[1] ^ l2;
        dArray[0] = (double)lArray[0] * 4.190951585769653E-8 - 90.0;
        dArray[1] = (double)lArray[1] * 8.381903171539307E-8 - 180.0;
        return dArray;
    }

    public static long fromString(String string) {
        int n = string.length() * 2;
        long l = 0L;
        if (32 != n) {
            l = Long.parseLong(string, 16);
            l <<= 2 * (32 - n);
        } else {
            l = new BigInteger(string, 16).longValue();
        }
        return l;
    }

    public static Coverage coverSegment(long l, long l2, double d, int n, long[] lArray, boolean bl) {
        long[] lArray2 = HHCodeHelper.splitHHCode(l, 32);
        long[] lArray3 = HHCodeHelper.splitHHCode(l2, 32);
        return HHCodeHelper.coverSegment(lArray2[0], lArray2[1], lArray3[0], lArray3[1], d, n, lArray, bl);
    }

    public static Coverage coverSegment(long l, long l2, double d, int n) {
        return HHCodeHelper.coverSegment(l, l2, d, n, null, false);
    }

    public static Coverage coverSegment(long l, long l2, long l3, long l4, double d, int n, long[] lArray, boolean bl) {
        return HHCodeHelper.coverSegment(l, l2, l3, l4, d, n, new Coverage(), null, false);
    }

    public static Coverage coverSegment(long l, long l2, long l3, long l4, double d, int n) {
        return HHCodeHelper.coverSegment(l, l2, l3, l4, d, n, null, false);
    }

    public static Coverage coverSegment(long l, long l2, long l3, long l4, double d, int n, Coverage coverage, long[] lArray, boolean bl) {
        long[] lArray2 = new long[2];
        long[] lArray3 = new long[2];
        lArray2[0] = l;
        lArray2[1] = l2;
        lArray3[0] = l3;
        lArray3[1] = l4;
        long[] lArray4 = HHCodeHelper.getScale(HHCodeHelper.buildHHCode((lArray3[0] + lArray2[0]) / 2L, (lArray3[1] + lArray2[1]) / 2L));
        long[] lArray5 = new long[2];
        long[] lArray6 = new long[2];
        lArray5[0] = lArray3[0] - lArray2[0];
        lArray5[1] = lArray3[1] - lArray2[1];
        lArray6[0] = -lArray5[1];
        lArray6[1] = lArray5[0];
        double d2 = Math.sqrt(Math.pow((double)lArray5[0] / 214.7311863050956, 2.0) + Math.pow(lArray5[1] / lArray4[1], 2.0));
        double d3 = Math.sqrt(Math.pow((double)lArray6[0] / 214.7311863050956, 2.0) + Math.pow(lArray6[1] / lArray4[1], 2.0));
        ArrayList<Long> arrayList = new ArrayList<Long>(4);
        ArrayList<Long> arrayList2 = new ArrayList<Long>(4);
        long[] lArray7 = new long[2];
        long[] lArray8 = new long[2];
        long[] lArray9 = new long[2];
        long[] lArray10 = new long[2];
        lArray7[0] = lArray2[0] + (long)((double)lArray6[0] * (d / d3) - (double)lArray5[0] * (d / d2));
        lArray7[1] = lArray2[1] + (long)((double)lArray6[1] * (d / d3) - (double)lArray5[1] * (d / d2));
        lArray8[0] = lArray7[0] + (long)((double)lArray5[0] * ((d2 + 2.0 * d) / d2));
        lArray8[1] = lArray7[1] + (long)((double)lArray5[1] * ((d2 + 2.0 * d) / d2));
        lArray9[0] = lArray8[0] - (long)((double)lArray6[0] * (2.0 * d / d3));
        lArray9[1] = lArray8[1] - (long)((double)lArray6[1] * (2.0 * d / d3));
        lArray10[0] = lArray9[0] - (long)((double)lArray5[0] * ((d2 + 2.0 * d) / d2));
        lArray10[1] = lArray9[1] - (long)((double)lArray5[1] * ((d2 + 2.0 * d) / d2));
        arrayList.add(lArray7[0]);
        arrayList2.add(lArray7[1]);
        arrayList.add(lArray8[0]);
        arrayList2.add(lArray8[1]);
        arrayList.add(lArray9[0]);
        arrayList2.add(lArray9[1]);
        arrayList.add(lArray10[0]);
        arrayList2.add(lArray10[1]);
        return HHCodeHelper.coverPolygon(arrayList, arrayList2, n, coverage, lArray, bl);
    }

    public static Coverage coverSegment(long l, long l2, long l3, long l4, double d, int n, Coverage coverage) {
        return HHCodeHelper.coverSegment(l, l2, l3, l4, d, n, coverage, null, false);
    }

    public static double loxodromicDistance(long l, long l2) {
        long[] lArray = HHCodeHelper.splitHHCode(l, 32);
        long[] lArray2 = HHCodeHelper.splitHHCode(l2, 32);
        double d = HHCodeHelper.getLatScale((lArray[0] + lArray2[0]) / 2L);
        double d2 = (double)(lArray[0] - lArray2[0]) * 0.004656985402107239;
        long l3 = Math.abs(lArray[1] - lArray2[1]);
        if (l3 > Integer.MAX_VALUE) {
            l3 = 0xFFFFFFFFL - l3;
        }
        double d3 = (double)l3 * 0.009313970804214478 * d;
        return Math.sqrt(d2 * d2 + d3 * d3);
    }

    public static double orthodromicDistance(long l, long l2) {
        long[] lArray = HHCodeHelper.splitHHCode(l, 32);
        long[] lArray2 = HHCodeHelper.splitHHCode(l2, 32);
        return HHCodeHelper.orthodromicDistance(lArray[0], lArray[1], lArray2[0], lArray2[1]);
    }

    public static double orthodromicDistance(long l, long l2, long l3, long l4) {
        double d = (double)l * 7.314590396335798E-10 - 1.5707963267948966;
        double d2 = (double)l2 * 1.4629180792671596E-9 - Math.PI;
        double d3 = (double)l3 * 7.314590396335798E-10 - 1.5707963267948966;
        double d4 = (double)l4 * 1.4629180792671596E-9 - Math.PI;
        double d5 = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((d - d3) / 2.0), 2.0) + Math.cos(d) * Math.cos(d3) * Math.pow(Math.sin((d2 - d4) / 2.0), 2.0)));
        return d5 * 57.29577951308232 * 111120.0;
    }

    public static long[] gcIntermediate(long l, long l2, long l3, long l4, double d) {
        if (l < 0L || l3 < 0L || l >= 0x100000000L || l3 >= 0x100000000L) {
            return null;
        }
        if (Math.abs(l2 - l4) >= 0x80000000L) {
            return null;
        }
        long[] lArray = new long[2];
        if (d <= 0.0) {
            lArray[0] = l;
            lArray[1] = l2;
            return lArray;
        }
        if (d >= 1.0) {
            lArray[0] = l3;
            lArray[1] = l4;
            return lArray;
        }
        long l5 = 0L;
        if (l2 < 0L && l4 < 0L) {
            while (l2 + l5 < 0L) {
                l5 += 0x100000000L;
            }
        } else if (l2 >= 0x100000000L && l4 >= 0x100000000L) {
            while (l2 + l5 >= 0x100000000L) {
                l5 -= 0x100000000L;
            }
        }
        double d2 = (double)l * 7.314590396335798E-10 - 1.5707963267948966;
        double d3 = (double)(l2 += l5) * 1.4629180792671596E-9 - Math.PI;
        double d4 = (double)l3 * 7.314590396335798E-10 - 1.5707963267948966;
        double d5 = (double)(l4 += l5) * 1.4629180792671596E-9 - Math.PI;
        double d6 = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((d2 - d4) / 2.0), 2.0) + Math.cos(d2) * Math.cos(d4) * Math.pow(Math.sin((d3 - d5) / 2.0), 2.0)));
        double d7 = Math.sin(d6);
        double d8 = Math.sin((1.0 - d) * d6) / d7;
        double d9 = Math.sin(d * d6) / d7;
        double d10 = d8 * Math.cos(d2) * Math.cos(d3) + d9 * Math.cos(d4) * Math.cos(d5);
        double d11 = d8 * Math.cos(d2) * Math.sin(d3) + d9 * Math.cos(d4) * Math.sin(d5);
        double d12 = d8 * Math.sin(d2) + d9 * Math.sin(d4);
        double d13 = Math.atan2(d12, Math.sqrt(d10 * d10 + d11 * d11));
        double d14 = Math.atan2(d11, d10);
        long l6 = (long)((d13 + 1.5707963267948966) / 7.314590396335798E-10);
        long l7 = (long)((d14 + Math.PI) / 1.4629180792671596E-9);
        l7 -= l5;
        if ((l2 -= l5) < (l4 -= l5)) {
            if (l7 < l2) {
                l7 += 0x100000000L;
            } else if (l7 > l4) {
                l7 -= 0x100000000L;
            }
        } else if (l7 < l4) {
            l7 += 0x100000000L;
        } else if (l7 > l2) {
            l7 -= 0x100000000L;
        }
        lArray[0] = l6;
        lArray[1] = l7;
        return lArray;
    }

    public static List<Long> orthodromize(long l, long l2, long l3, long l4, double d) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(l);
        arrayList.add(l2);
        arrayList.add(l3);
        arrayList.add(l4);
        long[] lArray = new long[]{l, l2, l3, l4};
        if (l < 0L || l > 0x100000000L || l3 < 0L || l3 > 0x100000000L) {
            return arrayList;
        }
        int n = 0;
        while (n < arrayList.size() - 2) {
            double d2;
            long l5 = Math.abs((Long)arrayList.get(n + 1) - (Long)arrayList.get(n + 3));
            if (l5 > Integer.MAX_VALUE) {
                d2 = 0.0;
                long l6 = (long)((double)((Long)arrayList.get(n)).longValue() * (1.0 - d2) + d2 * (double)((Long)arrayList.get(n + 2)).longValue());
                long l7 = (long)((double)((Long)arrayList.get(n + 1)).longValue() * (1.0 - d2) + d2 * (double)((Long)arrayList.get(n + 3)).longValue());
                arrayList.add(n + 2, l7);
                arrayList.add(n + 2, l6);
                continue;
            }
            d2 = (double)((Long)arrayList.get(n)).longValue() * 7.314590396335798E-10 - 1.5707963267948966;
            double d3 = (double)((Long)arrayList.get(n + 1)).longValue() * 1.4629180792671596E-9 - Math.PI;
            double d4 = (double)((Long)arrayList.get(n + 2)).longValue() * 7.314590396335798E-10 - 1.5707963267948966;
            double d5 = (double)((Long)arrayList.get(n + 3)).longValue() * 1.4629180792671596E-9 - Math.PI;
            double d6 = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((d2 - d4) / 2.0), 2.0) + Math.cos(d2) * Math.cos(d4) * Math.pow(Math.sin((d3 - d5) / 2.0), 2.0)));
            double d7 = Math.abs(d4 - d2) < TOLSQRT ? Math.cos(d2) : (d4 - d2) / Math.log(Math.tan(d4 / 2.0 + 0.7853981633974483) / Math.tan(d2 / 2.0 + 0.7853981633974483));
            double d8 = Math.sqrt((d4 - d2) * (d4 - d2) + d7 * d7 * (d5 - d3) * (d5 - d3));
            double d9 = d8 / d6;
            if (d9 < d) {
                n += 2;
                continue;
            }
            long[] lArray2 = HHCodeHelper.gcIntermediate((Long)arrayList.get(n), (Long)arrayList.get(n + 1), (Long)arrayList.get(n + 2), (Long)arrayList.get(n + 3), 0.5);
            arrayList.add(n + 2, lArray2[1]);
            arrayList.add(n + 2, lArray2[0]);
        }
        return arrayList;
    }

    public static byte[] toByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 7; i >= 0; --i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return byArray;
    }

    public static long fromBytes(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l |= (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    public static String geocellsToRegexp(long[] lArray) {
        String string;
        int n;
        Arrays.sort(lArray);
        String string2 = null;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (long l : lArray) {
            if (l < 0x1000000000000000L) continue;
            n = (int)(l >>> 60);
            string = Long.toHexString(l | 0xF000000000000000L);
            if (1 == n) {
                if (0 == stringBuilder.length()) {
                    stringBuilder.append("[");
                }
                stringBuilder.append(string.substring(1, 2));
                continue;
            }
            string3 = string.substring(1, n);
            if (!string3.equals(string2)) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append("].*");
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                stringBuilder.append(string3);
                stringBuilder.append("[");
            }
            stringBuilder.append(string, n, n + 1);
            string2 = string3;
        }
        for (long l : lArray) {
            if (l >= 0x1000000000000000L) continue;
            n = (int)(l >>> 60);
            string = Long.toHexString(l | 0xF000000000000000L);
            string3 = string.substring(1, n);
            if (!string3.equals(string2)) {
                if (stringBuilder.length() > 1) {
                    stringBuilder.append("].*");
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                stringBuilder.append(string3);
                stringBuilder.append("[");
            }
            stringBuilder.append(string, n, n + 1);
            string2 = string3;
        }
        stringBuilder.append("].*");
        arrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            String string4 = (String)object.next();
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }
}

