/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.geo;

import com.geoxp.geo.Coverage;
import com.geoxp.geo.HHCodeHelper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageHelper {
    private static final int MIN_LOD = 256;
    private static final int MAX_LOD = -1;

    public static Coverage fromGeoCells(long[] lArray) {
        Coverage coverage = new Coverage();
        for (long l : lArray) {
            int n = (int)((l & 0xF000000000000000L) >> 60 & 0xFL) << 1;
            long l2 = l << 4;
            coverage.addCell(n, l2);
        }
        coverage.optimize(0L);
        return coverage;
    }

    public static String toKML(Coverage coverage) throws IOException {
        StringWriter stringWriter = new StringWriter();
        CoverageHelper.toKML(coverage, stringWriter, true);
        return stringWriter.toString();
    }

    public static void toKML(Coverage coverage, Writer writer, boolean bl) throws IOException {
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.append("<kml xmlns=\"http://www.opengis.net/kml/2.2\">\n");
        writer.append("<Document>\n");
        writer.append("  <name>GeoXP Coverage</name>\n");
        writer.append("  <ScreenOverlay>\n");
        writer.append("    <overlayXY x=\"0\" y=\"0\" xunits=\"pixels\" yunits=\"pixels\"/>\n");
        writer.append("    <screenXY x=\"20\" y=\"50\" xunits=\"pixels\" yunits=\"pixels\"/>\n");
        writer.append("    <size>-1</size>\n");
        writer.append("    <Icon>\n");
        writer.append("      <href>http://farm5.static.flickr.com/4056/4477523262_bfd831c564_o.png</href>\n");
        writer.append("    </Icon>\n");
        writer.append("  </ScreenOverlay>\n");
        boolean bl2 = false;
        for (int n : coverage.getResolutions()) {
            for (long l : coverage.getCells(n)) {
                double[] dArray = HHCodeHelper.getHHCodeBBox(l, n);
                writer.append("  <Placemark>\n");
                writer.append("  <Style>\n");
                writer.append("    <LineStyle>\n");
                writer.append("      <color>c0008000</color>\n");
                writer.append("      <width>1</width>\n");
                writer.append("    </LineStyle>\n");
                writer.append("    <PolyStyle>\n");
                writer.append("      <color>c0f0f0f0</color>\n");
                writer.append("      <fill>1</fill>\n");
                if (bl) {
                    writer.append("      <outline>1</outline>\n");
                } else {
                    writer.append("      <outline>0</outline>\n");
                }
                writer.append("    </PolyStyle>\n");
                writer.append("  </Style>\n");
                writer.append("    <name>");
                writer.append(HHCodeHelper.toString(l, n));
                writer.append("</name>\n");
                writer.append("    <MultiGeometry>\n");
                writer.append("      <tessellate>1</tessellate>\n");
                writer.append("      <Polygon><outerBoundaryIs><LinearRing>\n");
                writer.append("        <coordinates>\n");
                writer.append("          ");
                writer.append(Double.toString(dArray[1]));
                writer.append(",");
                writer.append(Double.toString(dArray[0]));
                writer.append(",0\n");
                writer.append("          ");
                writer.append(Double.toString(dArray[1]));
                writer.append(",");
                writer.append(Double.toString(dArray[2]));
                writer.append(",0\n");
                writer.append("          ");
                writer.append(Double.toString(dArray[3]));
                writer.append(",");
                writer.append(Double.toString(dArray[2]));
                writer.append(",0\n");
                writer.append("          ");
                writer.append(Double.toString(dArray[3]));
                writer.append(",");
                writer.append(Double.toString(dArray[0]));
                writer.append(",0\n");
                writer.append("          ");
                writer.append(Double.toString(dArray[1]));
                writer.append(",");
                writer.append(Double.toString(dArray[0]));
                writer.append(",0\n");
                writer.append("        </coordinates>\n");
                writer.append("      </LinearRing></outerBoundaryIs></Polygon>\n");
                if (bl2) {
                    writer.append("      <Point>\n");
                    writer.append("        <coordinates>\n");
                    writer.append(Double.toString((dArray[3] + dArray[1]) / 2.0));
                    writer.append(",");
                    writer.append(Double.toString((dArray[2] + dArray[0]) / 2.0));
                    writer.append(",0");
                    writer.append("        </coordinates>\n");
                    writer.append("      </Point>\n");
                }
                writer.append("    </MultiGeometry>\n");
                writer.append("  </Placemark>\n");
            }
        }
        writer.append("</Document>\n");
        writer.append("</kml>\n");
    }

    public static float[] toEnvelope(Coverage coverage) {
        return CoverageHelper.toEnvelope(coverage.toGeoCells(30));
    }

    public static float[] toEnvelope(long[] lArray) {
        long l;
        List<Long> list;
        long l2;
        long l3;
        long l4;
        Set<Long> set;
        long l5;
        Map<Long, Set<Long>> map = CoverageHelper.getSegments(lArray, false);
        Map<Long, Set<Long>> map2 = CoverageHelper.getSegments(lArray, true);
        HashMap<Long, List<Object>> hashMap = new HashMap<Long, List<Object>>();
        int n = 0;
        Object object = map.keySet().iterator();
        while (object.hasNext()) {
            l5 = object.next();
            set = map.get(l5 &= 0xFFFFFFFFL);
            for (long l6 : set) {
                l4 = l6 >>> 32;
                l3 = l6 & 0xFFFFFFFFL;
                l2 = l4 << 32 | l5;
                list = (ArrayList<Long>)hashMap.get(l2);
                if (null == list) {
                    list = new ArrayList<Long>();
                    hashMap.put(l2, list);
                }
                l = l3 << 32 | l5;
                list.add(l);
                list = (List)hashMap.get(l);
                if (null == list) {
                    list = new ArrayList();
                    hashMap.put(l, list);
                }
                list.add(l2);
                ++n;
            }
        }
        object = map2.keySet().iterator();
        while (object.hasNext()) {
            l5 = object.next();
            set = map2.get(l5);
            l5 <<= 32;
            for (long l6 : set) {
                l4 = l6 >>> 32;
                l3 = l6 & 0xFFFFFFFFL;
                l2 = l5 | l4;
                list = (List)hashMap.get(l2);
                if (null == list) {
                    list = new ArrayList();
                    hashMap.put(l2, list);
                }
                l = l5 | l3;
                list.add(l);
                list = (List)hashMap.get(l);
                if (null == list) {
                    list = new ArrayList();
                    hashMap.put(l, list);
                }
                list.add(l2);
                ++n;
            }
        }
        object = new ArrayList();
        Long l7 = null;
        Long l8 = null;
        int n2 = 0;
        while (!hashMap.isEmpty()) {
            if (null == l7) {
                object.add(null);
                ++n2;
                l7 = (Long)hashMap.keySet().iterator().next();
                object.add(l7);
                l8 = l7;
            }
            if (!hashMap.containsKey(l7)) {
                l7 = null;
                continue;
            }
            long l9 = (Long)((List)hashMap.get(l7)).remove(((List)hashMap.get(l7)).size() - 1);
            ((List)hashMap.get(l9)).remove(l7);
            if (((List)hashMap.get(l9)).isEmpty()) {
                hashMap.remove(l9);
            }
            if (((List)hashMap.get(l7)).isEmpty()) {
                hashMap.remove(l7);
            }
            object.add(l9);
            if (l9 == l8) {
                l7 = null;
                continue;
            }
            l7 = l9;
        }
        float[] fArray = new float[object.size() * 2 - n2];
        int n3 = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Long l10 = (Long)iterator.next();
            if (null == l10) {
                fArray[n3++] = Float.NaN;
                continue;
            }
            float f = (float)HHCodeHelper.toLat(l10 >>> 32);
            float f2 = (float)HHCodeHelper.toLon(l10 & 0xFFFFFFFFL);
            fArray[n3++] = f;
            fArray[n3++] = f2;
        }
        return fArray;
    }

    private static Map<Long, Set<Long>> getSegments(long[] lArray, boolean bl) {
        Object object;
        Comparator<Long> comparator = new Comparator<Long>(){

            @Override
            public int compare(Long l, Long l2) {
                long l3;
                long l4 = l >>> 32;
                if (l4 < (l3 = l2 >>> 32)) {
                    return -1;
                }
                if (l4 > l3) {
                    return 1;
                }
                l4 = l & 0xFFFFFFFFL;
                if (l4 > (l3 = l2 & 0xFFFFFFFFL)) {
                    return -1;
                }
                if (l4 < l3) {
                    return 1;
                }
                return 0;
            }
        };
        HashMap<Long, PriorityQueue<Long>> hashMap = new HashMap<Long, PriorityQueue<Long>>();
        for (long l : lArray) {
            long l2;
            long l3;
            long l4;
            int n = (int)(l >>> 60 & 0xFL);
            long l5 = l << 4;
            object = HHCodeHelper.splitHHCode(l5, n * 2);
            if (bl) {
                l4 = object[0];
                object[0] = object[1];
                object[1] = l4;
            }
            l4 = object[1];
            if (0x100000000L == (l3 = object[1] + Coverage.CELL_SIZE_BY_RES[--n])) {
                --l3;
            }
            if (0x100000000L == (l2 = object[0] + Coverage.CELL_SIZE_BY_RES[n])) {
                --l2;
            }
            reference var19_22 = object[0] << 32 | l2;
            PriorityQueue<Long> priorityQueue = (PriorityQueue<Long>)hashMap.get(l4);
            if (null == priorityQueue) {
                priorityQueue = new PriorityQueue<Long>(comparator);
                hashMap.put(l4, priorityQueue);
            }
            priorityQueue.add((long)var19_22);
            priorityQueue = (PriorityQueue<Long>)hashMap.get(l3);
            if (null == priorityQueue) {
                priorityQueue = new PriorityQueue<Long>(comparator);
                hashMap.put(l3, priorityQueue);
            }
            priorityQueue.add((long)var19_22);
        }
        Object object2 = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            long l;
            long l6 = (Long)iterator.next();
            PriorityQueue priorityQueue = (PriorityQueue)hashMap.get(l6);
            PriorityQueue<Long> priorityQueue2 = new PriorityQueue<Long>(comparator);
            Long l7 = null;
            Long l8 = null;
            while (!priorityQueue.isEmpty()) {
                long l9 = (Long)priorityQueue.poll();
                l = l9 >>> 32;
                long l10 = l9 & 0xFFFFFFFFL;
                if (null == l7 && null == l8) {
                    l7 = l;
                    l8 = l10;
                    continue;
                }
                if (l == l7 && l10 == l8) {
                    l7 = null;
                    l8 = null;
                    continue;
                }
                if (l >= l7 && l10 <= l8) {
                    if (l > l7) {
                        priorityQueue.add(l7 << 32 | l);
                    }
                    if (l10 < l8) {
                        priorityQueue.add(l10 << 32 | l8);
                    }
                    l7 = null;
                    l8 = null;
                    continue;
                }
                if (l < l8 && l10 > l8) {
                    if (l > l7) {
                        priorityQueue.add(l7 << 32 | l);
                    }
                    priorityQueue.add(l8 << 32 | l10);
                    l7 = null;
                    l8 = null;
                    continue;
                }
                if (l < l8) continue;
                priorityQueue2.add(l7 << 32 | l8);
                l7 = l;
                l8 = l10;
            }
            if (null != l7 && null != l8) {
                priorityQueue2.add(l7 << 32 | l8);
            }
            object = null;
            HashSet<Object> hashSet = new HashSet<Object>();
            while (!priorityQueue2.isEmpty()) {
                if (null == object) {
                    object = priorityQueue2.poll();
                    continue;
                }
                l = priorityQueue2.poll();
                if (((Long)object & 0xFFFFFFFFL) == l >>> 32) {
                    object = (Long)object & 0xFFFFFFFF00000000L | l & 0xFFFFFFFFL;
                    continue;
                }
                hashSet.add(object);
                object = l;
            }
            if (null != object) {
                hashSet.add(object);
            }
            if (hashSet.isEmpty()) continue;
            object2.put(l6, hashSet);
        }
        return object2;
    }

    public static void kmlEnvelope(Writer writer, long[] lArray) throws IOException {
        float[] fArray = CoverageHelper.toEnvelope(lArray);
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.append("<kml xmlns=\"http://www.opengis.net/kml/2.2\">\n");
        writer.append("<Document>\n");
        writer.append("  <name>GeoXP Coverage</name>\n");
        writer.append("  <ScreenOverlay>\n");
        writer.append("    <overlayXY x=\"0\" y=\"0\" xunits=\"pixels\" yunits=\"pixels\"/>\n");
        writer.append("    <screenXY x=\"20\" y=\"50\" xunits=\"pixels\" yunits=\"pixels\"/>\n");
        writer.append("    <size>-1</size>\n");
        writer.append("    <Icon>\n");
        writer.append("      <href>http://farm5.static.flickr.com/4056/4477523262_bfd831c564_o.png</href>\n");
        writer.append("    </Icon>\n");
        writer.append("  </ScreenOverlay>\n");
        writer.append("  <Placemark>\n");
        writer.append("  <Style>\n");
        writer.append("    <LineStyle>\n");
        writer.append("      <color>ffffffff</color>\n");
        writer.append("      <width>1</width>\n");
        writer.append("    </LineStyle>\n");
        writer.append("    <PolyStyle>\n");
        writer.append("      <color>c0f0f0f0</color>\n");
        writer.append("      <fill>1</fill>\n");
        writer.append("      <outline>1</outline>\n");
        writer.append("    </PolyStyle>\n");
        writer.append("  </Style>\n");
        writer.append("    <MultiGeometry>\n");
        writer.append("      <tessellate>1</tessellate>\n");
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        while (n < fArray.length) {
            if (Float.isNaN(fArray[n])) {
                if (bl) {
                    writer.append("\n");
                    writer.append("        </coordinates>\n");
                    writer.append("      </LinearRing></outerBoundaryIs></Polygon>\n");
                    bl = false;
                }
                writer.append("      <Polygon><outerBoundaryIs><LinearRing>\n");
                writer.append("        <coordinates>\n");
                bl = true;
                bl2 = true;
                ++n;
                continue;
            }
            if (!bl2) {
                writer.append(",");
            } else {
                writer.append("          ");
            }
            bl2 = false;
            writer.append(Float.toString(fArray[n + 1]));
            writer.append(",");
            writer.append(Float.toString(fArray[n]));
            writer.append(",0");
            n += 2;
        }
        if (bl) {
            writer.append("\n");
            writer.append("        </coordinates>\n");
            writer.append("      </LinearRing></outerBoundaryIs></Polygon>\n");
            bl = false;
        }
        writer.append("    </MultiGeometry>\n");
        writer.append("  </Placemark>\n");
        writer.append("</Document>\n");
        writer.append("</kml>\n");
    }
}

