/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.geo;

import com.geoxp.geo.Coverage;
import com.geoxp.geo.HHCodeHelper;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoParser {
    private static final int QUADRANT_POLYGON_APPROX_SIDES = 16;

    public static Coverage parsePolygon(String string, int n) {
        return GeoParser.parsePolygon(string, n, new Coverage());
    }

    public static Coverage parsePolygon(String string, int n, Coverage coverage) {
        String[] stringArray = string.split(",");
        if (stringArray.length < 3) {
            return new Coverage();
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length != 2) continue;
            try {
                double d = Double.valueOf(stringArray2[0]);
                double d2 = Double.valueOf(stringArray2[1]);
                arrayList.add(HHCodeHelper.toLongLat(d));
                arrayList2.add(HHCodeHelper.toLongLon(d2));
            }
            catch (NumberFormatException numberFormatException) {
                return new Coverage();
            }
        }
        if (((Long)arrayList.get(0)).equals(arrayList.get(arrayList.size() - 1)) && ((Long)arrayList2.get(0)).equals(arrayList2.get(arrayList2.size() - 1))) {
            arrayList.remove(0);
            arrayList2.remove(0);
        }
        return HHCodeHelper.coverPolygon(arrayList, arrayList2, n, coverage);
    }

    public static Coverage parsePath(String string, int n) {
        return GeoParser.parsePath(string, n, new Coverage());
    }

    public static Coverage parsePath(String string, int n, Coverage coverage) {
        String[] stringArray = string.split(",");
        if (stringArray.length < 2) {
            return coverage;
        }
        double d = 0.0;
        String[] stringArray2 = stringArray[0].split(":");
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i].split(":");
            try {
                if (stringArray2.length == 3) {
                    d = Double.valueOf(stringArray2[2]);
                }
                long l = HHCodeHelper.toLongLat(Double.valueOf(stringArray2[0]));
                long l2 = HHCodeHelper.toLongLon(Double.valueOf(stringArray2[1]));
                long l3 = HHCodeHelper.toLongLat(Double.valueOf(stringArray3[0]));
                long l4 = HHCodeHelper.toLongLon(Double.valueOf(stringArray3[1]));
                if (d > 0.0) {
                    Coverage coverage2 = HHCodeHelper.coverSegment(l, l2, l3, l4, d, n);
                    coverage.merge(coverage2);
                }
                stringArray2 = stringArray3;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                return new Coverage();
            }
        }
        return coverage;
    }

    public static Coverage parseCircle(String string, int n) {
        return GeoParser.parseCircle(string, n, new Coverage());
    }

    public static Coverage parseCircle(String string, int n, Coverage coverage) {
        String[] stringArray = string.split(":");
        if (stringArray.length != 3) {
            return coverage;
        }
        try {
            double d = Double.valueOf(stringArray[0]);
            double d2 = Double.valueOf(stringArray[1]);
            double d3 = Math.abs(Double.valueOf(stringArray[2]));
            long[] lArray = new long[]{HHCodeHelper.toLongLat(d), HHCodeHelper.toLongLon(d2)};
            ArrayList<Long> arrayList = new ArrayList<Long>(64);
            ArrayList<Long> arrayList2 = new ArrayList<Long>(64);
            for (int i = 0; i < 64; ++i) {
                arrayList.add(0L);
                arrayList2.add(0L);
            }
            double d4 = Math.cos(Math.toRadians(d));
            long l = Math.round(d3 * 214.7311863050956);
            long l2 = Math.round(d3 * 107.36559315254779 / d4);
            double d5 = 0.09817477042468103;
            for (int i = 0; i < 16; ++i) {
                double d6 = (double)i * d5;
                double d7 = Math.cos(d6);
                double d8 = Math.sin(d6);
                arrayList.set(i, (long)((double)lArray[0] + d8 * (double)l));
                arrayList2.set(i, (long)((double)lArray[1] + d7 * (double)l2));
                arrayList.set(i + 16, (long)((double)lArray[0] + d7 * (double)l));
                arrayList2.set(i + 16, (long)((double)lArray[1] - d8 * (double)l2));
                arrayList.set(i + 32, (long)((double)lArray[0] - d8 * (double)l));
                arrayList2.set(i + 32, (long)((double)lArray[1] - d7 * (double)l2));
                arrayList.set(i + 48, (long)((double)lArray[0] - d7 * (double)l));
                arrayList2.set(i + 48, (long)((double)lArray[1] + d8 * (double)l2));
            }
            return HHCodeHelper.coverPolygon(arrayList, arrayList2, n, coverage);
        }
        catch (NumberFormatException numberFormatException) {
            return coverage;
        }
    }

    public static Coverage parseViewport(String string, int n) {
        return GeoParser.parseViewport(string, n, new Coverage());
    }

    public static Coverage parseViewport(String string, int n, Coverage coverage) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 2) {
            return coverage;
        }
        String[] stringArray2 = stringArray[0].split(":");
        String[] stringArray3 = stringArray[1].split(":");
        try {
            double d;
            double d2 = Double.valueOf(stringArray2[0]);
            double d3 = Double.valueOf(stringArray2[1]);
            double d4 = Double.valueOf(stringArray3[0]);
            double d5 = Double.valueOf(stringArray3[1]);
            if (d2 > d4) {
                d = d2;
                d2 = d4;
                d4 = d;
            }
            if (d3 > d5) {
                d = d3;
                d3 = d5;
                d5 = d;
            }
            ArrayList arrayList = new ArrayList();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            ArrayList<Long> arrayList3 = new ArrayList<Long>();
            arrayList2.add(HHCodeHelper.toLongLat(d2));
            arrayList3.add(HHCodeHelper.toLongLon(d3));
            arrayList2.add(HHCodeHelper.toLongLat(d2));
            arrayList3.add(HHCodeHelper.toLongLon(d5));
            arrayList2.add(HHCodeHelper.toLongLat(d4));
            arrayList3.add(HHCodeHelper.toLongLon(d5));
            arrayList2.add(HHCodeHelper.toLongLat(d4));
            arrayList3.add(HHCodeHelper.toLongLon(d3));
            arrayList2.add(HHCodeHelper.toLongLat(d2));
            arrayList3.add(HHCodeHelper.toLongLon(d3));
            return HHCodeHelper.coverPolygon(arrayList2, arrayList3, n, coverage);
        }
        catch (NumberFormatException numberFormatException) {
            return coverage;
        }
    }

    public static List<Long>[] parseEncodedPolyline(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        while (n < n2) {
            int n5;
            int n6 = 0;
            int n7 = 0;
            do {
                n5 = string.charAt(n++) - 63;
                n7 |= (n5 & 0x1F) << n6;
                n6 += 5;
            } while (n5 >= 32 && n < n2);
            int n8 = (n7 & 1) != 0 ? ~(n7 >> 1) : n7 >> 1;
            n3 += n8;
            n6 = 0;
            n7 = 0;
            if (n < n2) {
                do {
                    n5 = string.charAt(n++) - 63;
                    n7 |= (n5 & 0x1F) << n6;
                    n6 += 5;
                } while (n5 >= 32 && n < n2);
                int n9 = (n7 & 1) != 0 ? ~(n7 >> 1) : n7 >> 1;
                n4 += n9;
            }
            arrayList.add(HHCodeHelper.toLongLat((double)n3 / 100000.0));
            arrayList2.add(HHCodeHelper.toLongLon((double)n4 / 100000.0));
        }
        List[] listArray = new List[]{arrayList, arrayList2};
        return listArray;
    }

    public static long parseLatLon(String string) {
        String[] stringArray = string.split(":");
        return HHCodeHelper.getHHCodeValue(Double.valueOf(stringArray[0]), Double.valueOf(stringArray[1]));
    }

    public static Coverage parseArea(String string, int n) {
        return GeoParser.parseArea(string, n, new Coverage());
    }

    public static Coverage parseArea(String string, int n, Coverage coverage) {
        if (string.startsWith("circle:")) {
            return GeoParser.parseCircle(string.substring(7), n, coverage);
        }
        if (string.startsWith("polygon:")) {
            return GeoParser.parsePolygon(string.substring(8), n, coverage);
        }
        if (string.startsWith("rect:")) {
            return GeoParser.parseViewport(string.substring(5), n, coverage);
        }
        if (string.startsWith("path:")) {
            return GeoParser.parsePath(string.substring(5), n, coverage);
        }
        if (string.startsWith("polyline:")) {
            int n2 = string.substring(9).indexOf(":");
            Coverage coverage2 = coverage;
            if (-1 == n2) {
                return coverage2;
            }
            try {
                double d = Double.valueOf(string.substring(9, 9 + n2));
                List<Long>[] listArray = GeoParser.parseEncodedPolyline(string.substring(9 + n2 + 1));
                for (int i = 0; i < listArray[0].size() - 1; ++i) {
                    HHCodeHelper.coverSegment(listArray[0].get(i), listArray[1].get(i), listArray[0].get(i + 1), listArray[1].get(i + 1), d, n, coverage2);
                }
                return coverage2;
            }
            catch (NumberFormatException numberFormatException) {
                return coverage2;
            }
        }
        return coverage;
    }
}

