/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.geo;

import com.geoxp.geo.Coverage;
import com.geoxp.geo.HHCodeHelper;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.predicate.RectangleIntersects;

public class JTSHelper {
    private static double[] resLatOffset = new double[33];
    private static double[] resLonOffset = new double[33];
    private static long[] level2GeoCells = new long[]{0x1000000000000000L, 0x1100000000000000L, 0x1200000000000000L, 0x1300000000000000L, 0x1400000000000000L, 0x1500000000000000L, 0x1600000000000000L, 0x1700000000000000L, 0x1800000000000000L, 0x1900000000000000L, 0x1A00000000000000L, 0x1B00000000000000L, 0x1C00000000000000L, 0x1D00000000000000L, 0x1E00000000000000L, 0x1F00000000000000L};
    private static ThreadLocal<Coordinate[]> coordinateCache;
    private static ThreadLocal<GeometryFactory> factoryCache;

    public static LinearRing hhcodeToLinearRing(long l, int n) {
        Coordinate[] coordinateArray = new Coordinate[5];
        double[] dArray = HHCodeHelper.getLatLon(l, n);
        coordinateArray[0] = new Coordinate(dArray[1], dArray[0]);
        coordinateArray[1] = new Coordinate(dArray[1], dArray[0] + resLatOffset[n]);
        coordinateArray[2] = new Coordinate(dArray[1] + resLonOffset[n], dArray[0] + resLatOffset[n]);
        coordinateArray[3] = new Coordinate(dArray[1] + resLonOffset[n], dArray[0]);
        coordinateArray[4] = coordinateArray[0];
        return new GeometryFactory().createLinearRing(coordinateArray);
    }

    public static LinearRing geoCellToLinearRing(long l) {
        int n = (int)((l & 0xF000000000000000L) >> 60 & 0xFL);
        return JTSHelper.hhcodeToLinearRing(l << 4, n << 1);
    }

    public static Coverage coverGeometry(Geometry geometry, int n, int n2, boolean bl, int n3) {
        long[] lArray = new long[256];
        int n4 = 0;
        for (long l : level2GeoCells) {
            lArray[n4++] = l;
        }
        Object object = new Coverage();
        LinearRing[] linearRingArray = new LinearRing[]{};
        GeometryFactory geometryFactory = new GeometryFactory();
        int n5 = 0;
        int n6 = n4;
        int n7 = 0;
        while (0 != n6 && n5 < n3) {
            int n8;
            long[] lArray2;
            long l = lArray[n7++];
            --n6;
            int n9 = (int)((l & 0xF000000000000000L) >> 60 & 0xFL) << 1;
            Polygon polygon = new Polygon(JTSHelper.hhcodeToLinearRing(l << 4, n9), linearRingArray, geometryFactory);
            if (!RectangleIntersects.intersects((Polygon)polygon, (Geometry)geometry)) continue;
            if (n2 == n9 && !bl) {
                ((Coverage)object).addCell(n9, l << 4);
                ++n5;
                continue;
            }
            if (geometry.covers((Geometry)polygon) && n9 >= n) {
                if (n2 < 0) {
                    n2 = n9 - n2;
                }
                ((Coverage)object).addCell(n9, l << 4);
                ++n5;
                continue;
            }
            if (n2 == n9) continue;
            if (30 == n9) {
                long[] lArray3 = lArray2 = HHCodeHelper.getSubGeoCells(l);
                n8 = lArray3.length;
                for (int i = 0; i < n8; ++i) {
                    long l2 = lArray3[i];
                    LinearRing linearRing = JTSHelper.hhcodeToLinearRing(l2, 32);
                    if ((!geometry.intersects((Geometry)linearRing) || bl) && !geometry.covers((Geometry)linearRing)) continue;
                    ((Coverage)object).addCell(32, l2);
                    ++n5;
                }
                continue;
            }
            if (lArray.length < n4 + 16) {
                if (n7 > 16) {
                    for (int i = 0; i < n6; ++i) {
                        lArray[i] = lArray[n7 + i];
                    }
                    n4 = n6;
                    n7 = 0;
                } else {
                    lArray2 = new long[Math.min(lArray.length * 2, lArray.length + 65536)];
                    System.arraycopy(lArray, n7, lArray2, 0, n6);
                    n7 = 0;
                    n4 = n6;
                    lArray = lArray2;
                }
            }
            lArray2 = HHCodeHelper.getSubGeoCells(l);
            int n10 = lArray2.length;
            for (n8 = 0; n8 < n10; ++n8) {
                long l3 = lArray2[n8];
                lArray[n4++] = l3;
            }
            n6 += 16;
        }
        if (0 != n6) {
            return null;
        }
        return object;
    }

    public static Coverage coverGeometry(Geometry geometry, int n, int n2, boolean bl) {
        return JTSHelper.coverGeometry(geometry, n, n2, bl, Integer.MAX_VALUE);
    }

    static {
        for (int i = 0; i < 33; ++i) {
            JTSHelper.resLatOffset[i] = 4.190951585769653E-8 * (double)(1 << 32 - i);
            JTSHelper.resLonOffset[i] = 8.381903171539307E-8 * (double)(1 << 32 - i);
        }
        coordinateCache = new ThreadLocal<Coordinate[]>(){

            @Override
            protected Coordinate[] initialValue() {
                return new Coordinate[5];
            }
        };
        factoryCache = new ThreadLocal<GeometryFactory>(){

            @Override
            protected GeometryFactory initialValue() {
                return new GeometryFactory();
            }
        };
    }
}

