/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.geo;

import com.fasterxml.sort.SortConfig;
import com.fasterxml.sort.std.TextFileSorter;
import com.geoxp.geo.Coverage;
import com.geoxp.geo.GeoParser;
import com.geoxp.geo.HHCodeHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OutputStreamCoverage
extends Coverage {
    private final OutputStream os;
    private final byte[] suffix;
    private static long MERGE_SORT_MAX_MEMORY = null == System.getProperty("merge.sort.max.memory") ? 2000000L : Long.valueOf(System.getProperty("merge.sort.max.memory"));
    private ThreadLocal<Long> lastCell = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return null;
        }
    };
    private static long[] RESOLUTION_MASKS = new long[]{-1152921504606846976L, -72057594037927936L, -4503599627370496L, -281474976710656L, -17592186044416L, -1099511627776L, -68719476736L, -4294967296L, -268435456L, -16777216L, -1048576L, -65536L, -4096L, -256L, -16L, -1L};

    public OutputStreamCoverage(OutputStream outputStream) {
        this.os = outputStream;
        this.suffix = null;
    }

    public OutputStreamCoverage(OutputStream outputStream, String string) {
        this.os = outputStream;
        this.suffix = string.getBytes();
    }

    public void addCell(int n, long l, long l2) {
        l = (l % 0x100000000L + 0x100000000L) % 0x100000000L;
        l2 = (l2 % 0x100000000L + 0x100000000L) % 0x100000000L;
        this.addCell(n, HHCodeHelper.buildHHCode(l, l2, 32));
    }

    public void addCell(int n, long l) {
        int n2 = (n >> 1) - 1;
        if (0 != (n2 & 0xFFFFFFF0)) {
            return;
        }
        if (null != this.lastCell.get() && this.lastCell.get().equals(l &= RESOLUTION_MASKS[n2])) {
            return;
        }
        this.lastCell.set(l);
        try {
            this.os.write(HHCodeHelper.toString(l, n).getBytes());
            if (null != this.suffix) {
                this.os.write(this.suffix);
            }
            this.os.write(10);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void merge(Coverage coverage) {
        Map<Integer, Set<Long>> map = coverage.getAllCells();
        for (int n : map.keySet()) {
            for (long l : map.get(n)) {
                try {
                    this.os.write(HHCodeHelper.toString(l, n).getBytes());
                    this.os.write(10);
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void merge(InputStream inputStream, InputStream inputStream2, OutputStream outputStream) throws IOException {
        String string;
        SequenceInputStream sequenceInputStream = new SequenceInputStream(inputStream, inputStream2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sequenceInputStream));
        PrintStream printStream = new PrintStream(outputStream);
        while (null != (string = bufferedReader.readLine())) {
            printStream.println(string);
        }
        bufferedReader.close();
        printStream.close();
    }

    public static void prune(InputStream inputStream, OutputStream outputStream, long l, int n) throws IOException {
        String string;
        File file = File.createTempFile("OutputStreamCoverage.optimize", "");
        file.deleteOnExit();
        TextFileSorter textFileSorter = new TextFileSorter(new SortConfig().withMaxMemoryUsage(2000000L));
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        textFileSorter.sort(inputStream, (OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        inputStream = new FileInputStream(file);
        String string2 = "0123456789abcdef";
        int[] nArray = new int[16];
        for (int i = 0; i < 16; ++i) {
            nArray[i] = (int)(l >> 60 - 4 * i & 0xFL);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        int n2 = 17;
        String string3 = null;
        int n3 = 0;
        while (null != (string = bufferedReader.readLine())) {
            if (string.length() * 2 <= n) {
                outputStream.write(string.getBytes());
                outputStream.write(10);
                continue;
            }
            String string4 = string.substring(0, string.length() - 1);
            String string5 = string.substring(string4.length());
            if (null == string3) {
                n3 = (short)(1 << Integer.valueOf(string5, 16));
                n2 = nArray[string.length() - 1];
                if (0 == n2) {
                    n2 = 16;
                }
                string3 = string4;
                continue;
            }
            if (string4.equals(string3)) {
                n3 = (short)(n3 | (short)(1 << Integer.valueOf(string5, 16)));
                continue;
            }
            int n4 = n3 & 0xFFFF;
            int n5 = 0;
            while (n4 > 0) {
                n4 &= n4 - 1;
                ++n5;
            }
            if (n5 > n2) {
                for (int i = 0; i < 16; ++i) {
                    if (0 == (n3 & (short)(1 << i))) continue;
                    outputStream.write(string3.getBytes());
                    outputStream.write(string2.charAt(i));
                    outputStream.write(10);
                }
            }
            n3 = (short)(1 << Integer.valueOf(string5, 16));
            n2 = nArray[string.length() - 1];
            if (0 == n2) {
                n2 = 16;
            }
            string3 = string4;
        }
        bufferedReader.close();
        int n6 = n3 & 0xFFFF;
        int n7 = 0;
        while (n6 > 0) {
            n6 &= n6 - 1;
            ++n7;
        }
        if (n7 > n2) {
            for (int i = 0; i < 16; ++i) {
                if (0 == (n3 & (short)(1 << i))) continue;
                outputStream.write(string3.getBytes());
                outputStream.write(string2.charAt(i));
                outputStream.write(10);
            }
        }
        outputStream.close();
    }

    public static void optimize(InputStream inputStream, OutputStream outputStream, long l, int n) throws IOException {
        String string;
        File file = File.createTempFile("OutputStreamCoverage.optimize", "");
        file.deleteOnExit();
        TextFileSorter textFileSorter = new TextFileSorter(new SortConfig().withMaxMemoryUsage(MERGE_SORT_MAX_MEMORY));
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        textFileSorter.sort(inputStream, (OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        inputStream = new FileInputStream(file);
        String string2 = "0123456789abcdef";
        int[] nArray = new int[16];
        for (int i = 0; i < 16; ++i) {
            nArray[i] = (int)(l >> 60 - 4 * i & 0xFL);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        int n2 = 17;
        String string3 = null;
        int n3 = 0;
        while (null != (string = bufferedReader.readLine())) {
            if (string.length() * 2 <= n) {
                outputStream.write(string.getBytes());
                outputStream.write(10);
                continue;
            }
            String string4 = string.substring(0, string.length() - 1);
            String string5 = string.substring(string4.length());
            if (null == string3) {
                n3 = (short)(1 << Integer.valueOf(string5, 16));
                n2 = nArray[string.length() - 1];
                if (0 == n2) {
                    n2 = 16;
                }
                string3 = string4;
                continue;
            }
            if (string4.equals(string3)) {
                n3 = (short)(n3 | (short)(1 << Integer.valueOf(string5, 16)));
                continue;
            }
            int n4 = n3 & 0xFFFF;
            int n5 = 0;
            while (n4 > 0) {
                n4 &= n4 - 1;
                ++n5;
            }
            if (n5 >= n2) {
                outputStream.write(string3.getBytes());
                outputStream.write(10);
            } else {
                for (int i = 0; i < 16; ++i) {
                    if (0 == (n3 & (short)(1 << i))) continue;
                    outputStream.write(string3.getBytes());
                    outputStream.write(string2.charAt(i));
                    outputStream.write(10);
                }
            }
            n3 = (short)(1 << Integer.valueOf(string5, 16));
            n2 = nArray[string.length() - 1];
            if (0 == n2) {
                n2 = 16;
            }
            string3 = string4;
        }
        bufferedReader.close();
        int n6 = n3 & 0xFFFF;
        int n7 = 0;
        while (n6 > 0) {
            n6 &= n6 - 1;
            ++n7;
        }
        if (n7 >= n2) {
            outputStream.write(string3.getBytes());
            outputStream.write(10);
        } else {
            for (int i = 0; i < 16; ++i) {
                if (0 == (n3 & (short)(1 << i))) continue;
                outputStream.write(string3.getBytes());
                outputStream.write(string2.charAt(i));
                outputStream.write(10);
            }
        }
        outputStream.close();
    }

    public static void normalize(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        PrintStream printStream = new PrintStream(outputStream);
        while (null != (string = bufferedReader.readLine())) {
            if (2 * string.length() >= n) {
                printStream.println(string.substring(0, n >> 1));
                continue;
            }
            for (int i = 0; i < 1 << 2 * (n - 2 * string.length()); ++i) {
                printStream.print(string);
                printStream.println(Long.toHexString(Long.MIN_VALUE | (long)i).substring(16 - ((n >> 1) - string.length())));
            }
        }
        bufferedReader.close();
        printStream.close();
    }

    public static void minus(InputStream inputStream, final InputStream inputStream2, OutputStream outputStream) throws IOException {
        InputStream inputStream3 = new InputStream(){
            private boolean lf = false;

            public int read() throws IOException {
                if (this.lf) {
                    this.lf = false;
                    return 10;
                }
                int n = inputStream2.read();
                if (10 == n) {
                    this.lf = true;
                    return 45;
                }
                return n;
            }

            public void close() throws IOException {
                super.close();
                inputStream2.close();
            }
        };
        SequenceInputStream sequenceInputStream = new SequenceInputStream(inputStream, inputStream3);
        TextFileSorter textFileSorter = new TextFileSorter(new SortConfig().withMaxMemoryUsage(MERGE_SORT_MAX_MEMORY));
        File file = File.createTempFile("OuputStreamCoverage.minus", "");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        textFileSorter.sort((InputStream)sequenceInputStream, (OutputStream)fileOutputStream);
        fileOutputStream.close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String string = null;
        PrintStream printStream = new PrintStream(outputStream);
        while (true) {
            String string2;
            if (null == (string2 = bufferedReader.readLine())) {
                if (null == string) break;
                printStream.println(string);
                break;
            }
            if (null == string && !string2.endsWith("-")) {
                string = string2;
                continue;
            }
            if (null == string) continue;
            if (string2.startsWith(string) && string2.endsWith("-") && string2.length() == string.length() + 1) {
                string = null;
                continue;
            }
            if (string2.endsWith("-")) {
                printStream.println(string);
                string = null;
                continue;
            }
            if (string2.equals(string)) continue;
            printStream.println(string);
            string = string2;
        }
        bufferedReader.close();
        printStream.close();
    }

    public static void intersection(InputStream inputStream, final InputStream inputStream2, OutputStream outputStream) throws IOException {
        String string;
        InputStream inputStream3 = new InputStream(){
            private boolean lf = false;

            public int read() throws IOException {
                if (this.lf) {
                    this.lf = false;
                    return 10;
                }
                int n = inputStream2.read();
                if (10 == n) {
                    this.lf = true;
                    return 43;
                }
                return n;
            }

            public void close() throws IOException {
                super.close();
                inputStream2.close();
            }
        };
        SequenceInputStream sequenceInputStream = new SequenceInputStream(inputStream, inputStream3);
        TextFileSorter textFileSorter = new TextFileSorter(new SortConfig().withMaxMemoryUsage(MERGE_SORT_MAX_MEMORY));
        File file = File.createTempFile("OuputStreamCoverage.intersection", "");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        textFileSorter.sort((InputStream)sequenceInputStream, (OutputStream)fileOutputStream);
        fileOutputStream.close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String string2 = null;
        PrintStream printStream = new PrintStream(outputStream);
        while (null != (string = bufferedReader.readLine())) {
            if (null == string2 && !string.endsWith("+")) {
                string2 = string;
                continue;
            }
            if (null == string2) continue;
            if (string.startsWith(string2) && string.endsWith("+") && string.length() == string2.length() + 1) {
                printStream.println(string2);
                string2 = null;
                continue;
            }
            if (string.endsWith("+")) {
                string2 = null;
                continue;
            }
            string2 = string;
        }
        bufferedReader.close();
        printStream.close();
        file.delete();
    }

    public static long[] toGeoCells(InputStream inputStream) throws IOException {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        int n = 1024;
        long[] lArray = new long[n];
        int n2 = 0;
        while (null != (object = bufferedReader.readLine())) {
            if (((String)object).length() >= 16) continue;
            if (n2 >= lArray.length) {
                long[] lArray2 = lArray;
                lArray = new long[lArray.length + n];
                System.arraycopy(lArray2, 0, lArray, 0, lArray2.length);
            }
            long l = (long)((String)object).length() << 60;
            l |= new BigInteger((String)object, 16).longValue() << 4 * (15 - ((String)object).length());
            lArray[n2++] = l &= -1L << 60 - 4 * ((String)object).length();
        }
        bufferedReader.close();
        if (n2 < lArray.length) {
            object = new long[n2];
            System.arraycopy(lArray, 0, object, 0, n2);
            Arrays.sort((long[])object);
            return object;
        }
        Arrays.sort(lArray);
        return lArray;
    }

    public static void parse(String string, OutputStream outputStream, int n) throws IOException {
        int n2;
        Object object;
        Object object2;
        int n3;
        String[] stringArray = string.split(" ");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            int n4;
            object2 = File.createTempFile("OutputStreamCoverage.parse", "");
            ((File)object2).deleteOnExit();
            arrayList.add(object2);
            object = stringArray[n3].substring(1);
            if (((String)object).startsWith("circle:")) {
                OutputStreamCoverage outputStreamCoverage = new OutputStreamCoverage(new FileOutputStream((File)object2));
                GeoParser.parseCircle(((String)object).substring(7), n, outputStreamCoverage);
                outputStreamCoverage.close();
                continue;
            }
            if (((String)object).startsWith("polygon:")) {
                OutputStreamCoverage outputStreamCoverage = new OutputStreamCoverage(new FileOutputStream((File)object2));
                GeoParser.parsePolygon(((String)object).substring(8), n, outputStreamCoverage);
                outputStreamCoverage.close();
                continue;
            }
            if (((String)object).startsWith("rect:")) {
                OutputStreamCoverage outputStreamCoverage = new OutputStreamCoverage(new FileOutputStream((File)object2));
                GeoParser.parseViewport(((String)object).substring(5), n, outputStreamCoverage);
                outputStreamCoverage.close();
                continue;
            }
            if (((String)object).startsWith("path:")) {
                OutputStreamCoverage outputStreamCoverage = new OutputStreamCoverage(new FileOutputStream((File)object2));
                GeoParser.parsePath(((String)object).substring(5), n, outputStreamCoverage);
                outputStreamCoverage.close();
                continue;
            }
            if (!((String)object).startsWith("polyline:") || -1 == (n4 = ((String)object).substring(9).indexOf(":"))) continue;
            try {
                double d = Double.valueOf(((String)object).substring(9, n4));
                List<Long>[] listArray = GeoParser.parseEncodedPolyline(((String)object).substring(9 + n4 + 1));
                OutputStreamCoverage outputStreamCoverage = new OutputStreamCoverage(new FileOutputStream((File)object2));
                for (int i = 0; i < listArray[0].size() - 1; ++i) {
                    HHCodeHelper.coverSegment(listArray[0].get(i), listArray[1].get(i), listArray[0].get(i + 1), listArray[1].get(i + 1), d, n, outputStreamCoverage);
                }
                outputStreamCoverage.close();
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (n3 = 0; n3 < stringArray.length && !stringArray[n3].startsWith("+"); ++n3) {
        }
        object2 = (File)arrayList.get(n3);
        ++n3;
        while (n3 < stringArray.length) {
            if (stringArray[n3].startsWith("+")) {
                object = File.createTempFile("OutputStreamCoverage.parse", "");
                ((File)object).deleteOnExit();
                arrayList.add(object);
                OutputStreamCoverage.merge(new FileInputStream((File)object2), new FileInputStream((File)arrayList.get(n3)), new FileOutputStream((File)object));
                object2 = object;
            } else if (stringArray[n3].startsWith("-")) {
                object = File.createTempFile("OutputStreamCoverage.parse", "");
                ((File)object).deleteOnExit();
                arrayList.add(object);
                OutputStreamCoverage.minus(new FileInputStream((File)object2), new FileInputStream((File)arrayList.get(n3)), new FileOutputStream((File)object));
                object2 = object;
            } else if (stringArray[n3].startsWith("&")) {
                object = File.createTempFile("OutputStreamCoverage.parse", "");
                ((File)object).deleteOnExit();
                arrayList.add(object);
                OutputStreamCoverage.intersection(new FileInputStream((File)object2), new FileInputStream((File)arrayList.get(n3)), new FileOutputStream((File)object));
                object2 = object;
            }
            ++n3;
        }
        for (int i = 0; i < 16; ++i) {
            File file = File.createTempFile("OutputStreamCoverage.parse", "");
            file.deleteOnExit();
            arrayList.add(file);
            OutputStreamCoverage.optimize(new FileInputStream((File)object2), new FileOutputStream(file), 0L, 0);
            if (((File)object2).length() == file.length()) break;
            object2 = file;
        }
        byte[] byArray = new byte[1024];
        FileInputStream fileInputStream = new FileInputStream((File)object2);
        while ((n2 = ((InputStream)fileInputStream).read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.close();
        for (File file : arrayList) {
            file.delete();
        }
    }

    public static void toKML(InputStream inputStream, Writer writer) throws IOException {
        String string;
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.append("<kml xmlns=\"http://www.opengis.net/kml/2.2\">\n");
        writer.append("<Document>\n");
        writer.append("  <name>GeoXP Coverage</name>\n");
        writer.append("  <ScreenOverlay>\n");
        writer.append("    <overlayXY x=\"0\" y=\"0\" xunits=\"pixels\" yunits=\"pixels\"/>\n");
        writer.append("    <screenXY x=\"20\" y=\"50\" xunits=\"pixels\" yunits=\"pixels\"/>\n");
        writer.append("    <size>-1</size>\n");
        writer.append("    <Icon>\n");
        writer.append("      <href>http://farm5.static.flickr.com/4056/4477523262_bfd831c564_o.png</href>\n");
        writer.append("    </Icon>\n");
        writer.append("  </ScreenOverlay>\n");
        boolean bl = false;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while (null != (string = bufferedReader.readLine())) {
            int n = string.length() * 2;
            long l = new BigInteger((string + "000000000000000").substring(0, 16), 16).longValue();
            double[] dArray = HHCodeHelper.getHHCodeBBox(l, n);
            writer.append("  <Placemark>\n");
            writer.append("  <Style>\n");
            writer.append("    <LineStyle>\n");
            writer.append("      <color>c0008000</color>\n");
            writer.append("      <width>1</width>\n");
            writer.append("    </LineStyle>\n");
            writer.append("    <PolyStyle>\n");
            writer.append("      <color>c0f0f0f0</color>\n");
            writer.append("      <fill>1</fill>\n");
            writer.append("      <outline>1</outline>\n");
            writer.append("    </PolyStyle>\n");
            writer.append("  </Style>\n");
            writer.append("    <name>");
            writer.append(HHCodeHelper.toString(l, n));
            writer.append("</name>\n");
            writer.append("    <MultiGeometry>\n");
            writer.append("      <tessellate>1</tessellate>\n");
            writer.append("      <Polygon><outerBoundaryIs><LinearRing>\n");
            writer.append("        <coordinates>\n");
            writer.append("          ");
            writer.append(Double.toString(dArray[1]));
            writer.append(",");
            writer.append(Double.toString(dArray[0]));
            writer.append(",0\n");
            writer.append("          ");
            writer.append(Double.toString(dArray[1]));
            writer.append(",");
            writer.append(Double.toString(dArray[2]));
            writer.append(",0\n");
            writer.append("          ");
            writer.append(Double.toString(dArray[3]));
            writer.append(",");
            writer.append(Double.toString(dArray[2]));
            writer.append(",0\n");
            writer.append("          ");
            writer.append(Double.toString(dArray[3]));
            writer.append(",");
            writer.append(Double.toString(dArray[0]));
            writer.append(",0\n");
            writer.append("          ");
            writer.append(Double.toString(dArray[1]));
            writer.append(",");
            writer.append(Double.toString(dArray[0]));
            writer.append(",0\n");
            writer.append("        </coordinates>\n");
            writer.append("      </LinearRing></outerBoundaryIs></Polygon>\n");
            if (bl) {
                writer.append("      <Point>\n");
                writer.append("        <coordinates>\n");
                writer.append(Double.toString((dArray[3] + dArray[1]) / 2.0));
                writer.append(",");
                writer.append(Double.toString((dArray[2] + dArray[0]) / 2.0));
                writer.append(",0");
                writer.append("        </coordinates>\n");
                writer.append("      </Point>\n");
            }
            writer.append("    </MultiGeometry>\n");
            writer.append("  </Placemark>\n");
        }
        bufferedReader.close();
        writer.append("</Document>\n");
        writer.append("</kml>\n");
    }

    public void close() throws IOException {
        this.os.close();
    }
}

