/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.sort;

import com.fasterxml.sort.DataReader;
import com.fasterxml.sort.DataReaderFactory;
import com.fasterxml.sort.DataWriterFactory;
import com.fasterxml.sort.IterableSorterException;
import com.fasterxml.sort.SortConfig;
import com.fasterxml.sort.SorterBase;
import com.fasterxml.sort.SortingState;
import com.fasterxml.sort.util.CastingIterator;
import com.fasterxml.sort.util.SegmentedBuffer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IteratingSorter<T>
extends SorterBase<T>
implements Closeable {
    private List<File> _mergerInputs;
    private DataReader<T> _merger;

    public IteratingSorter(SortConfig config, DataReaderFactory<T> readerFactory, DataWriterFactory<T> writerFactory, Comparator<T> comparator) {
        super(config, readerFactory, writerFactory, comparator);
    }

    public IteratingSorter() {
    }

    public IteratingSorter(SortConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterator<T> sort(DataReader<T> inputReader) throws IOException {
        this.close();
        this._phase = SortingState.Phase.PRE_SORTING;
        boolean inputClosed = false;
        SegmentedBuffer buffer = new SegmentedBuffer();
        this._presortFileCount = 0;
        this._sortRoundCount = -1;
        this._currentSortRound = -1;
        Iterator iterator = null;
        try {
            Object[] items = this._readMax(inputReader, buffer, this._config.getMaxMemoryUsage(), null);
            if (this._checkForCancel()) {
                this.close();
                Iterator<T> iterator2 = null;
                return iterator2;
            }
            Arrays.sort(items, this._rawComparator());
            T next = inputReader.readNext();
            if (next == null) {
                inputClosed = true;
                inputReader.close();
                this._phase = SortingState.Phase.SORTING;
                iterator = new CastingIterator(Arrays.asList(items).iterator());
            } else {
                ArrayList<File> presorted = new ArrayList<File>();
                presorted.add(this._writePresorted(items));
                items = null;
                this._presort(inputReader, buffer, next, presorted);
                inputClosed = true;
                inputReader.close();
                this._phase = SortingState.Phase.SORTING;
                if (this._checkForCancel(presorted)) {
                    this.close();
                    Iterator<T> iterator3 = null;
                    return iterator3;
                }
                this._mergerInputs = presorted;
                this._merger = this._createMergeReader(this.merge(presorted));
                iterator = new MergerIterator(this._merger);
            }
        }
        finally {
            if (!inputClosed) {
                try {
                    inputReader.close();
                }
                catch (IOException e) {}
            }
        }
        if (this._checkForCancel()) {
            this.close();
            return null;
        }
        this._phase = SortingState.Phase.COMPLETE;
        return iterator;
    }

    @Override
    public void close() {
        if (this._merger != null) {
            try {
                this._merger.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this._mergerInputs != null) {
            for (File input : this._mergerInputs) {
                input.delete();
            }
        }
        this._mergerInputs = null;
        this._merger = null;
    }

    private static class MergerIterator<T>
    implements Iterator<T> {
        private final DataReader<T> _merger;
        private T _next;

        private MergerIterator(DataReader<T> merger) throws IOException {
            this._merger = merger;
            this._next = this._merger.readNext();
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public T next() {
            if (this._next == null) {
                throw new NoSuchElementException();
            }
            T t = this._next;
            try {
                this._next = this._merger.readNext();
            }
            catch (IOException e) {
                throw new IterableSorterException(e);
            }
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

