/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.sort;

import com.fasterxml.sort.TempFileProvider;
import com.fasterxml.sort.std.StdTempFileProvider;

public class SortConfig {
    public static final long DEFAULT_MEMORY_USAGE = 0x2800000L;
    public static final int DEFAULT_MERGE_FACTOR = 16;
    protected int _mergeFactor;
    protected long _maxMemoryUsage;
    protected TempFileProvider _tempFileProvider;

    public SortConfig() {
        this._mergeFactor = 16;
        this._maxMemoryUsage = 0x2800000L;
        this._tempFileProvider = new StdTempFileProvider();
    }

    protected SortConfig(SortConfig base, int mergeFactor) {
        this._maxMemoryUsage = base._maxMemoryUsage;
        this._mergeFactor = mergeFactor;
        this._tempFileProvider = base._tempFileProvider;
    }

    protected SortConfig(SortConfig base, long maxMem) {
        this._maxMemoryUsage = maxMem;
        this._mergeFactor = base._mergeFactor;
        this._tempFileProvider = base._tempFileProvider;
    }

    protected SortConfig(SortConfig base, TempFileProvider prov) {
        this._mergeFactor = base._mergeFactor;
        this._maxMemoryUsage = base._maxMemoryUsage;
        this._tempFileProvider = prov;
    }

    public int getMergeFactor() {
        return this._mergeFactor;
    }

    public long getMaxMemoryUsage() {
        return this._maxMemoryUsage;
    }

    public TempFileProvider getTempFileProvider() {
        return this._tempFileProvider;
    }

    public SortConfig withMaxMemoryUsage(long maxMem) {
        if (maxMem == this._maxMemoryUsage) {
            return this;
        }
        return new SortConfig(this, maxMem);
    }

    public SortConfig withTempFileProvider(TempFileProvider provider) {
        if (provider == this._tempFileProvider) {
            return this;
        }
        return new SortConfig(this, provider);
    }
}

