/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.sort;

import com.fasterxml.sort.DataReader;
import com.fasterxml.sort.DataReaderFactory;
import com.fasterxml.sort.DataWriter;
import com.fasterxml.sort.DataWriterFactory;
import com.fasterxml.sort.IteratingSorter;
import com.fasterxml.sort.SortConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;

public class Sorter<T>
extends IteratingSorter<T> {
    public Sorter(SortConfig config, DataReaderFactory<T> readerFactory, DataWriterFactory<T> writerFactory, Comparator<T> comparator) {
        super(config, readerFactory, writerFactory, comparator);
    }

    public Sorter() {
    }

    public Sorter(SortConfig config) {
        super(config);
    }

    protected Sorter<T> withReaderFactory(DataReaderFactory<T> f) {
        return new Sorter<T>(this._config, f, this._writerFactory, this._comparator);
    }

    protected Sorter<T> withWriterFactory(DataWriterFactory<T> f) {
        return new Sorter<T>(this._config, this._readerFactory, f, this._comparator);
    }

    protected Sorter<T> withComparator(Comparator<T> cmp) {
        return new Sorter<T>(this._config, this._readerFactory, this._writerFactory, cmp);
    }

    public void sort(InputStream source, OutputStream destination) throws IOException {
        this.sort(this._readerFactory.constructReader(source), this._writerFactory.constructWriter(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sort(DataReader<T> inputReader, DataWriter<T> resultWriter) throws IOException {
        Iterator<T> it = super.sort(inputReader);
        if (it == null) {
            return false;
        }
        try {
            while (it.hasNext()) {
                T value = it.next();
                resultWriter.writeEntry(value);
            }
            resultWriter.close();
        }
        finally {
            super.close();
        }
        return true;
    }
}

