/*
 * Decompiled with CFR 0.152.
 */
package com.etsy.net;

import com.etsy.net.UnixDomainSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UnixDomainSocketServer
extends UnixDomainSocket {
    public UnixDomainSocketServer(String string, int n) throws IOException {
        this.socketFile = string;
        this.socketType = n;
        this.nativeSocketFileHandle = UnixDomainSocketServer.nativeCreate(string, n);
        if (this.nativeSocketFileHandle == -1) {
            throw new IOException("Unable to open Unix domain socket");
        }
        this.in = new UnixDomainSocket.UnixDomainSocketInputStream();
        if (n == 1) {
            this.out = new UnixDomainSocket.UnixDomainSocketOutputStream();
        }
    }

    public UnixDomainSocketServer(String string, int n, int n2) throws IOException {
        this.socketFile = string;
        this.socketType = n;
        this.nativeSocketFileHandle = UnixDomainSocketServer.nativeListen(this.socketFile, this.socketType, n2);
        if (this.nativeSocketFileHandle == -1) {
            throw new IOException("Unable to open and listen on Unix domain socket");
        }
    }

    public UnixDomainSocket accept() throws IOException {
        int n = -1;
        n = UnixDomainSocketServer.nativeAccept(this.nativeSocketFileHandle, this.socketType);
        if (n == -1) {
            throw new IOException("Unable to accept on Unix domain socket");
        }
        return new UnixDomainSocket(n, this.socketType){};
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.out == null) {
            throw new UnsupportedOperationException();
        }
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        if (this.in == null) {
            throw new UnsupportedOperationException();
        }
        return this.in;
    }
}

