/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.client;

import com.geoxp.oss.CryptoHelper;
import com.geoxp.oss.MasterSecretGenerator;
import com.geoxp.oss.OSSException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class OSSRekey {
    public static void main(String[] args) throws Exception {
        String line;
        int len;
        if (args.length < 3) {
            throw new OSSException("Usage: OSSRekey CURRENT_MASTER_SECRET_NAMED_PIPE NEW_MASTER_SECRET_NAMED_PIPE SUFFIX");
        }
        String suffix = args[2];
        byte[] buf = new byte[1024];
        ByteArrayOutputStream currentMasterSecret = new ByteArrayOutputStream();
        ByteArrayOutputStream newMasterSecret = new ByteArrayOutputStream();
        FileInputStream is = new FileInputStream(args[0]);
        while ((len = ((InputStream)is).read(buf)) >= 0) {
            currentMasterSecret.write(buf, 0, len);
        }
        ((InputStream)is).close();
        is = new FileInputStream(args[1]);
        while ((len = ((InputStream)is).read(buf)) >= 0) {
            newMasterSecret.write(buf, 0, len);
        }
        ((InputStream)is).close();
        byte[] currentMS = CryptoHelper.unwrapAES(MasterSecretGenerator.getMasterSecretWrappingKey(), currentMasterSecret.toByteArray());
        byte[] newMS = CryptoHelper.unwrapAES(MasterSecretGenerator.getMasterSecretWrappingKey(), newMasterSecret.toByteArray());
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        long nano = System.nanoTime();
        int count = 0;
        while (null != (line = br.readLine())) {
            int len2;
            baos.reset();
            is = new FileInputStream(line);
            while ((len2 = ((InputStream)is).read(buf)) >= 0) {
                baos.write(buf, 0, len2);
            }
            ((InputStream)is).close();
            byte[] data = CryptoHelper.unwrapBlob(currentMS, baos.toByteArray());
            if (null == data) {
                throw new OSSException("Unable to unwrap data in '" + line + "'");
            }
            FileOutputStream os = new FileOutputStream(line + suffix);
            ((OutputStream)os).write(CryptoHelper.wrapBlob(newMS, data));
            ((OutputStream)os).close();
            ++count;
        }
        nano = System.nanoTime() - nano;
        System.out.println("Rekeyed " + count + " files in " + (double)nano / 1000000.0 + " ms.");
    }
}

