/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.client;

import com.geoxp.oss.CryptoHelper;
import com.geoxp.oss.client.OSSClient;
import com.geoxp.oss.jarjar.org.bouncycastle.openssl.EncryptionException;
import com.geoxp.oss.jarjar.org.bouncycastle.openssl.PEMReader;
import com.geoxp.oss.jarjar.org.bouncycastle.openssl.PasswordFinder;
import com.geoxp.oss.jarjar.org.bouncycastle.util.encoders.Hex;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OSSSshAgentAddIdentity {
    static final String[] SSH_DEFAULT_KEY_FILENAMES = new String[]{"id_dsa", "id_rsa"};

    private static List<File> getDefaultsKeyFiles() {
        String sshDir = System.getProperty("user.home") + File.separator + ".ssh";
        ArrayList<File> result = new ArrayList<File>();
        for (String sshKeyFilename : SSH_DEFAULT_KEY_FILENAMES) {
            File file = new File(sshDir, sshKeyFilename);
            if (!file.canRead()) continue;
            result.add(file);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        List<File> sshKeyFiles;
        if (args.length < 3) {
            System.err.println("Usage: OSSLoadAgent OSS_URL SECRET_NAME WRAPPED_PASSPHRASE AGENT_AUTH_SOCK [KEY_FILE]");
            System.exit(1);
        }
        CryptoHelper.SSHAgentClient sshAgent = new CryptoHelper.SSHAgentClient(args[2]);
        byte[] secret = OSSClient.getSecret(args[0], args[1], null);
        byte[] unwrap = CryptoHelper.unwrapBlob(secret, Hex.decode(args[3]));
        String password = new String(unwrap, "UTF-8");
        if (args.length > 4) {
            sshKeyFiles = new ArrayList<File>(1);
            sshKeyFiles.add(new File(args[4]));
        } else {
            sshKeyFiles = OSSSshAgentAddIdentity.getDefaultsKeyFiles();
        }
        for (File sshKeyFile : sshKeyFiles) {
            BufferedReader fRd = new BufferedReader(new FileReader(sshKeyFile));
            PEMReader pem = new PEMReader(fRd, new DefaultPasswordFinder(password.toCharArray()), "BC");
            try {
                Object o;
                while ((o = pem.readObject()) != null) {
                    if (!(o instanceof KeyPair)) continue;
                    KeyPair kp = (KeyPair)o;
                    byte[] keyblob = CryptoHelper.sshPrivateKeyBlobFromKeyPair(kp);
                    System.out.println("Loading " + sshKeyFile.getPath());
                    sshAgent.addIdentity(keyblob, sshKeyFile.getPath());
                }
            }
            catch (EncryptionException ee) {
                System.err.println("Can't read private key in " + sshKeyFile.getAbsolutePath());
                ee.printStackTrace();
            }
            pem.close();
        }
        System.out.println("Keys in agent:");
        List<CryptoHelper.SSHAgentClient.SSHKey> identities = sshAgent.requestIdentities();
        for (CryptoHelper.SSHAgentClient.SSHKey identity : identities) {
            System.out.println(identity);
        }
    }

    private static class DefaultPasswordFinder
    implements PasswordFinder {
        private final char[] password;

        private DefaultPasswordFinder(char[] password) {
            this.password = password;
        }

        @Override
        public char[] getPassword() {
            return Arrays.copyOf(this.password, this.password.length);
        }
    }
}

