/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.apache.zookeeper.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    ByteBuffer bb;

    public ByteBufferInputStream(ByteBuffer bb) {
        this.bb = bb;
    }

    public int read() throws IOException {
        if (this.bb.remaining() == 0) {
            return -1;
        }
        return this.bb.get() & 0xFF;
    }

    public int available() throws IOException {
        return this.bb.remaining();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bb.remaining() == 0) {
            return -1;
        }
        if (len > this.bb.remaining()) {
            len = this.bb.remaining();
        }
        this.bb.get(b, off, len);
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        long newPos = (long)this.bb.position() + n;
        if (newPos > (long)this.bb.remaining()) {
            n = this.bb.remaining();
        }
        this.bb.position(this.bb.position() + (int)n);
        return n;
    }
}

