/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum;

import com.geoxp.oss.jarjar.org.apache.jute.Record;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.FinalRequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.Request;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.SyncRequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.ZKDatabase;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.ZooKeeperServer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.CommitProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.Follower;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.FollowerRequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.Learner;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.QuorumPeer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.SendAckRequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.txn.TxnHeader;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class FollowerZooKeeperServer
extends LearnerZooKeeperServer {
    private static final Logger LOG = Logger.getLogger(FollowerZooKeeperServer.class);
    CommitProcessor commitProcessor;
    SyncRequestProcessor syncProcessor;
    ConcurrentLinkedQueue<Request> pendingSyncs;
    LinkedBlockingQueue<Request> pendingTxns = new LinkedBlockingQueue();

    FollowerZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
        this.pendingSyncs = new ConcurrentLinkedQueue();
    }

    public Follower getFollower() {
        return this.self.follower;
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true);
        this.commitProcessor.start();
        this.firstProcessor = new FollowerRequestProcessor(this, this.commitProcessor);
        ((FollowerRequestProcessor)this.firstProcessor).start();
        this.syncProcessor = new SyncRequestProcessor(this, new SendAckRequestProcessor(this.getFollower()));
        this.syncProcessor.start();
    }

    public void logRequest(TxnHeader hdr, Record txn) {
        Request request = new Request(null, hdr.getClientId(), hdr.getCxid(), hdr.getType(), null, null);
        request.hdr = hdr;
        request.txn = txn;
        request.zxid = hdr.getZxid();
        if ((request.zxid & 0xFFFFFFFFL) != 0L) {
            this.pendingTxns.add(request);
        }
        this.syncProcessor.processRequest(request);
    }

    public void commit(long zxid) {
        if (this.pendingTxns.size() == 0) {
            LOG.warn((Object)("Committing " + Long.toHexString(zxid) + " without seeing txn"));
            return;
        }
        long firstElementZxid = ((Request)this.pendingTxns.element()).zxid;
        if (firstElementZxid != zxid) {
            LOG.fatal((Object)("Committing zxid 0x" + Long.toHexString(zxid) + " but next pending txn 0x" + Long.toHexString(firstElementZxid)));
            System.exit(12);
        }
        Request request = (Request)this.pendingTxns.remove();
        this.commitProcessor.commit(request);
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn((Object)"Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    public int getGlobalOutstandingLimit() {
        return super.getGlobalOutstandingLimit() / (this.self.getQuorumSize() - 1);
    }

    public void shutdown() {
        try {
            super.shutdown();
        }
        catch (Exception e) {
            LOG.warn((Object)"Ignoring unexpected exception during shutdown", (Throwable)e);
        }
        try {
            if (this.syncProcessor != null) {
                this.syncProcessor.shutdown();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Ignoring unexpected exception in syncprocessor shutdown", (Throwable)e);
        }
    }

    public String getState() {
        return "follower";
    }

    public Learner getLearner() {
        return this.getFollower();
    }
}

