/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum;

import com.geoxp.oss.jarjar.org.apache.zookeeper.KeeperException;
import com.geoxp.oss.jarjar.org.apache.zookeeper.jmx.MBeanRegistry;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.DataTreeBean;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.FinalRequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.PrepRequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.ServerCnxn;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.SessionTrackerImpl;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.ZKDatabase;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.ZooKeeperServer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.CommitProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.Leader;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.LeaderBean;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.LocalPeerBean;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.ProposalRequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.QuorumPeer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import java.io.IOException;

public class LeaderZooKeeperServer
extends QuorumZooKeeperServer {
    CommitProcessor commitProcessor;

    LeaderZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
    }

    public Leader getLeader() {
        return this.self.leader;
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        Leader.ToBeAppliedRequestProcessor toBeAppliedProcessor = new Leader.ToBeAppliedRequestProcessor(finalProcessor, this.getLeader().toBeApplied);
        this.commitProcessor = new CommitProcessor(toBeAppliedProcessor, Long.toString(this.getServerId()), false);
        this.commitProcessor.start();
        ProposalRequestProcessor proposalProcessor = new ProposalRequestProcessor(this, this.commitProcessor);
        proposalProcessor.initialize();
        this.firstProcessor = new PrepRequestProcessor(this, proposalProcessor);
        ((PrepRequestProcessor)this.firstProcessor).start();
    }

    public int getGlobalOutstandingLimit() {
        return super.getGlobalOutstandingLimit() / (this.self.getQuorumSize() - 1);
    }

    public void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.getZKDatabase().getSessionWithTimeOuts(), this.tickTime, this.self.getId());
    }

    protected void startSessionTracker() {
        ((SessionTrackerImpl)this.sessionTracker).start();
    }

    public boolean touch(long sess, int to) {
        return this.sessionTracker.touchSession(sess, to);
    }

    protected void registerJMX() {
        try {
            this.jmxDataTreeBean = new DataTreeBean(this.getZKDatabase().getDataTree());
            MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to register with JMX", (Throwable)e);
            this.jmxDataTreeBean = null;
        }
    }

    public void registerJMX(LeaderBean leaderBean, LocalPeerBean localPeerBean) {
        if (this.self.jmxLeaderElectionBean != null) {
            try {
                MBeanRegistry.getInstance().unregister(this.self.jmxLeaderElectionBean);
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to register with JMX", (Throwable)e);
            }
            this.self.jmxLeaderElectionBean = null;
        }
        try {
            this.jmxServerBean = leaderBean;
            MBeanRegistry.getInstance().register(leaderBean, localPeerBean);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to register with JMX", (Throwable)e);
            this.jmxServerBean = null;
        }
    }

    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxDataTreeBean = null;
    }

    protected void unregisterJMX(Leader leader) {
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to unregister with JMX", (Throwable)e);
        }
        this.jmxServerBean = null;
    }

    public String getState() {
        return "leader";
    }

    public long getServerId() {
        return this.self.getId();
    }

    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException, InterruptedException {
        super.revalidateSession(cnxn, sessionId, sessionTimeout);
        try {
            this.setOwner(sessionId, ServerCnxn.me);
        }
        catch (KeeperException.SessionExpiredException e) {
            // empty catch block
        }
    }
}

