/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum;

import com.geoxp.oss.jarjar.org.apache.jute.BinaryInputArchive;
import com.geoxp.oss.jarjar.org.apache.jute.BinaryOutputArchive;
import com.geoxp.oss.jarjar.org.apache.zookeeper.KeeperException;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.Request;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.ZooTrace;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.Leader;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.LearnerSyncRequest;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.QuorumPacket;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.QuorumPeer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class LearnerHandler
extends Thread {
    private static final Logger LOG = Logger.getLogger(LearnerHandler.class);
    protected final Socket sock;
    final Leader leader;
    long tickOfLastAck;
    protected long sid = 0L;
    final LinkedBlockingQueue<QuorumPacket> queuedPackets = new LinkedBlockingQueue();
    private BinaryInputArchive ia;
    private BinaryOutputArchive oa;
    private BufferedOutputStream bufferedOutput;
    final QuorumPacket proposalOfDeath = new QuorumPacket();
    private QuorumPeer.LearnerType learnerType = QuorumPeer.LearnerType.PARTICIPANT;

    public Socket getSocket() {
        return this.sock;
    }

    long getSid() {
        return this.sid;
    }

    LearnerHandler(Socket sock, Leader leader) throws IOException {
        super("LearnerHandler-" + sock.getRemoteSocketAddress());
        this.sock = sock;
        this.leader = leader;
        leader.addLearnerHandler(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LearnerHandler ").append(this.sock);
        sb.append(" tickOfLastAck:").append(this.tickOfLastAck());
        sb.append(" synced?:").append(this.synced());
        sb.append(" queuedPacketLength:").append(this.queuedPackets.size());
        return sb.toString();
    }

    public QuorumPeer.LearnerType getLearnerType() {
        return this.learnerType;
    }

    private void sendPackets() throws InterruptedException {
        block9: {
            long traceMask = 16L;
            try {
                while (true) {
                    QuorumPacket p;
                    if ((p = this.queuedPackets.poll()) == null) {
                        this.bufferedOutput.flush();
                        p = this.queuedPackets.take();
                    }
                    if (p != this.proposalOfDeath) {
                        if (p.getType() == 5) {
                            traceMask = 128L;
                        }
                        if (LOG.isTraceEnabled()) {
                            ZooTrace.logQuorumPacket(LOG, traceMask, 'o', p);
                        }
                        this.oa.writeRecord(p, "packet");
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (this.sock.isClosed()) break block9;
                LOG.warn((Object)("Unexpected exception at " + this), (Throwable)e);
                try {
                    this.sock.close();
                }
                catch (IOException ie) {
                    LOG.warn((Object)("Error closing socket for handler " + this), (Throwable)ie);
                }
            }
        }
    }

    public static String packetToString(QuorumPacket p) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        QuorumPacket qp;
        block60: {
            block58: {
                this.ia = BinaryInputArchive.getArchive(new BufferedInputStream(this.sock.getInputStream()));
                this.bufferedOutput = new BufferedOutputStream(this.sock.getOutputStream());
                this.oa = BinaryOutputArchive.getArchive(this.bufferedOutput);
                qp = new QuorumPacket();
                this.ia.readRecord(qp, "packet");
                if (qp.getType() == 11 || qp.getType() == 16) break block58;
                LOG.error((Object)("First packet " + qp.toString() + " is not FOLLOWERINFO or OBSERVERINFO!"));
                LOG.warn((Object)("******* GOODBYE " + (this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>") + " ********"));
                try {
                    this.queuedPackets.put(this.proposalOfDeath);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Ignoring unexpected exception", (Throwable)e);
                }
                this.shutdown();
                return;
            }
            if (qp.getData() != null) {
                ByteBuffer bbsid = ByteBuffer.wrap(qp.getData());
                this.sid = bbsid.getLong();
            } else {
                this.sid = this.leader.followerCounter.getAndDecrement();
            }
            LOG.info((Object)("Follower sid: " + this.sid + " : info : " + this.leader.self.quorumPeers.get(this.sid)));
            if (qp.getType() == 16) {
                this.learnerType = QuorumPeer.LearnerType.OBSERVER;
            }
            long peerLastZxid = qp.getZxid();
            int packetToSend = 15;
            long zxidToSend = 0L;
            long leaderLastZxid = 0L;
            long updates = peerLastZxid;
            ReentrantReadWriteLock lock = this.leader.zk.getZKDatabase().getLogLock();
            ReentrantReadWriteLock.ReadLock rl = lock.readLock();
            try {
                rl.lock();
                long maxCommittedLog = this.leader.zk.getZKDatabase().getmaxCommittedLog();
                long minCommittedLog = this.leader.zk.getZKDatabase().getminCommittedLog();
                LOG.info((Object)("Synchronizing with Follower sid: " + this.sid + " maxCommittedLog =" + Long.toHexString(maxCommittedLog) + " minCommittedLog = " + Long.toHexString(minCommittedLog) + " peerLastZxid = " + Long.toHexString(peerLastZxid)));
                LinkedList<Leader.Proposal> proposals = this.leader.zk.getZKDatabase().getCommittedLog();
                if (proposals.size() != 0) {
                    if (maxCommittedLog >= peerLastZxid && minCommittedLog <= peerLastZxid) {
                        long prevProposalZxid = minCommittedLog;
                        boolean firstPacket = true;
                        for (Leader.Proposal propose : proposals) {
                            if (propose.packet.getZxid() <= peerLastZxid) {
                                prevProposalZxid = propose.packet.getZxid();
                                continue;
                            }
                            if (firstPacket) {
                                firstPacket = false;
                                if (prevProposalZxid < peerLastZxid) {
                                    packetToSend = 14;
                                    LOG.info((Object)"Sending TRUNC");
                                    updates = zxidToSend = prevProposalZxid;
                                } else {
                                    packetToSend = 13;
                                    LOG.info((Object)"Sending diff");
                                    zxidToSend = maxCommittedLog;
                                }
                            }
                            this.queuePacket(propose.packet);
                            QuorumPacket qcommit = new QuorumPacket(4, propose.packet.getZxid(), null, null);
                            this.queuePacket(qcommit);
                        }
                    } else if (peerLastZxid > maxCommittedLog) {
                        packetToSend = 14;
                        updates = zxidToSend = maxCommittedLog;
                    }
                }
                if (peerLastZxid == (leaderLastZxid = this.leader.startForwarding(this, updates))) {
                    packetToSend = 13;
                    zxidToSend = leaderLastZxid;
                }
            }
            finally {
                rl.unlock();
            }
            QuorumPacket newLeaderQP = new QuorumPacket(10, leaderLastZxid, null, null);
            this.oa.writeRecord(newLeaderQP, "packet");
            this.bufferedOutput.flush();
            if (packetToSend == 15) {
                zxidToSend = this.leader.zk.getZKDatabase().getDataTreeLastProcessedZxid();
            }
            this.oa.writeRecord(new QuorumPacket(packetToSend, zxidToSend, null, null), "packet");
            this.bufferedOutput.flush();
            if (packetToSend == 15) {
                LOG.info((Object)("Sending snapshot last zxid of peer is 0x" + Long.toHexString(peerLastZxid) + " " + " zxid of leader is 0x" + Long.toHexString(leaderLastZxid) + "sent zxid of db as 0x" + Long.toHexString(zxidToSend)));
                this.leader.zk.getZKDatabase().serializeSnapshot(this.oa);
                this.oa.writeString("BenWasHere", "signature");
            }
            this.bufferedOutput.flush();
            this.queuedPackets.add(new QuorumPacket(12, -1L, null, null));
            new Thread(){

                public void run() {
                    Thread.currentThread().setName("Sender-" + LearnerHandler.this.sock.getRemoteSocketAddress());
                    try {
                        LearnerHandler.this.sendPackets();
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Unexpected interruption", (Throwable)e);
                    }
                }
            }.start();
            qp = new QuorumPacket();
            this.ia.readRecord(qp, "packet");
            if (qp.getType() == 3) break block60;
            LOG.error((Object)"Next packet was supposed to be an ACK");
            LOG.warn((Object)("******* GOODBYE " + (this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>") + " ********"));
            try {
                this.queuedPackets.put(this.proposalOfDeath);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Ignoring unexpected exception", (Throwable)e);
            }
            this.shutdown();
            return;
        }
        try {
            this.leader.processAck(this.sid, qp.getZxid(), this.sock.getLocalSocketAddress());
            LeaderZooKeeperServer leaderZooKeeperServer = this.leader.zk;
            synchronized (leaderZooKeeperServer) {
                while (!this.leader.zk.isRunning()) {
                    this.leader.zk.wait(500L);
                }
            }
            block36: while (true) {
                qp = new QuorumPacket();
                this.ia.readRecord(qp, "packet");
                long traceMask = 16L;
                if (qp.getType() == 5) {
                    traceMask = 128L;
                }
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logQuorumPacket(LOG, traceMask, 'i', qp);
                }
                this.tickOfLastAck = this.leader.self.tick;
                switch (qp.getType()) {
                    case 3: {
                        if (this.learnerType == QuorumPeer.LearnerType.OBSERVER && LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Received ACK from Observer  " + this.sid));
                        }
                        this.leader.processAck(this.sid, qp.getZxid(), this.sock.getLocalSocketAddress());
                        break;
                    }
                    case 5: {
                        int to;
                        ByteArrayInputStream bis = new ByteArrayInputStream(qp.getData());
                        DataInputStream dis = new DataInputStream(bis);
                        while (dis.available() > 0) {
                            long sess = dis.readLong();
                            to = dis.readInt();
                            this.leader.zk.touch(sess, to);
                        }
                        continue block36;
                    }
                    case 6: {
                        ByteArrayInputStream bis = new ByteArrayInputStream(qp.getData());
                        DataInputStream dis = new DataInputStream(bis);
                        long id = dis.readLong();
                        int to = dis.readInt();
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        DataOutputStream dos = new DataOutputStream(bos);
                        dos.writeLong(id);
                        boolean valid = this.leader.zk.touch(id, to);
                        if (valid) {
                            try {
                                this.leader.zk.setOwner(id, this);
                            }
                            catch (KeeperException.SessionExpiredException e) {
                                LOG.error((Object)("Somehow session " + Long.toHexString(id) + " expired right after being renewed! (impossible)"), (Throwable)e);
                            }
                        }
                        if (LOG.isTraceEnabled()) {
                            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(id) + " is valid: " + valid);
                        }
                        dos.writeBoolean(valid);
                        qp.setData(bos.toByteArray());
                        this.queuedPackets.add(qp);
                        break;
                    }
                    case 1: {
                        ByteBuffer bb = ByteBuffer.wrap(qp.getData());
                        long sessionId = bb.getLong();
                        int cxid = bb.getInt();
                        int type = bb.getInt();
                        bb = bb.slice();
                        Request si = type == 9 ? new LearnerSyncRequest(this, sessionId, cxid, type, bb, qp.getAuthinfo()) : new Request(null, sessionId, cxid, type, bb, qp.getAuthinfo());
                        si.setOwner(this);
                        this.leader.zk.submitRequest(si);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            if (this.sock != null && !this.sock.isClosed()) {
                LOG.error((Object)"Unexpected exception causing shutdown while sock still open", (Throwable)e);
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            LOG.warn((Object)("******* GOODBYE " + (this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>") + " ********"));
            try {
                this.queuedPackets.put(this.proposalOfDeath);
            }
            catch (InterruptedException e2) {
                LOG.warn((Object)"Ignoring unexpected exception", (Throwable)e2);
            }
            this.shutdown();
        }
        catch (InterruptedException e) {
            try {
                LOG.error((Object)"Unexpected exception causing shutdown", (Throwable)e);
                LOG.warn((Object)("******* GOODBYE " + (this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>") + " ********"));
            }
            catch (Throwable throwable) {
                LOG.warn((Object)("******* GOODBYE " + (this.sock != null ? this.sock.getRemoteSocketAddress() : "<null>") + " ********"));
                try {
                    this.queuedPackets.put(this.proposalOfDeath);
                }
                catch (InterruptedException e3) {
                    LOG.warn((Object)"Ignoring unexpected exception", (Throwable)e3);
                }
                this.shutdown();
                throw throwable;
            }
            try {
                this.queuedPackets.put(this.proposalOfDeath);
            }
            catch (InterruptedException e4) {
                LOG.warn((Object)"Ignoring unexpected exception", (Throwable)e4);
            }
            this.shutdown();
        }
    }

    public void shutdown() {
        try {
            if (this.sock != null && !this.sock.isClosed()) {
                this.sock.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Ignoring unexpected exception during socket close", (Throwable)e);
        }
        this.interrupt();
        this.leader.removeLearnerHandler(this);
    }

    public long tickOfLastAck() {
        return this.tickOfLastAck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() {
        long id;
        Leader leader = this.leader;
        synchronized (leader) {
            id = this.leader.lastProposed;
        }
        QuorumPacket ping = new QuorumPacket(5, id, null, null);
        this.queuePacket(ping);
    }

    void queuePacket(QuorumPacket p) {
        this.queuedPackets.add(p);
    }

    public boolean synced() {
        return this.isAlive() && this.tickOfLastAck >= (long)(this.leader.self.tick - this.leader.self.syncLimit);
    }
}

