/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum;

import com.geoxp.oss.jarjar.org.apache.zookeeper.server.NIOServerCnxn;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.LocalPeerMXBean;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.QuorumPeer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.ServerBean;

public class LocalPeerBean
extends ServerBean
implements LocalPeerMXBean {
    private final QuorumPeer peer;

    public LocalPeerBean(QuorumPeer peer) {
        this.peer = peer;
    }

    public String getName() {
        return "replica." + this.peer.getId();
    }

    public boolean isHidden() {
        return false;
    }

    public int getTickTime() {
        return this.peer.getTickTime();
    }

    public int getMaxClientCnxnsPerHost() {
        NIOServerCnxn.Factory fac = this.peer.getCnxnFactory();
        if (fac == null) {
            return -1;
        }
        return fac.getMaxClientCnxns();
    }

    public int getMinSessionTimeout() {
        return this.peer.getMinSessionTimeout();
    }

    public int getMaxSessionTimeout() {
        return this.peer.getMaxSessionTimeout();
    }

    public int getInitLimit() {
        return this.peer.getInitLimit();
    }

    public int getSyncLimit() {
        return this.peer.getSyncLimit();
    }

    public int getTick() {
        return this.peer.getTick();
    }

    public String getState() {
        return this.peer.getState().toString();
    }

    public String getQuorumAddress() {
        return this.peer.getQuorumAddress().toString();
    }

    public int getElectionType() {
        return this.peer.getElectionType();
    }
}

