/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum;

import com.geoxp.oss.jarjar.org.apache.zookeeper.server.Request;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.RequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.ZooTrace;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class ObserverRequestProcessor
extends Thread
implements RequestProcessor {
    private static final Logger LOG = Logger.getLogger(ObserverRequestProcessor.class);
    ObserverZooKeeperServer zks;
    RequestProcessor nextProcessor;
    LinkedBlockingQueue<Request> queuedRequests = new LinkedBlockingQueue();
    boolean finished = false;

    public ObserverRequestProcessor(ObserverZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ObserverRequestProcessor:" + zks.getServerId());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
    }

    public void run() {
        try {
            while (!this.finished) {
                Request request = this.queuedRequests.take();
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, 2L, 'F', request, "");
                }
                if (request != Request.requestOfDeath) {
                    this.nextProcessor.processRequest(request);
                    switch (request.type) {
                        case 9: {
                            this.zks.pendingSyncs.add(request);
                            this.zks.getObserver().request(request);
                            break;
                        }
                        case -11: 
                        case -10: 
                        case 1: 
                        case 2: 
                        case 5: 
                        case 7: {
                            this.zks.getObserver().request(request);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected exception causing exit", (Throwable)e);
        }
        LOG.info((Object)"ObserverRequestProcessor exited loop!");
    }

    public void processRequest(Request request) {
        if (!this.finished) {
            this.queuedRequests.add(request);
        }
    }

    public void shutdown() {
        this.finished = true;
        this.queuedRequests.clear();
        this.queuedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }
}

