/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum;

import com.geoxp.oss.jarjar.org.apache.zookeeper.server.FinalRequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.Request;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.SyncRequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.ZKDatabase;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.ZooKeeperServer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.CommitProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.Learner;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.Observer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.ObserverRequestProcessor;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.QuorumPeer;
import com.geoxp.oss.jarjar.org.apache.zookeeper.server.quorum.SendAckRequestProcessor;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public class ObserverZooKeeperServer
extends LearnerZooKeeperServer {
    private static final Logger LOG = Logger.getLogger(ObserverZooKeeperServer.class);
    private CommitProcessor commitProcessor;
    private SyncRequestProcessor syncProcessor;
    ConcurrentLinkedQueue<Request> pendingSyncs = new ConcurrentLinkedQueue();

    ObserverZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
    }

    public Observer getObserver() {
        return this.self.observer;
    }

    public Learner getLearner() {
        return this.self.observer;
    }

    public void commitRequest(Request request) {
        this.commitProcessor.commit(request);
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true);
        this.commitProcessor.start();
        this.firstProcessor = new ObserverRequestProcessor(this, this.commitProcessor);
        ((ObserverRequestProcessor)this.firstProcessor).start();
        this.syncProcessor = new SyncRequestProcessor(this, new SendAckRequestProcessor(this.getObserver()));
        this.syncProcessor.start();
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn((Object)"Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    public String getState() {
        return "observer";
    }
}

