/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1InputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Primitive;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.DERPrintableString;
import com.geoxp.oss.jarjar.org.bouncycastle.util.Strings;
import java.io.IOException;

public abstract class X509NameEntryConverter {
    protected ASN1Primitive convertHexEncoded(String string, int n) throws IOException {
        string = Strings.toLowerCase(string);
        byte[] byArray = new byte[(string.length() - n) / 2];
        for (int i = 0; i != byArray.length; ++i) {
            char c = string.charAt(i * 2 + n);
            char c2 = string.charAt(i * 2 + n + 1);
            byArray[i] = c < 'a' ? (byte)(c - 48 << 4) : (byte)(c - 97 + 10 << 4);
            if (c2 < 'a') {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] | (byte)(c2 - 48));
                continue;
            }
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] | (byte)(c2 - 97 + 10));
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        return aSN1InputStream.readObject();
    }

    protected boolean canBePrintable(String string) {
        return DERPrintableString.isPrintableString(string);
    }

    public abstract ASN1Primitive getConvertedValue(ASN1ObjectIdentifier var1, String var2);
}

