/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.bcpg;

import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGInputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGOutputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.ContainedPacket;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ExperimentalPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private int tag;
    private byte[] contents;

    ExperimentalPacket(int n, BCPGInputStream bCPGInputStream) throws IOException {
        this.tag = n;
        if (bCPGInputStream.available() != 0) {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bCPGInputStream.available());
            while ((n2 = bCPGInputStream.read()) >= 0) {
                byteArrayOutputStream.write(n2);
            }
            this.contents = byteArrayOutputStream.toByteArray();
        } else {
            this.contents = new byte[0];
        }
    }

    public int getTag() {
        return this.tag;
    }

    public byte[] getContents() {
        byte[] byArray = new byte[this.contents.length];
        System.arraycopy(this.contents, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(this.tag, this.contents, true);
    }
}

