/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cert.ocsp;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Exception;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1InputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Primitive;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ocsp.OCSPResponse;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ocsp.ResponseBytes;
import com.geoxp.oss.jarjar.org.bouncycastle.cert.CertIOException;
import com.geoxp.oss.jarjar.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import com.geoxp.oss.jarjar.org.bouncycastle.cert.ocsp.OCSPException;
import java.io.IOException;

public class OCSPResp {
    private OCSPResponse resp;

    public OCSPResp(OCSPResponse oCSPResponse) {
        this.resp = oCSPResponse;
    }

    public OCSPResp(byte[] byArray) throws IOException {
        this(new ASN1InputStream(byArray));
    }

    private OCSPResp(ASN1InputStream aSN1InputStream) throws IOException {
        try {
            this.resp = OCSPResponse.getInstance(aSN1InputStream.readObject());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed response: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed response: " + classCastException.getMessage(), classCastException);
        }
        catch (ASN1Exception aSN1Exception) {
            throw new CertIOException("malformed response: " + aSN1Exception.getMessage(), aSN1Exception);
        }
    }

    public int getStatus() {
        return this.resp.getResponseStatus().getValue().intValue();
    }

    public Object getResponseObject() throws OCSPException {
        ResponseBytes responseBytes = this.resp.getResponseBytes();
        if (responseBytes == null) {
            return null;
        }
        if (responseBytes.getResponseType().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
            try {
                ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(responseBytes.getResponse().getOctets());
                return new BasicOCSPResp(BasicOCSPResponse.getInstance(aSN1Primitive));
            }
            catch (Exception exception) {
                throw new OCSPException("problem decoding object: " + exception, exception);
            }
        }
        return responseBytes.getResponse();
    }

    public byte[] getEncoded() throws IOException {
        return this.resp.getEncoded();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OCSPResp)) {
            return false;
        }
        OCSPResp oCSPResp = (OCSPResp)object;
        return this.resp.equals(oCSPResp.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }
}

