/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cms;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Encodable;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1EncodableVector;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Generator;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1OctetStringParser;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Primitive;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Sequence;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1SequenceParser;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Set;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1SetParser;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1StreamParser;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1TaggedObject;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.BERGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.BERSequenceGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.BERSetParser;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.BERTaggedObject;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.DERSet;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.DERTaggedObject;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.ContentInfoParser;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.SignedDataParser;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.SignerInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AttributeCertificate;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.Certificate;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.CertificateList;
import com.geoxp.oss.jarjar.org.bouncycastle.cert.X509AttributeCertificateHolder;
import com.geoxp.oss.jarjar.org.bouncycastle.cert.X509CRLHolder;
import com.geoxp.oss.jarjar.org.bouncycastle.cert.X509CertificateHolder;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSContentInfoParser;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSException;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSSignedHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSTypedStream;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSUtils;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.SignerInformation;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.SignerInformationStore;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.DigestCalculator;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.DigestCalculatorProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.OperatorCreationException;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.util.CollectionStore;
import com.geoxp.oss.jarjar.org.bouncycastle.util.Store;
import com.geoxp.oss.jarjar.org.bouncycastle.util.io.Streams;
import com.geoxp.oss.jarjar.org.bouncycastle.x509.NoSuchStoreException;
import com.geoxp.oss.jarjar.org.bouncycastle.x509.X509Store;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private static final CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    private SignedDataParser _signedData;
    private ASN1ObjectIdentifier _signedContentType;
    private CMSTypedStream _signedContent;
    private Map digests;
    private SignerInformationStore _signerInfoStore;
    private X509Store _attributeStore;
    private ASN1Set _certSet;
    private ASN1Set _crlSet;
    private boolean _isCertCrlParsed;
    private X509Store _certificateStore;
    private X509Store _crlStore;

    public CMSSignedDataParser(byte[] byArray) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), (InputStream)new ByteArrayInputStream(byArray));
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, byte[] byArray) throws CMSException {
        this(digestCalculatorProvider, (InputStream)new ByteArrayInputStream(byArray));
    }

    public CMSSignedDataParser(CMSTypedStream cMSTypedStream, byte[] byArray) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), cMSTypedStream, new ByteArrayInputStream(byArray));
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream cMSTypedStream, byte[] byArray) throws CMSException {
        this(digestCalculatorProvider, cMSTypedStream, new ByteArrayInputStream(byArray));
    }

    private static DigestCalculatorProvider createDefaultDigestProvider() throws CMSException {
        return new BcDigestCalculatorProvider();
    }

    public CMSSignedDataParser(InputStream inputStream) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), null, inputStream);
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, InputStream inputStream) throws CMSException {
        this(digestCalculatorProvider, null, inputStream);
    }

    public CMSSignedDataParser(CMSTypedStream cMSTypedStream, InputStream inputStream) throws CMSException {
        this(CMSSignedDataParser.createDefaultDigestProvider(), cMSTypedStream, inputStream);
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream cMSTypedStream, InputStream inputStream) throws CMSException {
        super(inputStream);
        try {
            Object object;
            Object object2;
            ASN1Encodable aSN1Encodable;
            this._signedContent = cMSTypedStream;
            this._signedData = SignedDataParser.getInstance(this._contentInfo.getContent(16));
            this.digests = new HashMap();
            ASN1SetParser aSN1SetParser = this._signedData.getDigestAlgorithms();
            while ((aSN1Encodable = aSN1SetParser.readObject()) != null) {
                object2 = AlgorithmIdentifier.getInstance(aSN1Encodable);
                try {
                    object = digestCalculatorProvider.get((AlgorithmIdentifier)object2);
                    if (object == null) continue;
                    this.digests.put(((AlgorithmIdentifier)object2).getAlgorithm(), object);
                }
                catch (OperatorCreationException operatorCreationException) {}
            }
            object2 = this._signedData.getEncapContentInfo();
            object = (ASN1OctetStringParser)((ContentInfoParser)object2).getContent(4);
            if (object != null) {
                CMSTypedStream cMSTypedStream2 = new CMSTypedStream(((ContentInfoParser)object2).getContentType().getId(), object.getOctetStream());
                if (this._signedContent == null) {
                    this._signedContent = cMSTypedStream2;
                } else {
                    cMSTypedStream2.drain();
                }
            }
            this._signedContentType = cMSTypedStream == null ? ((ContentInfoParser)object2).getContentType() : this._signedContent.getContentType();
        }
        catch (IOException iOException) {
            throw new CMSException("io exception: " + iOException.getMessage(), iOException);
        }
        if (this.digests.isEmpty()) {
            throw new CMSException("no digests could be created for message.");
        }
    }

    public int getVersion() {
        return this._signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this._signerInfoStore == null) {
            this.populateCertCrlSets();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            HashMap hashMap = new HashMap();
            for (Object object : this.digests.keySet()) {
                hashMap.put(object, ((DigestCalculator)this.digests.get(object)).getDigest());
            }
            try {
                ASN1Encodable aSN1Encodable;
                Object object;
                object = this._signedData.getSignerInfos();
                while ((aSN1Encodable = object.readObject()) != null) {
                    SignerInfo signerInfo = SignerInfo.getInstance(aSN1Encodable.toASN1Primitive());
                    byte[] byArray = (byte[])hashMap.get(signerInfo.getDigestAlgorithm().getAlgorithm());
                    arrayList.add(new SignerInformation(signerInfo, this._signedContentType, null, byArray));
                }
            }
            catch (IOException iOException) {
                throw new CMSException("io exception: " + iOException.getMessage(), iOException);
            }
            this._signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this._signerInfoStore;
    }

    public X509Store getAttributeCertificates(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getAttributeCertificates(string, CMSUtils.getProvider(string2));
    }

    public X509Store getAttributeCertificates(String string, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._attributeStore == null) {
            this.populateCertCrlSets();
            this._attributeStore = HELPER.createAttributeStore(string, provider, this._certSet);
        }
        return this._attributeStore;
    }

    public X509Store getCertificates(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getCertificates(string, CMSUtils.getProvider(string2));
    }

    public X509Store getCertificates(String string, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._certificateStore == null) {
            this.populateCertCrlSets();
            this._certificateStore = HELPER.createCertificateStore(string, provider, this._certSet);
        }
        return this._certificateStore;
    }

    public X509Store getCRLs(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        return this.getCRLs(string, CMSUtils.getProvider(string2));
    }

    public X509Store getCRLs(String string, Provider provider) throws NoSuchStoreException, CMSException {
        if (this._crlStore == null) {
            this.populateCertCrlSets();
            this._crlStore = HELPER.createCRLsStore(string, provider, this._crlSet);
        }
        return this._crlStore;
    }

    public CertStore getCertificatesAndCRLs(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.getCertificatesAndCRLs(string, CMSUtils.getProvider(string2));
    }

    public CertStore getCertificatesAndCRLs(String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        this.populateCertCrlSets();
        return HELPER.createCertStore(string, provider, this._certSet, this._crlSet);
    }

    public Store getCertificates() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set aSN1Set = this._certSet;
        if (aSN1Set != null) {
            ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(aSN1Set.size());
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive();
                if (!(aSN1Primitive instanceof ASN1Sequence)) continue;
                arrayList.add(new X509CertificateHolder(Certificate.getInstance(aSN1Primitive)));
            }
            return new CollectionStore(arrayList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getCRLs() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set aSN1Set = this._crlSet;
        if (aSN1Set != null) {
            ArrayList<X509CRLHolder> arrayList = new ArrayList<X509CRLHolder>(aSN1Set.size());
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive();
                if (!(aSN1Primitive instanceof ASN1Sequence)) continue;
                arrayList.add(new X509CRLHolder(CertificateList.getInstance(aSN1Primitive)));
            }
            return new CollectionStore(arrayList);
        }
        return new CollectionStore(new ArrayList());
    }

    public Store getAttributeCertificates() throws CMSException {
        this.populateCertCrlSets();
        ASN1Set aSN1Set = this._certSet;
        if (aSN1Set != null) {
            ArrayList<X509AttributeCertificateHolder> arrayList = new ArrayList<X509AttributeCertificateHolder>(aSN1Set.size());
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1TaggedObject aSN1TaggedObject;
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive();
                if (!(aSN1Primitive instanceof ASN1TaggedObject) || (aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive).getTagNo() != 2) continue;
                arrayList.add(new X509AttributeCertificateHolder(AttributeCertificate.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, false))));
            }
            return new CollectionStore(arrayList);
        }
        return new CollectionStore(new ArrayList());
    }

    private void populateCertCrlSets() throws CMSException {
        if (this._isCertCrlParsed) {
            return;
        }
        this._isCertCrlParsed = true;
        try {
            this._certSet = CMSSignedDataParser.getASN1Set(this._signedData.getCertificates());
            this._crlSet = CMSSignedDataParser.getASN1Set(this._signedData.getCrls());
        }
        catch (IOException iOException) {
            throw new CMSException("problem parsing cert/crl sets", iOException);
        }
    }

    public String getSignedContentTypeOID() {
        return this._signedContentType.getId();
    }

    public CMSTypedStream getSignedContent() {
        if (this._signedContent == null) {
            return null;
        }
        InputStream inputStream = CMSUtils.attachDigestsToInputStream(this.digests.values(), this._signedContent.getContentStream());
        return new CMSTypedStream(this._signedContent.getContentType(), inputStream);
    }

    public static OutputStream replaceSigners(InputStream inputStream, SignerInformationStore signerInformationStore, OutputStream outputStream) throws CMSException, IOException {
        Object object2;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream);
        ContentInfoParser contentInfoParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser.readObject());
        SignedDataParser signedDataParser = SignedDataParser.getInstance(contentInfoParser.getContent(16));
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(signedDataParser.getVersion());
        signedDataParser.getDigestAlgorithms().toASN1Primitive();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (Object object2 : signerInformationStore.getSigners()) {
            aSN1EncodableVector.add(CMSSignedHelper.INSTANCE.fixAlgID(((SignerInformation)object2).getDigestAlgorithmID()));
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
        ContentInfoParser contentInfoParser2 = signedDataParser.getEncapContentInfo();
        object2 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        ((BERSequenceGenerator)object2).addObject(contentInfoParser2.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(contentInfoParser2, ((BERGenerator)object2).getRawOutputStream());
        ((BERSequenceGenerator)object2).close();
        CMSSignedDataParser.writeSetToGeneratorTagged(bERSequenceGenerator2, signedDataParser.getCertificates(), 0);
        CMSSignedDataParser.writeSetToGeneratorTagged(bERSequenceGenerator2, signedDataParser.getCrls(), 1);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (SignerInformation signerInformation : signerInformationStore.getSigners()) {
            aSN1EncodableVector2.add(signerInformation.toASN1Structure());
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector2).getEncoded());
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        return outputStream;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream inputStream, CertStore certStore, OutputStream outputStream) throws CMSException, IOException {
        ASN1Set aSN1Set;
        ASN1Set aSN1Set2;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream);
        ContentInfoParser contentInfoParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser.readObject());
        SignedDataParser signedDataParser = SignedDataParser.getInstance(contentInfoParser.getContent(16));
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(signedDataParser.getVersion());
        bERSequenceGenerator2.getRawOutputStream().write(signedDataParser.getDigestAlgorithms().toASN1Primitive().getEncoded());
        ContentInfoParser contentInfoParser2 = signedDataParser.getEncapContentInfo();
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(contentInfoParser2.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(contentInfoParser2, bERSequenceGenerator3.getRawOutputStream());
        bERSequenceGenerator3.close();
        CMSSignedDataParser.getASN1Set(signedDataParser.getCertificates());
        CMSSignedDataParser.getASN1Set(signedDataParser.getCrls());
        try {
            aSN1Set2 = CMSUtils.createBerSetFromList(CMSUtils.getCertificatesFromStore(certStore));
        }
        catch (CertStoreException certStoreException) {
            throw new CMSException("error getting certs from certStore", certStoreException);
        }
        if (aSN1Set2.size() > 0) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 0, aSN1Set2).getEncoded());
        }
        try {
            aSN1Set = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(certStore));
        }
        catch (CertStoreException certStoreException) {
            throw new CMSException("error getting crls from certStore", certStoreException);
        }
        if (aSN1Set.size() > 0) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 1, aSN1Set).getEncoded());
        }
        bERSequenceGenerator2.getRawOutputStream().write(signedDataParser.getSignerInfos().toASN1Primitive().getEncoded());
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        return outputStream;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream inputStream, Store store, Store store2, Store store3, OutputStream outputStream) throws CMSException, IOException {
        Object object;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream);
        ContentInfoParser contentInfoParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser.readObject());
        SignedDataParser signedDataParser = SignedDataParser.getInstance(contentInfoParser.getContent(16));
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(signedDataParser.getVersion());
        bERSequenceGenerator2.getRawOutputStream().write(signedDataParser.getDigestAlgorithms().toASN1Primitive().getEncoded());
        ContentInfoParser contentInfoParser2 = signedDataParser.getEncapContentInfo();
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(contentInfoParser2.getContentType());
        CMSSignedDataParser.pipeEncapsulatedOctetString(contentInfoParser2, bERSequenceGenerator3.getRawOutputStream());
        bERSequenceGenerator3.close();
        CMSSignedDataParser.getASN1Set(signedDataParser.getCertificates());
        CMSSignedDataParser.getASN1Set(signedDataParser.getCrls());
        if (store != null || store3 != null) {
            ASN1Set aSN1Set;
            object = new ArrayList();
            if (store != null) {
                object.addAll(CMSUtils.getCertificatesFromStore(store));
            }
            if (store3 != null) {
                object.addAll(CMSUtils.getAttributeCertificatesFromStore(store3));
            }
            if ((aSN1Set = CMSUtils.createBerSetFromList((List)object)).size() > 0) {
                bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 0, aSN1Set).getEncoded());
            }
        }
        if (store2 != null && ((ASN1Set)(object = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(store2)))).size() > 0) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 1, (ASN1Encodable)object).getEncoded());
        }
        bERSequenceGenerator2.getRawOutputStream().write(signedDataParser.getSignerInfos().toASN1Primitive().getEncoded());
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        return outputStream;
    }

    private static void writeSetToGeneratorTagged(ASN1Generator aSN1Generator, ASN1SetParser aSN1SetParser, int n) throws IOException {
        ASN1Set aSN1Set = CMSSignedDataParser.getASN1Set(aSN1SetParser);
        if (aSN1Set != null) {
            if (aSN1SetParser instanceof BERSetParser) {
                aSN1Generator.getRawOutputStream().write(new BERTaggedObject(false, n, aSN1Set).getEncoded());
            } else {
                aSN1Generator.getRawOutputStream().write(new DERTaggedObject(false, n, aSN1Set).getEncoded());
            }
        }
    }

    private static ASN1Set getASN1Set(ASN1SetParser aSN1SetParser) {
        return aSN1SetParser == null ? null : ASN1Set.getInstance(aSN1SetParser.toASN1Primitive());
    }

    private static void pipeEncapsulatedOctetString(ContentInfoParser contentInfoParser, OutputStream outputStream) throws IOException {
        ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)contentInfoParser.getContent(4);
        if (aSN1OctetStringParser != null) {
            CMSSignedDataParser.pipeOctetString(aSN1OctetStringParser, outputStream);
        }
    }

    private static void pipeOctetString(ASN1OctetStringParser aSN1OctetStringParser, OutputStream outputStream) throws IOException {
        OutputStream outputStream2 = CMSUtils.createBEROctetOutputStream(outputStream, 0, true, 0);
        Streams.pipeAll(aSN1OctetStringParser.getOctetStream(), outputStream2);
        outputStream2.close();
    }
}

