/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.cms;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Encodable;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1EncodableVector;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1TaggedObject;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.BERSequenceGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.BERTaggedObject;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.DERInteger;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.DERSet;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.AttributeTable;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cms.SignerInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSAttributeTableGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSException;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSProcessable;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSSignedGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSSignedHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSStreamException;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.CMSUtils;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.SignerInfoGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.SignerInformation;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.SimpleAttributeTableGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.ContentSigner;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.OperatorCreationException;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private int _bufferSize;

    public CMSSignedDataStreamGenerator() {
    }

    public CMSSignedDataStreamGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void setBufferSize(int n) {
        this._bufferSize = n;
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, attributeTable, attributeTable2, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, attributeTable, attributeTable2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, x509Certificate, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, string2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, AttributeTable attributeTable, AttributeTable attributeTable2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, attributeTable, attributeTable2, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, AttributeTable attributeTable, AttributeTable attributeTable2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string2));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, byArray, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, CMSUtils.getProvider(string3));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(privateKey, byArray, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider, provider);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider, Provider provider2) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(privateKey, x509Certificate, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider, provider2);
    }

    private void doAddSigner(PrivateKey privateKey, Object object, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider, Provider provider2) throws NoSuchAlgorithmException, InvalidKeyException {
        JcaContentSignerBuilder jcaContentSignerBuilder;
        String string3 = CMSSignedHelper.INSTANCE.getDigestAlgName(string2);
        String string4 = string3 + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(string);
        try {
            jcaContentSignerBuilder = new JcaContentSignerBuilder(string4).setSecureRandom(this.rand);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new NoSuchAlgorithmException(illegalArgumentException.getMessage());
        }
        if (provider != null) {
            jcaContentSignerBuilder.setProvider(provider);
        }
        try {
            JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();
            if (provider2 != null && !provider2.getName().equalsIgnoreCase("SunRsaSign")) {
                jcaDigestCalculatorProviderBuilder.setProvider(provider2);
            }
            JcaSignerInfoGeneratorBuilder jcaSignerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(jcaDigestCalculatorProviderBuilder.build());
            jcaSignerInfoGeneratorBuilder.setSignedAttributeGenerator(cMSAttributeTableGenerator);
            jcaSignerInfoGeneratorBuilder.setUnsignedAttributeGenerator(cMSAttributeTableGenerator2);
            try {
                ContentSigner contentSigner = jcaContentSignerBuilder.build(privateKey);
                if (object instanceof X509Certificate) {
                    this.addSignerInfoGenerator(jcaSignerInfoGeneratorBuilder.build(contentSigner, (X509Certificate)object));
                } else {
                    this.addSignerInfoGenerator(jcaSignerInfoGeneratorBuilder.build(contentSigner, (byte[])object));
                }
            }
            catch (OperatorCreationException operatorCreationException) {
                if (operatorCreationException.getCause() instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)operatorCreationException.getCause();
                }
                if (operatorCreationException.getCause() instanceof InvalidKeyException) {
                    throw (InvalidKeyException)operatorCreationException.getCause();
                }
            }
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new NoSuchAlgorithmException("unable to create operators: " + operatorCreationException.getMessage());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IllegalStateException("unable to encode certificate");
        }
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, Provider provider, Provider provider2) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(privateKey, byArray, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, provider, provider2);
    }

    public OutputStream open(OutputStream outputStream) throws IOException {
        return this.open(outputStream, false);
    }

    public OutputStream open(OutputStream outputStream, boolean bl) throws IOException {
        return this.open(CMSObjectIdentifiers.data, outputStream, bl);
    }

    public OutputStream open(OutputStream outputStream, boolean bl, OutputStream outputStream2) throws IOException {
        return this.open(CMSObjectIdentifiers.data, outputStream, bl, outputStream2);
    }

    public OutputStream open(OutputStream outputStream, String string, boolean bl) throws IOException {
        return this.open(outputStream, string, bl, null);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, boolean bl) throws IOException {
        return this.open(aSN1ObjectIdentifier, outputStream, bl, null);
    }

    public OutputStream open(OutputStream outputStream, String string, boolean bl, OutputStream outputStream2) throws IOException {
        return this.open(new ASN1ObjectIdentifier(string), outputStream, bl, outputStream2);
    }

    public OutputStream open(ASN1ObjectIdentifier aSN1ObjectIdentifier, OutputStream outputStream, boolean bl, OutputStream outputStream2) throws IOException {
        Object object2;
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(this.calculateVersion(aSN1ObjectIdentifier));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (Object object2 : this._signers) {
            aSN1EncodableVector.add(CMSSignedHelper.INSTANCE.fixAlgID(((SignerInformation)object2).getDigestAlgorithmID()));
        }
        for (Object object2 : this.signerGens) {
            aSN1EncodableVector.add(((SignerInfoGenerator)object2).getDigestAlgorithm());
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(aSN1ObjectIdentifier);
        object2 = bl ? CMSUtils.createBEROctetOutputStream(bERSequenceGenerator3.getRawOutputStream(), 0, true, this._bufferSize) : null;
        OutputStream outputStream3 = CMSUtils.getSafeTeeOutputStream(outputStream2, (OutputStream)object2);
        OutputStream outputStream4 = CMSUtils.attachSignersToOutputStream(this.signerGens, outputStream3);
        return new CmsSignedDataOutputStream(outputStream4, aSN1ObjectIdentifier, bERSequenceGenerator, bERSequenceGenerator2, bERSequenceGenerator3);
    }

    void generate(OutputStream outputStream, String string, boolean bl, OutputStream outputStream2, CMSProcessable cMSProcessable) throws CMSException, IOException {
        OutputStream outputStream3 = this.open(outputStream, string, bl, outputStream2);
        if (cMSProcessable != null) {
            cMSProcessable.write(outputStream3);
        }
        outputStream3.close();
    }

    private DERInteger calculateVersion(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.certs != null) {
            for (Object e : this.certs) {
                if (!(e instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)e;
                if (aSN1TaggedObject.getTagNo() == 1) {
                    bl3 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() == 2) {
                    bl4 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() != 3) continue;
                bl = true;
            }
        }
        if (bl) {
            return new DERInteger(5);
        }
        if (this.crls != null) {
            for (Object e : this.crls) {
                if (!(e instanceof ASN1TaggedObject)) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return new DERInteger(5);
        }
        if (bl4) {
            return new DERInteger(4);
        }
        if (bl3) {
            return new DERInteger(3);
        }
        if (this.checkForVersion3(this._signers)) {
            return new DERInteger(3);
        }
        if (!CMSObjectIdentifiers.data.equals(aSN1ObjectIdentifier)) {
            return new DERInteger(3);
        }
        return new DERInteger(1);
    }

    private boolean checkForVersion3(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SignerInfo signerInfo = SignerInfo.getInstance(((SignerInformation)iterator.next()).toASN1Structure());
            if (signerInfo.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private ASN1ObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream outputStream, ASN1ObjectIdentifier aSN1ObjectIdentifier, BERSequenceGenerator bERSequenceGenerator, BERSequenceGenerator bERSequenceGenerator2, BERSequenceGenerator bERSequenceGenerator3) {
            this._out = outputStream;
            this._contentOID = aSN1ObjectIdentifier;
            this._sGen = bERSequenceGenerator;
            this._sigGen = bERSequenceGenerator2;
            this._eiGen = bERSequenceGenerator3;
        }

        public void write(int n) throws IOException {
            this._out.write(n);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._out.write(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this._out.write(byArray);
        }

        public void close() throws IOException {
            Object object;
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this.digests.clear();
            if (CMSSignedDataStreamGenerator.this.certs.size() != 0) {
                object = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, (ASN1Encodable)object).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this.crls.size() != 0) {
                object = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, (ASN1Encodable)object).getEncoded());
            }
            object = new ASN1EncodableVector();
            for (Object object2 : CMSSignedDataStreamGenerator.this.signerGens) {
                try {
                    ((ASN1EncodableVector)object).add(((SignerInfoGenerator)object2).generate(this._contentOID));
                    byte[] byArray = ((SignerInfoGenerator)object2).getCalculatedDigest();
                    CMSSignedDataStreamGenerator.this.digests.put(((SignerInfoGenerator)object2).getDigestAlgorithm().getAlgorithm().getId(), byArray);
                }
                catch (CMSException cMSException) {
                    throw new CMSStreamException("exception generating signers: " + cMSException.getMessage(), cMSException);
                }
            }
            for (Object object2 : CMSSignedDataStreamGenerator.this._signers) {
                ((ASN1EncodableVector)object).add(((SignerInformation)object2).toASN1Structure());
            }
            this._sigGen.getRawOutputStream().write(new DERSet((ASN1EncodableVector)object).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }
}

